/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.verification;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.matching.MatchResult;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.diff.Diff;

public class NearMiss
implements Comparable<NearMiss> {
    private final LoggedRequest request;
    private final StubMapping mapping;
    private final RequestPattern requestPattern;
    private final MatchResult matchResult;

    @JsonCreator
    public NearMiss(@JsonProperty(value="request") LoggedRequest request, @JsonProperty(value="stubMapping") StubMapping mapping, @JsonProperty(value="requestPattern") RequestPattern requestPattern, @JsonProperty(value="matchResult") MatchResult matchResult) {
        this.request = request;
        this.mapping = mapping;
        this.requestPattern = requestPattern;
        this.matchResult = matchResult;
    }

    public NearMiss(LoggedRequest request, StubMapping mapping, MatchResult matchResult) {
        this(request, mapping, null, matchResult);
    }

    public NearMiss(LoggedRequest request, RequestPattern requestPattern, MatchResult matchResult) {
        this(request, null, requestPattern, matchResult);
    }

    public LoggedRequest getRequest() {
        return this.request;
    }

    public StubMapping getStubMapping() {
        return this.mapping;
    }

    public RequestPattern getRequestPattern() {
        return this.requestPattern;
    }

    public MatchResult getMatchResult() {
        return this.matchResult;
    }

    @Override
    public int compareTo(NearMiss o) {
        return o.getMatchResult().compareTo(this.matchResult);
    }

    @JsonIgnore
    public Diff getDiff() {
        if (this.requestPattern != null) {
            return new Diff(this.requestPattern, (Request)this.request);
        }
        return new Diff(this.getStubMapping(), (Request)this.request);
    }

    public String toString() {
        return this.getDiff().toString();
    }
}

