/*
 * Decompiled with CFR 0.152.
 */
package com.github.trevershick.test.ldap.junit4;

import com.github.trevershick.test.ldap.LdapServerResource;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LdapServerRule
implements TestRule {
    private LdapServerResource ldapServer;
    private Object target;

    public LdapServerRule() {
    }

    public LdapServerRule(Object target) {
        this.target = target;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LdapServerRule.this.ldapServer = new LdapServerResource(LdapServerRule.this.target);
                try {
                    LdapServerRule.this.ldapServer.start();
                    base.evaluate();
                }
                finally {
                    if (LdapServerRule.this.ldapServer.isStarted()) {
                        LdapServerRule.this.ldapServer.stop();
                    }
                }
                LdapServerRule.this.ldapServer = null;
            }
        };
    }

    public int port() {
        return this.ldapServer.port();
    }

    public boolean serverIsStarted() {
        return this.ldapServer != null && this.ldapServer.isStarted();
    }

    public boolean serverIsStopped() {
        return this.ldapServer != null && this.ldapServer.isStopped();
    }

    public boolean isUsingSchema() throws Exception {
        return this.ldapServer.isUsingSchema();
    }

    LdapServerResource getServer() {
        return this.ldapServer;
    }
}

