/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.core.env.PropertySource;
import org.springframework.util.Assert;

public class EncryptablePropertySourceWrapper<T>
extends PropertySource<T>
implements EncryptablePropertySource<T> {
    private final PropertySource<T> delegate;
    private final StringEncryptor encryptor;

    public EncryptablePropertySourceWrapper(PropertySource<T> delegate, StringEncryptor encryptor) {
        super(delegate.getName(), delegate.getSource());
        Assert.notNull(delegate, (String)"PropertySource delegate cannot be null");
        Assert.notNull((Object)encryptor, (String)"StringEncryptor cannot be null");
        this.delegate = delegate;
        this.encryptor = encryptor;
    }

    public Object getProperty(String name) {
        return this.getProperty(this.encryptor, this.delegate, name);
    }
}

