/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.detector;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertyDetector;
import org.springframework.util.Assert;

public class DefaultPropertyDetector
implements EncryptablePropertyDetector {
    private String prefix = "ENC(";
    private String suffix = ")";

    public DefaultPropertyDetector() {
    }

    public DefaultPropertyDetector(String prefix, String suffix) {
        Assert.notNull((Object)prefix, (String)"Prefix can't be null");
        Assert.notNull((Object)suffix, (String)"Suffix can't be null");
        this.prefix = prefix;
        this.suffix = suffix;
    }

    @Override
    public boolean isEncrypted(String property) {
        if (property == null) {
            return false;
        }
        String trimmedValue = property.trim();
        return trimmedValue.startsWith(this.prefix) && trimmedValue.endsWith(this.suffix);
    }

    @Override
    public String unwrapEncryptedValue(String property) {
        return property.substring(this.prefix.length(), property.length() - this.suffix.length());
    }
}

