/*
 * Decompiled with CFR 0.152.
 */
package com.ulisesbocchio.jasyptspringboot.caching;

import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

@Order(value=-2147483648)
public class RefreshScopeRefreshedEventListener
implements ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(RefreshScopeRefreshedEventListener.class);
    public static final String REFRESHED_EVENT_CLASS = "org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent";
    private final ConfigurableEnvironment environment;

    public RefreshScopeRefreshedEventListener(ConfigurableEnvironment environment) {
        this.environment = environment;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        Class refreshedClass;
        ClassLoader classLoader = this.getClass().getClassLoader();
        boolean refreshedPresent = ClassUtils.isPresent((String)REFRESHED_EVENT_CLASS, (ClassLoader)classLoader);
        if (refreshedPresent && ClassUtils.isAssignableValue((Class)(refreshedClass = ClassUtils.forName((String)REFRESHED_EVENT_CLASS, (ClassLoader)classLoader)), (Object)event)) {
            log.info("Refreshing cached encryptable property sources");
            this.refreshCachedProperties();
        }
    }

    private void refreshCachedProperties() {
        MutablePropertySources propertySources = this.environment.getPropertySources();
        propertySources.forEach(this::refreshPropertySource);
    }

    private void refreshPropertySource(PropertySource<?> propertySource) {
        if (propertySource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)propertySource;
            cps.getPropertySources().forEach(this::refreshPropertySource);
        } else if (propertySource instanceof EncryptablePropertySource) {
            EncryptablePropertySource eps = (EncryptablePropertySource)propertySource;
            eps.refresh();
        }
    }
}

