/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springboot.autoconfigure.data.jest;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.github.vanroy.springboot.autoconfigure.data.jest.ElasticsearchJestProperties;
import com.google.common.base.Supplier;
import io.searchbox.client.JestClientFactory;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.aws.core.region.RegionProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;
import vc.inreach.aws.request.AWSSigner;
import vc.inreach.aws.request.AWSSigningRequestInterceptor;

@Configuration
@ConditionalOnClass(value={AWSSigner.class})
@AutoConfigureAfter(name={"org.springframework.cloud.aws.autoconfigure.context.ContextRegionProviderAutoConfiguration", "org.springframework.cloud.aws.autoconfigure.context.ContextCredentialsAutoConfiguration"})
public class ElasticsearchJestAWSAutoConfiguration {
    private static final String AWS_SERVICE = "es";
    private static final Supplier<LocalDateTime> CLOCK = () -> LocalDateTime.now(ZoneOffset.UTC);
    @Autowired
    private ElasticsearchJestProperties properties;
    @Autowired
    @Qualifier(value="elasticsearchJestAwsRegion")
    private String regionName;

    @Bean
    @ConditionalOnMissingBean(value={AWSCredentialsProvider.class})
    public AWSCredentialsProvider awsCredentialsProvider() {
        return new DefaultAWSCredentialsProviderChain();
    }

    @Bean
    public JestClientFactory jestClientFactory(AWSCredentialsProvider credentialsProvider) {
        AWSSigner awsSigner = new AWSSigner(credentialsProvider, this.getRegion(), AWS_SERVICE, CLOCK);
        final AWSSigningRequestInterceptor requestInterceptor = new AWSSigningRequestInterceptor(awsSigner);
        return new JestClientFactory(){

            protected HttpClientBuilder configureHttpClient(HttpClientBuilder builder) {
                builder.addInterceptorLast((HttpRequestInterceptor)requestInterceptor);
                return builder;
            }

            protected HttpAsyncClientBuilder configureHttpClient(HttpAsyncClientBuilder builder) {
                builder.addInterceptorLast((HttpRequestInterceptor)requestInterceptor);
                return builder;
            }
        };
    }

    private String getRegion() {
        if (StringUtils.hasText((String)this.properties.getAwsRegion())) {
            return this.properties.getAwsRegion();
        }
        return this.regionName;
    }

    @ConditionalOnMissingBean(name={"elasticsearchJestAwsRegion"})
    @Bean(name={"elasticsearchJestAwsRegion"})
    public String regionFromEC2() {
        Region region = Regions.getCurrentRegion();
        if (region != null) {
            return region.getName();
        }
        return Regions.DEFAULT_REGION.getName();
    }

    @ConditionalOnClass(value={RegionProvider.class})
    @ConditionalOnBean(value={RegionProvider.class})
    private static final class RegionFromSpringCloudConfiguration {
        private RegionFromSpringCloudConfiguration() {
        }

        @Bean(name={"elasticsearchJestAwsRegion"})
        public String regionFromSpringCloud(RegionProvider regionProvider) {
            return regionProvider.getRegion().getName();
        }
    }
}

