/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springboot.autoconfigure.data.jest;

import java.util.Collections;
import java.util.List;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.data.jest")
public class ElasticsearchJestProperties {
    private List<String> uris;
    private String username;
    private String password;
    private String awsRegion;
    private String defaultSchemeForDiscoveredNodes = "https";
    private String discoveryEnabled;
    private int maxTotalConnection = 50;
    private int defaultMaxTotalConnectionPerRoute = 50;
    private int readTimeout = 5000;
    private long maxConnectionIdleTime = 0L;
    private Boolean multiThreaded = true;
    private final Proxy proxy = new Proxy();

    public Proxy getProxy() {
        return this.proxy;
    }

    public List<String> getUris() {
        return this.uris;
    }

    public void setUris(List<String> uris) {
        this.uris = uris;
    }

    public void setUri(String uri) {
        this.uris = Collections.singletonList(uri);
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxTotalConnection() {
        return this.maxTotalConnection;
    }

    public void setMaxTotalConnection(int maxTotalConnection) {
        this.maxTotalConnection = maxTotalConnection;
    }

    public int getDefaultMaxTotalConnectionPerRoute() {
        return this.defaultMaxTotalConnectionPerRoute;
    }

    public void setDefaultMaxTotalConnectionPerRoute(int defaultMaxTotalConnectionPerRoute) {
        this.defaultMaxTotalConnectionPerRoute = defaultMaxTotalConnectionPerRoute;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getMaxConnectionIdleTime() {
        return this.maxConnectionIdleTime;
    }

    public void setMaxConnectionIdleTime(long maxConnectionIdleTime) {
        this.maxConnectionIdleTime = maxConnectionIdleTime;
    }

    public Boolean getMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(Boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }

    public void setAwsRegion(String awsRegion) {
        this.awsRegion = awsRegion;
    }

    public String getDefaultSchemeForDiscoveredNodes() {
        return this.defaultSchemeForDiscoveredNodes;
    }

    public void setDefaultSchemeForDiscoveredNodes(String defaultSchemeForDiscoveredNodes) {
        this.defaultSchemeForDiscoveredNodes = defaultSchemeForDiscoveredNodes;
    }

    public String getDiscoveryEnabled() {
        return this.discoveryEnabled;
    }

    public void setDiscoveryEnabled(String discoveryEnabled) {
        this.discoveryEnabled = discoveryEnabled;
    }

    public static class Proxy {
        private String host;
        private Integer port;

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }
    }
}

