/*
 * Decompiled with CFR 0.152.
 */
package com.github.vanroy.springdata.jest.internal;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.client.JestResult;
import java.util.LinkedList;
import java.util.List;

public class MultiDocumentResult
extends JestResult {
    public MultiDocumentResult(JestResult source) {
        super(source);
    }

    public List<MultiDocumentResultItem> getItems() {
        LinkedList<MultiDocumentResultItem> items = new LinkedList<MultiDocumentResultItem>();
        if (this.jsonObject != null && this.jsonObject.has("docs")) {
            for (JsonElement jsonElement : this.jsonObject.getAsJsonArray("docs")) {
                if (!jsonElement.getAsJsonObject().get("found").getAsBoolean()) continue;
                items.add(new MultiDocumentResultItem(jsonElement));
            }
        }
        return items;
    }

    public static class MultiDocumentResultItem {
        private final JsonObject jsonObject;

        public MultiDocumentResultItem(JsonElement jsonElement) {
            this.jsonObject = jsonElement.getAsJsonObject();
        }

        public String getId() {
            return this.getAsString(this.jsonObject.get("_id"));
        }

        private String getAsString(JsonElement jsonElement) {
            if (jsonElement == null) {
                return null;
            }
            return jsonElement.getAsString();
        }

        public String getSource() {
            return this.jsonObject.get("_source").toString();
        }
    }
}

