/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BandwidthDefinition;
import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;

public final class BucketConfiguration
implements Serializable {
    public static final long INITIAL_TOKENS_UNSPECIFIED = -1L;
    private final Bandwidth[] bandwidths;
    private final long[] bandwidthsInitialTokens;
    private final TimeMeter timeMeter;

    public BucketConfiguration(List<BandwidthDefinition> bandwidths, TimeMeter timeMeter) {
        if (timeMeter == null) {
            throw BucketExceptions.nullTimeMeter();
        }
        this.timeMeter = timeMeter;
        if (bandwidths.isEmpty()) {
            throw BucketExceptions.restrictionsNotSpecified();
        }
        this.bandwidths = new Bandwidth[bandwidths.size()];
        this.bandwidthsInitialTokens = new long[bandwidths.size()];
        for (int i = 0; i < bandwidths.size(); ++i) {
            this.bandwidths[i] = bandwidths.get(i).getBandwidth();
            this.bandwidthsInitialTokens[i] = bandwidths.get(i).getInitialTokens();
        }
    }

    public TimeMeter getTimeMeter() {
        return this.timeMeter;
    }

    public Bandwidth[] getBandwidths() {
        return this.bandwidths;
    }

    public long[] getBandwidthsInitialTokens() {
        return this.bandwidthsInitialTokens;
    }

    public String toString() {
        return "BucketConfiguration{bandwidths=" + Arrays.toString(this.bandwidths) + ", timeMeter=" + this.timeMeter + '}';
    }
}

