/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.BucketExceptions;
import java.io.Serializable;
import java.time.Duration;

public class Refill
implements Serializable {
    private final long periodNanos;
    private final long tokens;

    private Refill(long tokens, Duration period) {
        if (tokens <= 0L) {
            throw BucketExceptions.nonPositivePeriodTokens(tokens);
        }
        this.tokens = tokens;
        if (period == null) {
            throw BucketExceptions.nullPeriod();
        }
        this.periodNanos = period.toNanos();
        if (this.periodNanos <= 0L) {
            throw BucketExceptions.nonPositivePeriod(this.periodNanos);
        }
        if (tokens > this.periodNanos) {
            throw BucketExceptions.tooHighRefillRate(this.periodNanos, tokens);
        }
    }

    public static Refill smooth(long tokens, Duration period) {
        return new Refill(tokens, period);
    }

    long getPeriodNanos() {
        return this.periodNanos;
    }

    long getTokens() {
        return this.tokens;
    }

    public String toString() {
        return "Refill{periodNanos=" + this.periodNanos + ", tokens=" + this.tokens + '}';
    }
}

