/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketConfiguration;
import java.io.Serializable;
import java.util.Arrays;

public class BucketState
implements Serializable {
    private static final int LAST_REFILL_TIME_OFFSET = 0;
    final long[] stateData;

    BucketState(long[] stateData) {
        this.stateData = stateData;
    }

    public BucketState(BucketConfiguration configuration) {
        Bandwidth[] bandwidths = configuration.getBandwidths();
        long[] bandwidthsInitialTokens = configuration.getBandwidthsInitialTokens();
        this.stateData = new long[1 + bandwidths.length * 2];
        long currentTimeNanos = configuration.getTimeMeter().currentTimeNanos();
        for (int i = 0; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long initialTokens = bandwidthsInitialTokens[i];
            if (initialTokens == -1L) {
                initialTokens = bandwidth.capacity;
            }
            this.setCurrentSize(i, initialTokens);
        }
        this.setLastRefillTimeNanos(currentTimeNanos);
    }

    public BucketState copy() {
        return new BucketState((long[])this.stateData.clone());
    }

    public void copyStateFrom(BucketState sourceState) {
        System.arraycopy(sourceState.stateData, 0, this.stateData, 0, this.stateData.length);
    }

    public static BucketState createInitialState(BucketConfiguration configuration) {
        return new BucketState(configuration);
    }

    public long getAvailableTokens(Bandwidth[] bandwidths) {
        long availableTokens = this.getCurrentSize(0);
        for (int i = 1; i < bandwidths.length; ++i) {
            availableTokens = Math.min(availableTokens, this.getCurrentSize(i));
        }
        return availableTokens;
    }

    public void consume(Bandwidth[] bandwidths, long toConsume) {
        for (int i = 0; i < bandwidths.length; ++i) {
            this.consume(i, toConsume);
        }
    }

    public long delayNanosAfterWillBePossibleToConsume(Bandwidth[] bandwidths, long tokensToConsume) {
        long delayAfterWillBePossibleToConsume = this.delayNanosAfterWillBePossibleToConsume(0, bandwidths[0], tokensToConsume);
        for (int i = 1; i < bandwidths.length; ++i) {
            Bandwidth bandwidth = bandwidths[i];
            long delay = this.delayNanosAfterWillBePossibleToConsume(i, bandwidth, tokensToConsume);
            if (delay <= (delayAfterWillBePossibleToConsume = Math.max(delayAfterWillBePossibleToConsume, delay))) continue;
            delayAfterWillBePossibleToConsume = delay;
        }
        return delayAfterWillBePossibleToConsume;
    }

    public void refillAllBandwidth(Bandwidth[] limits, long currentTimeNanos) {
        long lastRefillTimeNanos = this.getLastRefillTimeNanos();
        if (currentTimeNanos <= lastRefillTimeNanos) {
            return;
        }
        for (int i = 0; i < limits.length; ++i) {
            this.refill(i, limits[i], lastRefillTimeNanos, currentTimeNanos);
        }
        this.setLastRefillTimeNanos(currentTimeNanos);
    }

    public void addTokens(Bandwidth[] limits, long tokensToAdd) {
        for (int i = 0; i < limits.length; ++i) {
            this.addTokens(i, limits[i], tokensToAdd);
        }
    }

    private void addTokens(int bandwidthIndex, Bandwidth bandwidth, long tokensToAdd) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        long newSize = currentSize + tokensToAdd;
        if (newSize >= bandwidth.capacity) {
            this.setCurrentSize(bandwidthIndex, bandwidth.capacity);
            this.setRoundingError(bandwidthIndex, 0L);
        } else {
            this.setCurrentSize(bandwidthIndex, newSize);
        }
    }

    private void consume(int bandwidth, long tokens) {
        int n = 1 + bandwidth * 2;
        this.stateData[n] = this.stateData[n] - tokens;
    }

    private void refill(int bandwidthIndex, Bandwidth bandwidth, long previousRefillNanos, long currentTimeNanos) {
        long roundingError;
        long capacity = bandwidth.capacity;
        long currentSize = this.getCurrentSize(bandwidthIndex);
        if (currentSize >= capacity) {
            this.setCurrentSize(bandwidthIndex, capacity);
            this.setRoundingError(bandwidthIndex, 0L);
            return;
        }
        long durationSinceLastRefillNanos = currentTimeNanos - previousRefillNanos;
        long refillPeriod = bandwidth.refill.getPeriodNanos();
        long refillTokens = bandwidth.refill.getTokens();
        long divided = refillTokens * durationSinceLastRefillNanos + (roundingError = this.getRoundingError(bandwidthIndex));
        long calculatedRefill = divided / refillPeriod;
        if (calculatedRefill == 0L) {
            this.setRoundingError(bandwidthIndex, divided);
            return;
        }
        long newSize = currentSize + calculatedRefill;
        if (newSize >= capacity) {
            this.setCurrentSize(bandwidthIndex, capacity);
            this.setRoundingError(bandwidthIndex, 0L);
            return;
        }
        roundingError = divided % refillPeriod;
        this.setCurrentSize(bandwidthIndex, newSize);
        this.setRoundingError(bandwidthIndex, roundingError);
    }

    private long delayNanosAfterWillBePossibleToConsume(int bandwidthIndex, Bandwidth bandwidth, long tokens) {
        long currentSize = this.getCurrentSize(bandwidthIndex);
        if (tokens <= currentSize) {
            return 0L;
        }
        long deficit = tokens - currentSize;
        long periodNanos = bandwidth.refill.getPeriodNanos();
        return periodNanos * deficit / bandwidth.refill.getTokens();
    }

    long getCurrentSize(int bandwidth) {
        return this.stateData[1 + bandwidth * 2];
    }

    long getRoundingError(int bandwidth) {
        return this.stateData[2 + bandwidth * 2];
    }

    private void setCurrentSize(int bandwidth, long currentSize) {
        this.stateData[1 + bandwidth * 2] = currentSize;
    }

    private void setRoundingError(int bandwidth, long roundingError) {
        this.stateData[2 + bandwidth * 2] = roundingError;
    }

    private long getLastRefillTimeNanos() {
        return this.stateData[0];
    }

    private void setLastRefillTimeNanos(long nanos) {
        this.stateData[0] = nanos;
    }

    public String toString() {
        return "BucketState{, bandwidthStates=" + Arrays.toString(this.stateData) + '}';
    }
}

