/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.local;

import io.github.bucket4j.AbstractBucket;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BlockingStrategy;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.BucketState;
import io.github.bucket4j.ConsumptionProbe;
import io.github.bucket4j.TimeMeter;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class SynchronizedBucket
extends AbstractBucket {
    private final BucketConfiguration configuration;
    private final Bandwidth[] bandwidths;
    private final TimeMeter timeMeter;
    private final BucketState state;
    private final Lock lock;

    public SynchronizedBucket(BucketConfiguration configuration) {
        this(configuration, new ReentrantLock());
    }

    public SynchronizedBucket(BucketConfiguration configuration, Lock lock) {
        this.configuration = configuration;
        this.bandwidths = configuration.getBandwidths();
        this.timeMeter = configuration.getTimeMeter();
        this.state = BucketState.createInitialState(configuration);
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long consumeAsMuchAsPossibleImpl(long limit) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            long toConsume = Math.min(limit, availableToConsume);
            if (toConsume == 0L) {
                long l = 0L;
                return l;
            }
            this.state.consume(this.bandwidths, toConsume);
            long l = toConsume;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryConsumeImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                boolean bl = false;
                return bl;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConsumptionProbe tryConsumeAndReturnRemainingTokensImpl(long tokensToConsume) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long availableToConsume = this.state.getAvailableTokens(this.bandwidths);
            if (tokensToConsume > availableToConsume) {
                long nanosToWaitForRefill = this.state.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
                ConsumptionProbe consumptionProbe = ConsumptionProbe.rejected(availableToConsume, nanosToWaitForRefill);
                return consumptionProbe;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
            ConsumptionProbe consumptionProbe = ConsumptionProbe.consumed(availableToConsume - tokensToConsume);
            return consumptionProbe;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean consumeOrAwaitImpl(long tokensToConsume, long waitIfBusyNanosLimit, boolean uninterruptibly, BlockingStrategy blockingStrategy) throws InterruptedException {
        long nanosToCloseDeficit;
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            nanosToCloseDeficit = this.state.delayNanosAfterWillBePossibleToConsume(this.bandwidths, tokensToConsume);
            if (nanosToCloseDeficit == 0L) {
                this.state.consume(this.bandwidths, tokensToConsume);
                boolean bl = true;
                return bl;
            }
            if (waitIfBusyNanosLimit > 0L && nanosToCloseDeficit > waitIfBusyNanosLimit) {
                boolean bl = false;
                return bl;
            }
            this.state.consume(this.bandwidths, tokensToConsume);
        }
        finally {
            this.lock.unlock();
        }
        if (uninterruptibly) {
            blockingStrategy.parkUninterruptibly(nanosToCloseDeficit);
        } else {
            blockingStrategy.park(nanosToCloseDeficit);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void addTokensImpl(long tokensToAdd) {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            this.state.addTokens(this.bandwidths, tokensToAdd);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAvailableTokens() {
        long currentTimeNanos = this.timeMeter.currentTimeNanos();
        this.lock.lock();
        try {
            this.state.refillAllBandwidth(this.bandwidths, currentTimeNanos);
            long l = this.state.getAvailableTokens(this.bandwidths);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public BucketState createSnapshot() {
        this.lock.lock();
        try {
            BucketState bucketState = this.state.copy();
            return bucketState;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public BucketConfiguration getConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        SynchronizedBucket synchronizedBucket = this;
        synchronized (synchronizedBucket) {
            return "SynchronizedBucket{state=" + this.state + ", configuration=" + this.getConfiguration() + '}';
        }
    }
}

