/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast;

import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.IMap;
import io.github.bucket4j.BucketConfiguration;
import io.github.bucket4j.grid.CommandResult;
import io.github.bucket4j.grid.GridBucketState;
import io.github.bucket4j.grid.GridCommand;
import io.github.bucket4j.grid.GridProxy;
import io.github.bucket4j.grid.hazelcast.HazelcastEntryProcessorAdapter;
import io.github.bucket4j.grid.jcache.JCacheEntryProcessor;
import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class HazelcastProxy<K extends Serializable>
implements GridProxy<K> {
    private final IMap<K, GridBucketState> cache;

    public HazelcastProxy(IMap<K, GridBucketState> cache) {
        this.cache = cache;
    }

    public <T extends Serializable> CommandResult<T> execute(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return (CommandResult)this.cache.executeOnKey(key, this.adoptEntryProcessor(entryProcessor));
    }

    public void createInitialState(K key, BucketConfiguration configuration) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateProcessor((BucketConfiguration)configuration);
        this.cache.executeOnKey(key, this.adoptEntryProcessor(entryProcessor));
    }

    public <T extends Serializable> T createInitialStateAndExecute(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CommandResult result = (CommandResult)this.cache.executeOnKey(key, this.adoptEntryProcessor(entryProcessor));
        return (T)result.getData();
    }

    public <T extends Serializable> CompletableFuture<CommandResult<T>> executeAsync(K key, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.executeProcessor(command);
        return this.invokeAsync(key, entryProcessor);
    }

    public <T extends Serializable> CompletableFuture<T> createInitialStateAndExecuteAsync(K key, BucketConfiguration configuration, GridCommand<T> command) {
        JCacheEntryProcessor entryProcessor = JCacheEntryProcessor.initStateAndExecuteProcessor(command, (BucketConfiguration)configuration);
        CompletableFuture<CommandResult<T>> result = this.invokeAsync(key, entryProcessor);
        return result.thenApply(CommandResult::getData);
    }

    public Optional<BucketConfiguration> getConfiguration(K key) {
        GridBucketState state = (GridBucketState)this.cache.get(key);
        if (state == null) {
            return Optional.empty();
        }
        return Optional.of(state.getConfiguration());
    }

    public boolean isAsyncModeSupported() {
        return true;
    }

    private <T extends Serializable> EntryProcessor adoptEntryProcessor(JCacheEntryProcessor<K, T> entryProcessor) {
        return new HazelcastEntryProcessorAdapter<K, T>(entryProcessor);
    }

    private <T extends Serializable> CompletableFuture<CommandResult<T>> invokeAsync(K key, JCacheEntryProcessor<K, T> entryProcessor) {
        return this.cache.submitToKey(key, this.adoptEntryProcessor(entryProcessor)).toCompletableFuture();
    }
}

