/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.grid.hazelcast.serialization;

import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.TypedStreamDeserializer;
import io.github.bucket4j.Bucket4j;
import io.github.bucket4j.grid.hazelcast.serialization.HazelcastSerializationAdapter;
import io.github.bucket4j.serialization.DeserializationAdapter;
import io.github.bucket4j.serialization.SerializationAdapter;
import io.github.bucket4j.serialization.SerializationHandle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class HazelcastSerializer<T>
implements StreamSerializer<T>,
TypedStreamDeserializer<T> {
    private static HazelcastSerializationAdapter ADAPTER = new HazelcastSerializationAdapter();
    private final int typeId;
    private final SerializationHandle<T> serializationHandle;

    public static void addCustomSerializers(SerializationConfig serializationConfig, int typeIdBase) {
        for (HazelcastSerializer<?> serializer : HazelcastSerializer.getAllSerializers(typeIdBase)) {
            serializationConfig.addSerializerConfig(new SerializerConfig().setImplementation(serializer).setTypeClass(serializer.getSerializableType()));
        }
    }

    public static List<HazelcastSerializer<?>> getAllSerializers(int typeIdBase) {
        ArrayList serializers = new ArrayList();
        for (SerializationHandle serializationHandle : Bucket4j.getSerializationHandles()) {
            serializers.add(new HazelcastSerializer(serializationHandle.getTypeId() + typeIdBase, serializationHandle));
        }
        return serializers;
    }

    public HazelcastSerializer(int typeId, SerializationHandle<T> serializationHandle) {
        this.typeId = typeId;
        this.serializationHandle = serializationHandle;
    }

    public HazelcastSerializer(SerializationHandle<T> serializationHandle) {
        this.typeId = serializationHandle.getTypeId();
        this.serializationHandle = serializationHandle;
    }

    public HazelcastSerializer<T> withBaseTypeId(int baseTypeId) {
        return new HazelcastSerializer<T>(this.typeId + baseTypeId, this.serializationHandle);
    }

    public Class<T> getSerializableType() {
        return this.serializationHandle.getSerializedType();
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void destroy() {
    }

    public void write(ObjectDataOutput out, T serializable) throws IOException {
        this.serializationHandle.serialize((SerializationAdapter)ADAPTER, (Object)out, serializable);
    }

    public T read(ObjectDataInput in) throws IOException {
        return this.read0(in);
    }

    public T read(ObjectDataInput in, Class aClass) throws IOException {
        return this.read0(in);
    }

    private T read0(ObjectDataInput in) throws IOException {
        return (T)this.serializationHandle.deserialize((DeserializationAdapter)ADAPTER, (Object)in);
    }
}

