/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlTemplate;
import htmlflow.HtmlView;
import htmlflow.HtmlVisitorPrintStream;
import htmlflow.HtmlVisitorStringBuilder;
import java.io.PrintStream;
import java.util.function.BiConsumer;

public class DynamicHtml<T>
extends HtmlView<T> {
    private static final String WRONG_USE_OF_RENDER_WITHOUT_MODEL = "Wrong use of DynamicView! You should provide a model parameter or use a static view instead!";
    private HtmlTemplate<T> template;
    private BiConsumer<DynamicHtml<T>, T> binder;

    public static <U> DynamicHtml<U> view(PrintStream out, HtmlTemplate<U> template) {
        return new DynamicHtml<U>(out, template);
    }

    public static <U> DynamicHtml<U> view(PrintStream out, BiConsumer<DynamicHtml<U>, U> binder) {
        return new DynamicHtml<U>(out, binder);
    }

    public static <U> DynamicHtml<U> view(HtmlTemplate<U> template) {
        return new DynamicHtml<U>(template);
    }

    public static <U> DynamicHtml<U> view(BiConsumer<DynamicHtml<U>, U> binder) {
        return new DynamicHtml<U>(binder);
    }

    private DynamicHtml(PrintStream out, HtmlTemplate<T> template) {
        this.setVisitor(() -> new HtmlVisitorPrintStream(out, true));
        this.template = template;
    }

    private DynamicHtml(PrintStream out, BiConsumer<DynamicHtml<T>, T> binder) {
        this.setVisitor(() -> new HtmlVisitorPrintStream(out, true));
        this.binder = binder;
    }

    private DynamicHtml(HtmlTemplate<T> template) {
        this.setVisitor(() -> new HtmlVisitorStringBuilder(true));
        this.template = template;
    }

    private DynamicHtml(BiConsumer<DynamicHtml<T>, T> binder) {
        this.setVisitor(() -> new HtmlVisitorStringBuilder(true));
        this.binder = binder;
    }

    @Override
    public String render() {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException("Wrong use of render(). Use write() rather than render() to output to PrintStream. To get a String from render() you must use view() without a PrintStream ");
        }
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITHOUT_MODEL);
    }

    @Override
    public String render(T model) {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException("Wrong use of render(). Use write() rather than render() to output to PrintStream. To get a String from render() you must use view() without a PrintStream ");
        }
        this.binder.accept(this, (DynamicHtml)model);
        return this.getVisitor().finished();
    }

    public String render(T model, HtmlView ... partials) {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException("Wrong use of render(). Use write() rather than render() to output to PrintStream. To get a String from render() you must use view() without a PrintStream ");
        }
        this.template.resolve(this, model, partials);
        return this.getVisitor().finished();
    }

    @Override
    public void write() {
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITHOUT_MODEL);
    }

    @Override
    public void write(T model) {
        this.binder.accept(this, (DynamicHtml)model);
        this.getVisitor().finished();
    }

    public void write(T model, HtmlView ... partials) {
        this.template.resolve(this, model, partials);
        this.getVisitor().finished();
    }
}

