/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlVisitorCache;
import htmlflow.HtmlVisitorPrintStream;
import htmlflow.HtmlVisitorStringBuilder;
import htmlflow.HtmlWriter;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.xmlet.htmlapifaster.Div;
import org.xmlet.htmlapifaster.Element;
import org.xmlet.htmlapifaster.Html;
import org.xmlet.htmlapifaster.Root;
import org.xmlet.htmlapifaster.Tr;

public abstract class HtmlView<T>
implements HtmlWriter<T>,
Element<HtmlView, Element> {
    static final String WRONG_USE_OF_PRINTSTREAM_ON_THREADSAFE_VIEWS = "Cannot use PrintStream output for thread-safe views!";
    static final String WRONG_USE_OF_THREADSAFE_ON_VIEWS_WITH_PRINTSTREAM = "Cannot set thread-safety for views with PrintStream output!";
    static final String WRONG_USE_OF_RENDER_WITH_PRINTSTREAM = "Wrong use of render(). Use write() rather than render() to output to PrintStream. To get a String from render() you must use view() without a PrintStream ";
    private static final String HEADER;
    private static final String NEWLINE;
    private static final String HEADER_TEMPLATE = "templates/HtmlView-Header.txt";
    private HtmlVisitorCache visitor;
    private ThreadLocal<HtmlVisitorCache> threadLocalVisitor;
    private Supplier<HtmlVisitorCache> visitorSupplier;
    private boolean threadSafe = false;

    public Html<HtmlView> html() {
        if (this.getVisitor().isWriting()) {
            this.getVisitor().write(HEADER);
        }
        return new Html((Element)this);
    }

    public Div<HtmlView> div() {
        return new Div((Element)this);
    }

    public Tr<HtmlView> tr() {
        return new Tr((Element)this);
    }

    public Root<HtmlView> defineRoot() {
        return new Root((Element)this);
    }

    @Override
    public HtmlWriter<T> setPrintStream(PrintStream out) {
        if (this.threadSafe) {
            throw new IllegalArgumentException(WRONG_USE_OF_PRINTSTREAM_ON_THREADSAFE_VIEWS);
        }
        Supplier<HtmlVisitorCache> v = out == null ? () -> new HtmlVisitorStringBuilder(this.getVisitor().isDynamic) : () -> new HtmlVisitorPrintStream(out, this.getVisitor().isDynamic);
        this.setVisitor(v);
        return this;
    }

    public HtmlView<T> self() {
        return this;
    }

    public HtmlView<T> threadSafe() {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException(WRONG_USE_OF_THREADSAFE_ON_VIEWS_WITH_PRINTSTREAM);
        }
        this.threadSafe = true;
        this.setVisitor(this.visitorSupplier);
        return this;
    }

    public HtmlVisitorCache getVisitor() {
        return this.threadSafe ? this.threadLocalVisitor.get() : this.visitor;
    }

    public void setVisitor(Supplier<HtmlVisitorCache> visitor) {
        this.visitorSupplier = visitor;
        if (this.threadSafe) {
            this.visitor = null;
            this.threadLocalVisitor = ThreadLocal.withInitial(visitor);
        } else {
            this.visitor = visitor.get();
            this.threadLocalVisitor = null;
        }
    }

    public String getName() {
        return "HtmlView";
    }

    public Element __() {
        throw new IllegalStateException("HtmlView is the root of Html tree and it has not any parent.");
    }

    public Element getParent() {
        throw new IllegalStateException("HtmlView is the root of Html tree and it has not any parent.");
    }

    public final <U> void addPartial(HtmlView<U> partial, U model) {
        this.getVisitor().closeBeginTag();
        partial.getVisitor().depth = this.getVisitor().depth;
        if (this.getVisitor().isWriting()) {
            this.getVisitor().write(partial.render(model));
        }
    }

    public final <U> void addPartial(HtmlView<U> partial) {
        this.getVisitor().closeBeginTag();
        partial.getVisitor().depth = this.getVisitor().depth;
        if (this.getVisitor().isWriting()) {
            this.getVisitor().write(partial.render());
        }
    }

    static {
        NEWLINE = System.getProperty("line.separator");
        try {
            URL headerUrl = HtmlView.class.getClassLoader().getResource(HEADER_TEMPLATE);
            if (headerUrl == null) {
                throw new FileNotFoundException(HEADER_TEMPLATE);
            }
            InputStream headerStream = headerUrl.openStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(headerStream));){
                HEADER = reader.lines().collect(Collectors.joining(NEWLINE));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

