/*
 * Decompiled with CFR 0.152.
 */
package htmlflow;

import htmlflow.HtmlView;
import htmlflow.HtmlVisitorPrintStream;
import htmlflow.HtmlVisitorStringBuilder;
import java.io.PrintStream;
import java.util.function.Consumer;

public class StaticHtml
extends HtmlView<Object> {
    private static final String WRONG_USE_OF_RENDER_WITH_MODEL = "Wrong use of StaticView! Model object not supported or you should use a dynamic view instead!";
    private Consumer<StaticHtml> template;

    public static StaticHtml view(PrintStream out, Consumer<StaticHtml> template) {
        return new StaticHtml(out, template);
    }

    public static StaticHtml view(PrintStream out) {
        return new StaticHtml(out);
    }

    public static StaticHtml view(Consumer<StaticHtml> template) {
        return new StaticHtml(template);
    }

    public static StaticHtml view() {
        return new StaticHtml();
    }

    private StaticHtml() {
        this.setVisitor(() -> new HtmlVisitorStringBuilder(false));
    }

    private StaticHtml(Consumer<StaticHtml> template) {
        this();
        this.template = template;
    }

    private StaticHtml(PrintStream out) {
        this.setVisitor(() -> new HtmlVisitorPrintStream(out, false));
    }

    private StaticHtml(PrintStream out, Consumer<StaticHtml> template) {
        this(out);
        this.template = template;
    }

    @Override
    public String render() {
        if (this.getVisitor() instanceof HtmlVisitorPrintStream) {
            throw new IllegalStateException("Wrong use of render(). Use write() rather than render() to output to PrintStream. To get a String from render() you must use view() without a PrintStream ");
        }
        if (this.template != null) {
            this.template.accept(this);
        }
        return this.getVisitor().finished();
    }

    @Override
    public String render(Object model) {
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITH_MODEL);
    }

    @Override
    public void write() {
        if (this.template != null) {
            this.template.accept(this);
        }
        this.getVisitor().finished();
    }

    @Override
    public void write(Object model) {
        throw new UnsupportedOperationException(WRONG_USE_OF_RENDER_WITH_MODEL);
    }
}

