/*
 * Decompiled with CFR 0.152.
 */
package msgpack4z;

import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import msgpack4z.MsgPacker;
import org.msgpack.MessagePack;
import org.msgpack.packer.MessagePackBufferPacker;
import org.msgpack.packer.MessagePackPacker;
import org.msgpack.packer.PackerStack;

final class Msgpack06Packer
extends MessagePackBufferPacker
implements MsgPacker {
    private static final Field stackField;
    private PackerStack stack;

    public Msgpack06Packer(MessagePack messagePack, int n) {
        super(messagePack, n);
    }

    public Msgpack06Packer(MessagePack messagePack) {
        super(messagePack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized PackerStack stack() {
        if (this.stack == null) {
            try {
                Msgpack06Packer msgpack06Packer = this;
                synchronized (msgpack06Packer) {
                    this.stack = (PackerStack)stackField.get((Object)this);
                }
                return this.stack;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
                throw new RuntimeException(illegalAccessException);
            }
        }
        return this.stack;
    }

    public void packByte(byte by) throws IOException {
        this.write(by);
    }

    public void packShort(short s) throws IOException {
        this.write(s);
    }

    public void packInt(int n) throws IOException {
        this.write(n);
    }

    public void packLong(long l) throws IOException {
        this.write(l);
    }

    public void packDouble(double d) throws IOException {
        this.write(d);
    }

    public void packFloat(float f) throws IOException {
        this.write(f);
    }

    public void packBigInteger(BigInteger bigInteger) throws IOException {
        this.write(bigInteger);
    }

    public void packArrayHeader(int n) throws IOException {
        this.writeArrayBegin(n);
    }

    public void arrayEnd() throws IOException {
        this.writeArrayEnd();
    }

    public void packMapHeader(int n) throws IOException {
        this.writeMapBegin(n);
    }

    public void mapEnd() throws IOException {
        this.writeMapEnd();
    }

    public void packBoolean(boolean bl) throws IOException {
        this.write(bl);
    }

    public void packNil() throws IOException {
        this.writeNil();
    }

    public void packString(String string) throws IOException {
        this.write(string);
    }

    public void packBinary(byte[] byArray) throws IOException {
        int n = byArray.length;
        if (n < 256) {
            this.out.writeByteAndByte((byte)-60, (byte)n);
        } else if (n < 65536) {
            this.out.writeByteAndShort((byte)-59, (short)n);
        } else {
            this.out.writeByteAndInt((byte)-58, n);
        }
        this.out.write(byArray, 0, n);
        this.stack().reduceCount();
    }

    public void packExtTypeHeader(byte by, int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writePayload(byte[] byArray) throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte[] result() {
        return this.toByteArray();
    }

    static {
        try {
            stackField = MessagePackPacker.class.getDeclaredField("stack");
            stackField.setAccessible(true);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            throw new ExceptionInInitializerError(noSuchFieldException);
        }
    }
}

