package dumonts.hunspell.bindings;
import org.bridj.BridJ;
import org.bridj.CRuntime;
import org.bridj.Pointer;
import org.bridj.ann.Library;
import org.bridj.ann.Ptr;
import org.bridj.ann.Runtime;
/**
 * Wrapper for library <b>hunspell</b><br>
 * This file was autogenerated by <a href="http://jnaerator.googlecode.com/">JNAerator</a>,<br>
 * a tool written by <a href="http://ochafik.com/">Olivier Chafik</a> that <a href="http://code.google.com/p/jnaerator/wiki/CreditsAndLicense">uses a few opensource projects.</a>.<br>
 * For help, please visit <a href="http://nativelibs4java.googlecode.com/">NativeLibs4Java</a> or <a href="http://bridj.googlecode.com/">BridJ</a> .
 */
@Library("hunspell") 
@Runtime(CRuntime.class) 
public class HunspellLibrary {
	static {
		BridJ.register();
	}
	/**
	 * Original signature : <code>Hunhandle* Hunspell_create(const char*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:51</i>
	 */
	public static Pointer<HunspellLibrary.Hunhandle > Hunspell_create(Pointer<Byte > affpath, Pointer<Byte > dpath) {
		return (Pointer)Pointer.pointerToAddress(Hunspell_create(Pointer.getPeer(affpath), Pointer.getPeer(dpath)), HunspellLibrary.Hunhandle.class);
	}
	@Ptr 
	protected native static long Hunspell_create(@Ptr long affpath, @Ptr long dpath);
	/**
	 * Original signature : <code>Hunhandle* Hunspell_create_key(const char*, const char*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:54</i>
	 */
	public static Pointer<HunspellLibrary.Hunhandle > Hunspell_create_key(Pointer<Byte > affpath, Pointer<Byte > dpath, Pointer<Byte > key) {
		return (Pointer)Pointer.pointerToAddress(Hunspell_create_key(Pointer.getPeer(affpath), Pointer.getPeer(dpath), Pointer.getPeer(key)), HunspellLibrary.Hunhandle.class);
	}
	@Ptr 
	protected native static long Hunspell_create_key(@Ptr long affpath, @Ptr long dpath, @Ptr long key);
	/**
	 * Original signature : <code>void Hunspell_destroy(Hunhandle*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:58</i>
	 */
	public static void Hunspell_destroy(Pointer<HunspellLibrary.Hunhandle > pHunspell) {
		Hunspell_destroy(Pointer.getPeer(pHunspell));
	}
	protected native static void Hunspell_destroy(@Ptr long pHunspell);
	/**
	 * load extra dictionaries (only dic files)<br>
	 * output: 0 = additional dictionary slots available, 1 = slots are now full<br>
	 * Original signature : <code>int Hunspell_add_dic(Hunhandle*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:62</i>
	 */
	public static int Hunspell_add_dic(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Byte > dpath) {
		return Hunspell_add_dic(Pointer.getPeer(pHunspell), Pointer.getPeer(dpath));
	}
	protected native static int Hunspell_add_dic(@Ptr long pHunspell, @Ptr long dpath);
	/**
	 * spell(word) - spellcheck word<br>
	 * output: 0 = bad word, not 0 = good word<br>
	 * Original signature : <code>int Hunspell_spell(Hunhandle*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:68</i>
	 */
	public static int Hunspell_spell(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Byte > charPtr1) {
		return Hunspell_spell(Pointer.getPeer(pHunspell), Pointer.getPeer(charPtr1));
	}
	protected native static int Hunspell_spell(@Ptr long pHunspell, @Ptr long charPtr1);
	/**
	 * Original signature : <code>char* Hunspell_get_dic_encoding(Hunhandle*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:70</i>
	 */
	public static Pointer<Byte > Hunspell_get_dic_encoding(Pointer<HunspellLibrary.Hunhandle > pHunspell) {
		return (Pointer)Pointer.pointerToAddress(Hunspell_get_dic_encoding(Pointer.getPeer(pHunspell)), Byte.class);
	}
	@Ptr 
	protected native static long Hunspell_get_dic_encoding(@Ptr long pHunspell);
	/**
	 * suggest(suggestions, word) - search suggestions<br>
	 * input: pointer to an array of strings pointer and the (bad) word<br>
	 *   array of strings pointer (here *slst) may not be initialized<br>
	 * output: number of suggestions in string array, and suggestions in<br>
	 *   a newly allocated array of strings (*slts will be NULL when number<br>
	 *   of suggestion equals 0.)<br>
	 * Original signature : <code>int Hunspell_suggest(Hunhandle*, char***, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:79</i>
	 */
	public static int Hunspell_suggest(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Byte > word) {
		return Hunspell_suggest(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(word));
	}
	protected native static int Hunspell_suggest(@Ptr long pHunspell, @Ptr long slst, @Ptr long word);
	/**
	 * analyze(result, word) - morphological analysis of the word<br>
	 * Original signature : <code>int Hunspell_analyze(Hunhandle*, char***, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:87</i>
	 */
	public static int Hunspell_analyze(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Byte > word) {
		return Hunspell_analyze(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(word));
	}
	protected native static int Hunspell_analyze(@Ptr long pHunspell, @Ptr long slst, @Ptr long word);
	/**
	 * stem(result, word) - stemmer function<br>
	 * Original signature : <code>int Hunspell_stem(Hunhandle*, char***, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:93</i>
	 */
	public static int Hunspell_stem(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Byte > word) {
		return Hunspell_stem(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(word));
	}
	protected native static int Hunspell_stem(@Ptr long pHunspell, @Ptr long slst, @Ptr long word);
	/**
	 * stem(result, analysis, n) - get stems from a morph. analysis<br>
	 * example:<br>
	 * char ** result, result2;<br>
	 * int n1 = Hunspell_analyze(result, "words");<br>
	 * int n2 = Hunspell_stem2(result2, result, n1);<br>
	 * Original signature : <code>int Hunspell_stem2(Hunhandle*, char***, char**, int)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:104</i>
	 */
	public static int Hunspell_stem2(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Pointer<Byte > > desc, int n) {
		return Hunspell_stem2(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(desc), n);
	}
	protected native static int Hunspell_stem2(@Ptr long pHunspell, @Ptr long slst, @Ptr long desc, int n);
	/**
	 * generate(result, word, word2) - morphological generation by example(s)<br>
	 * Original signature : <code>int Hunspell_generate(Hunhandle*, char***, const char*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:111</i>
	 */
	public static int Hunspell_generate(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Byte > word, Pointer<Byte > word2) {
		return Hunspell_generate(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(word), Pointer.getPeer(word2));
	}
	protected native static int Hunspell_generate(@Ptr long pHunspell, @Ptr long slst, @Ptr long word, @Ptr long word2);
	/**
	 * generate(result, word, desc, n) - generation by morph. description(s)<br>
	 * example:<br>
	 * char ** result;<br>
	 * char * affix = "is:plural"; // description depends from dictionaries, too<br>
	 * int n = Hunspell_generate2(result, "word", &affix, 1);<br>
	 * for (int i = 0; i < n; i++) printf("%s\n", result[i]);<br>
	 * Original signature : <code>int Hunspell_generate2(Hunhandle*, char***, const char*, char**, int)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:124</i>
	 */
	public static int Hunspell_generate2(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, Pointer<Byte > word, Pointer<Pointer<Byte > > desc, int n) {
		return Hunspell_generate2(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), Pointer.getPeer(word), Pointer.getPeer(desc), n);
	}
	protected native static int Hunspell_generate2(@Ptr long pHunspell, @Ptr long slst, @Ptr long word, @Ptr long desc, int n);
	/**
	 * add word to the run-time dictionary<br>
	 * Original signature : <code>int Hunspell_add(Hunhandle*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:134</i>
	 */
	public static int Hunspell_add(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Byte > word) {
		return Hunspell_add(Pointer.getPeer(pHunspell), Pointer.getPeer(word));
	}
	protected native static int Hunspell_add(@Ptr long pHunspell, @Ptr long word);
	/**
	 * add word to the run-time dictionary with affix flags of<br>
	 * the example (a dictionary word): Hunspell will recognize<br>
	 * affixed forms of the new word, too.<br>
	 * Original signature : <code>int Hunspell_add_with_affix(Hunhandle*, const char*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:142</i>
	 */
	public static int Hunspell_add_with_affix(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Byte > word, Pointer<Byte > example) {
		return Hunspell_add_with_affix(Pointer.getPeer(pHunspell), Pointer.getPeer(word), Pointer.getPeer(example));
	}
	protected native static int Hunspell_add_with_affix(@Ptr long pHunspell, @Ptr long word, @Ptr long example);
	/**
	 * remove word from the run-time dictionary<br>
	 * Original signature : <code>int Hunspell_remove(Hunhandle*, const char*)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:148</i>
	 */
	public static int Hunspell_remove(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Byte > word) {
		return Hunspell_remove(Pointer.getPeer(pHunspell), Pointer.getPeer(word));
	}
	protected native static int Hunspell_remove(@Ptr long pHunspell, @Ptr long word);
	/**
	 * free suggestion lists<br>
	 * Original signature : <code>void Hunspell_free_list(Hunhandle*, char***, int)</code><br>
	 * <i>native declaration : src/main/cpp/hunspell/src/hunspell/hunspell.h:153</i>
	 */
	public static void Hunspell_free_list(Pointer<HunspellLibrary.Hunhandle > pHunspell, Pointer<Pointer<Pointer<Byte > > > slst, int n) {
		Hunspell_free_list(Pointer.getPeer(pHunspell), Pointer.getPeer(slst), n);
	}
	protected native static void Hunspell_free_list(@Ptr long pHunspell, @Ptr long slst, int n);
	/** Undefined type */
	public static interface Hunhandle {
		
	};
}
