/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfl;

public final class zzfb {
    private final zza zza;

    public zzfb(zza zza2) {
        Preconditions.checkNotNull((Object)zza2);
        this.zza = zza2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean zza(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            ComponentName componentName = new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver");
            context = packageManager.getReceiverInfo(componentName, 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    @MainThread
    public final void zzb(Context context, Intent object) {
        zzfl zzfl2 = zzfl.zzC(context, null, null);
        zzei zzei2 = zzfl2.zzat();
        if (object == null) {
            zzei2.zze().zza("Receiver called with null intent");
            return;
        }
        zzfl2.zzas();
        object = object.getAction();
        zzei2.zzk().zzb("Local receiver got", object);
        if ("com.google.android.gms.measurement.UPLOAD".equals(object)) {
            object = new Intent();
            object = object.setClassName(context, "com.google.android.gms.measurement.AppMeasurementService");
            object.setAction("com.google.android.gms.measurement.UPLOAD");
            zzei2.zzk().zza("Starting wakeful intent.");
            this.zza.doStartService(context, (Intent)object);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(object)) {
            zzei2.zze().zza("Install Referrer Broadcasts are deprecated");
            return;
        }
    }

    public static interface zza {
        public void doStartService(Context var1, Intent var2);
    }
}

