/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.common.lib.exception;

import com.google.api.ads.common.lib.auth.CaptchaInformation;
import com.google.api.ads.common.lib.exception.AuthenticationException;
import java.io.IOException;

public class ClientLoginException
extends AuthenticationException {
    private final Integer httpStatusCode;
    private final String httpResponseBody;
    private final String errorCode;
    private final CaptchaInformation captchaInfo;
    private final IOException ioException;

    public ClientLoginException(Integer httpStatusCode, String httpResponseBody, String errorCode, CaptchaInformation captchaInfo, IOException ioException) {
        super("ClientLogin exception", ioException);
        this.httpStatusCode = httpStatusCode;
        this.httpResponseBody = httpResponseBody;
        this.errorCode = errorCode;
        this.captchaInfo = captchaInfo;
        this.ioException = ioException;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getHttpResponseBody() {
        return this.httpResponseBody;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public CaptchaInformation getCaptchaInfo() {
        return this.captchaInfo;
    }

    public IOException getIoException() {
        return this.ioException;
    }

    public String getMessage() {
        if (this.errorCode != null) {
            return "Auth token could not be retrieved because of error: " + this.errorCode;
        }
        if (this.httpStatusCode != null) {
            return "Auth token could not be retrieved because of http status code: " + this.httpStatusCode;
        }
        if (this.ioException != null) {
            return "Auth token could not be retrieved because of IOException: " + this.ioException.getMessage();
        }
        return "Auth token could not be retrieved because of unkown reasons";
    }
}

