/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils.v201206;

import com.google.api.ads.adwords.lib.client.AdWordsSession;
import com.google.api.ads.adwords.lib.jaxb.v201206.DownloadFormat;
import com.google.api.ads.adwords.lib.jaxb.v201206.ReportDefinition;
import com.google.api.ads.adwords.lib.utils.AdHocReportDownloadHelper;
import com.google.api.ads.adwords.lib.utils.ReportDownloadResponse;
import com.google.api.ads.adwords.lib.utils.ReportException;
import com.google.api.ads.common.lib.soap.jaxb.JaxBSerializer;
import com.google.common.annotations.VisibleForTesting;
import javax.xml.namespace.QName;

public class ReportDownloader {
    private static final String VERSION = "v201206";
    private final AdHocReportDownloadHelper adHocReportDownloadHelper;
    private final JaxBSerializer<ReportDefinition> serializer;

    public ReportDownloader(AdWordsSession session) {
        this.adHocReportDownloadHelper = new AdHocReportDownloadHelper(session, VERSION);
        this.serializer = new JaxBSerializer<ReportDefinition>(ReportDefinition.class, new QName("reportDefinition"));
    }

    public ReportDownloadResponse downloadReport(ReportDefinition reportDefinition) throws ReportException {
        return this.adHocReportDownloadHelper.downloadReport(this.toXml(reportDefinition));
    }

    public ReportDownloadResponse downloadReport(String reportQuery, DownloadFormat format) throws ReportException {
        return this.adHocReportDownloadHelper.downloadReport(reportQuery, format.value());
    }

    @VisibleForTesting
    String toXml(ReportDefinition reportDefinition) {
        return this.serializer.serialize(reportDefinition);
    }
}

