/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.dfp.lib.client;

import com.google.api.ads.common.lib.auth.ClientLoginCompatible;
import com.google.api.ads.common.lib.auth.OAuth2Compatible;
import com.google.api.ads.common.lib.auth.OAuthCompatible;
import com.google.api.ads.common.lib.client.AdsSession;
import com.google.api.ads.common.lib.client.Endpoint;
import com.google.api.ads.common.lib.conf.ConfigurationHelper;
import com.google.api.ads.common.lib.conf.ConfigurationLoadException;
import com.google.api.ads.common.lib.exception.ValidationException;
import com.google.api.client.auth.oauth.OAuthParameters;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.configuration.Configuration;

public class DfpSession
implements AdsSession,
OAuthCompatible,
OAuth2Compatible,
ClientLoginCompatible {
    private String endpoint;
    private String clientLoginToken;
    private String applicationName;
    private String networkCode;
    private OAuthParameters oAuthParameters;
    private Credential oAuth2Credential;
    public static final String DEFAULT_ENDPOINT = "https://www.google.com/";

    private DfpSession() {
    }

    private DfpSession(DfpSession copy) {
        this.applicationName = copy.applicationName;
        this.clientLoginToken = copy.clientLoginToken;
        this.endpoint = copy.endpoint;
        this.networkCode = copy.networkCode;
        this.oAuth2Credential = copy.oAuth2Credential;
        this.oAuthParameters = copy.oAuthParameters;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public OAuthParameters getOAuthParameters() {
        return this.oAuthParameters;
    }

    public void setOAuthParameters(OAuthParameters oAuthParameters) {
        Preconditions.checkNotNull((Object)oAuthParameters, (Object)"oAuthParameters cannot be null.");
        this.clearAuthentication();
        this.oAuthParameters = oAuthParameters;
    }

    public Credential getOAuth2Credential() {
        return this.oAuth2Credential;
    }

    public void setOAuth2Credential(Credential oAuth2Credential) {
        Preconditions.checkNotNull((Object)oAuth2Credential, (Object)"oAuth2Credential cannot be null.");
        this.clearAuthentication();
        this.oAuth2Credential = oAuth2Credential;
    }

    public String getClientLoginToken() {
        return this.clientLoginToken;
    }

    public void setClientLoginToken(String clientLoginToken) {
        Preconditions.checkNotNull((Object)clientLoginToken, (Object)"clientLoginToken cannot be null.");
        this.clearAuthentication();
        this.clientLoginToken = clientLoginToken;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Deprecated
    public boolean isEnvironment(Endpoint environment) {
        return environment.getEndpoint().equals(this.endpoint);
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    private void clearAuthentication() {
        this.oAuth2Credential = null;
        this.oAuthParameters = null;
        this.clientLoginToken = null;
    }

    /* synthetic */ DfpSession(DfpSession dfpSession, DfpSession dfpSession2) {
        this();
    }

    /* synthetic */ DfpSession(DfpSession dfpSession, DfpSession dfpSession2, DfpSession dfpSession3) {
        this(dfpSession);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder
    implements com.google.api.ads.common.lib.utils.Builder<DfpSession> {
        private DfpSession dfpSession = new DfpSession(null, null);
        private String environmentString;
        @VisibleForTesting
        ConfigurationHelper configHelper;

        public Builder() {
            this.configHelper = new ConfigurationHelper();
        }

        @VisibleForTesting
        Builder(ConfigurationHelper configHelper) {
            this.configHelper = configHelper;
        }

        public Builder fromFile() throws ConfigurationLoadException {
            return this.fromFile("ads.properties");
        }

        public Builder fromFile(String path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(File path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder fromFile(URL path) throws ConfigurationLoadException {
            return this.from(this.configHelper.fromFile(path));
        }

        public Builder from(Configuration config) {
            this.dfpSession.clientLoginToken = config.getString("api.dfp.clientLoginToken", null);
            this.dfpSession.applicationName = config.getString("api.dfp.applicationName", null);
            this.dfpSession.networkCode = config.getString("api.dfp.networkCode", null);
            this.dfpSession.endpoint = config.getString("api.dfp.endpoint", null);
            this.environmentString = config.getString("api.dfp.environment", null);
            return this;
        }

        public Builder withClientLoginToken(String clientLoginToken) {
            this.dfpSession.clientLoginToken = clientLoginToken;
            return this;
        }

        public Builder withOAuthParameters(OAuthParameters oAuthParameters) {
            this.dfpSession.oAuthParameters = oAuthParameters;
            return this;
        }

        public Builder withOAuth2Credential(Credential oAuth2Credential) {
            this.dfpSession.oAuth2Credential = oAuth2Credential;
            return this;
        }

        public Builder withNetworkCode(String networkCode) {
            this.dfpSession.networkCode = networkCode;
            return this;
        }

        public Builder withApplicationName(String applicationName) {
            this.dfpSession.applicationName = applicationName;
            return this;
        }

        @Deprecated
        public Builder withEnvironment(Environment environment) {
            this.dfpSession.endpoint = environment.getEndpoint();
            this.environmentString = null;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.dfpSession.endpoint = endpoint;
            this.environmentString = null;
            return this;
        }

        @Override
        public DfpSession build() throws ValidationException {
            this.defaultOptionals();
            this.validate(this.dfpSession);
            return new DfpSession(this.dfpSession, null, null);
        }

        private void defaultOptionals() {
            if (this.dfpSession.endpoint == null) {
                this.dfpSession.endpoint = DfpSession.DEFAULT_ENDPOINT;
            }
        }

        private void validate(DfpSession dfpSession) throws ValidationException {
            if (this.environmentString != null) {
                try {
                    this.withEnvironment(Environment.valueOf(this.environmentString.toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    throw new ValidationException(String.format("Environment [%s] not recognized.", this.environmentString), "api.dfp.environment", e);
                }
            }
            if (dfpSession.getClientLoginToken() != null && (dfpSession.getOAuthParameters() != null || dfpSession.getOAuth2Credential() != null)) {
                throw new ValidationException("Both ClientLogin authetication (clientLoginToken) and OAuth or OAuth2 authentication cannot be used at the same time.", "");
            }
            if (dfpSession.getClientLoginToken() == null && dfpSession.getOAuthParameters() != null && dfpSession.getOAuth2Credential() != null) {
                throw new ValidationException("Both OAuth and OAuth2 cannot be used at the same time.", "");
            }
            if (dfpSession.getClientLoginToken() == null && dfpSession.getOAuthParameters() == null && dfpSession.getOAuth2Credential() == null) {
                throw new ValidationException("Either ClientLogin authetication, OAuth, or OAuth2 authentication must be used.", "");
            }
            try {
                new URL(dfpSession.getEndpoint());
            }
            catch (MalformedURLException e) {
                throw new ValidationException(String.format("Endpoint [%s] not recognized as a valid URL.", dfpSession.getEndpoint()), "endpoint", e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Deprecated
    public static enum Environment implements Endpoint
    {
        PRODUCTION("https://www.google.com/");

        private final String endpoint;

        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Override
        public String getEndpoint() {
            return this.endpoint;
        }
    }
}

