/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.lib.utils;

import com.google.api.ads.adwords.lib.utils.QueryBuilderInterface;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.util.Arrays;
import java.util.List;

public abstract class QueryBuilder<QueryBuilderT extends QueryBuilder<QueryBuilderT, QueryT>, QueryT>
implements QueryBuilderInterface<QueryT> {
    protected final List<QueryBuilderInterface.WhereBuilderInterface> whereBuilders = Lists.newArrayList();

    public QueryBuilder() {
    }

    public QueryBuilder(QueryBuilderT queryBuilder) {
        Preconditions.checkNotNull(queryBuilder, (Object)"The query builder cannot be null.");
        this.whereBuilders.addAll(Lists.newArrayList(((QueryBuilder)queryBuilder).whereBuilders));
    }

    public class WhereBuilder
    implements QueryBuilderInterface.WhereBuilderInterface<QueryT> {
        private final String field;
        private String awqlClause;

        public WhereBuilder(String field) {
            this.field = (String)Preconditions.checkNotNull((Object)field, (Object)"The field cannot be null.");
        }

        public String toString() {
            return this.awqlClause;
        }

        @Override
        public final QueryBuilderInterface<QueryT> equalTo(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> equalTo(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> equalTo(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> equalTo(boolean propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notEqualTo(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "!=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notEqualTo(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "!=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notEqualTo(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "!=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notEqualTo(boolean propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "!=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> contains(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "CONTAINS");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsIgnoreCase(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "CONTAINS_IGNORE_CASE");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> doesNotContain(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "DOES_NOT_CONTAIN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> doesNotContainIgnoreCase(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "DOES_NOT_CONTAIN_IGNORE_CASE");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThan(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThan(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThan(double propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThanOrEqualTo(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThanOrEqualTo(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> greaterThanOrEqualTo(double propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, ">=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThan(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThan(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThan(double propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThanOrEqualTo(long propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThanOrEqualTo(int propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> lessThanOrEqualTo(double propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "<=");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> startsWith(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "STARTS_WITH");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> startsWithIgnoreCase(String propertyValue) {
            this.awqlClause = this.createSingleValuePredicate(propertyValue, "STARTS_WITH_IGNORE_CASE");
            return QueryBuilder.this;
        }

        private String createSingleValuePredicate(String propertyValue, String operator) {
            return String.format("%s %s %s", this.field, operator, String.format("\"%s\"", propertyValue));
        }

        private String createSingleValuePredicate(long propertyValue, String operator) {
            return String.format("%s %s %d", this.field, operator, propertyValue);
        }

        private String createSingleValuePredicate(double propertyValue, String operator) {
            return String.format("%s %s %f", this.field, operator, propertyValue);
        }

        private String createSingleValuePredicate(boolean propertyValue, String operator) {
            return String.format("%s %s %s", this.field, operator, propertyValue);
        }

        @Override
        public final QueryBuilderInterface<QueryT> in(String ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> in(int ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> in(long ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> in(double ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> in(boolean ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notIn(String ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "NOT_IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notIn(int ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "NOT_IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notIn(long ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "NOT_IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notIn(double ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "NOT_IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> notIn(boolean ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "NOT_IN");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAny(String ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ANY");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAny(int ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ANY");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAny(long ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ANY");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAny(double ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ANY");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAll(String ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ALL");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAll(int ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ALL");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAll(long ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ALL");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsAll(double ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_ALL");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsNone(String ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_NONE");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsNone(int ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_NONE");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsNone(long ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_NONE");
            return QueryBuilder.this;
        }

        @Override
        public final QueryBuilderInterface<QueryT> containsNone(double ... values) {
            this.awqlClause = this.createMultipleValuesPredicate(values, "CONTAINS_NONE");
            return QueryBuilder.this;
        }

        private String createMultipleValuesPredicate(String[] values, String operator) {
            Function normalize = s -> String.format("\"%s\"", s);
            return String.format("%s %s [%s]", this.field, operator, Joiner.on((String)", ").join((Iterable)Lists.transform(Arrays.asList(values), (Function)normalize)));
        }

        private String createMultipleValuesPredicate(double[] values, String operator) {
            return String.format("%s %s [%s]", this.field, operator, Joiner.on((String)", ").join((Iterable)Lists.transform((List)Doubles.asList((double[])values), (Function)Functions.toStringFunction())));
        }

        private String createMultipleValuesPredicate(int[] values, String operator) {
            return String.format("%s %s [%s]", this.field, operator, Joiner.on((String)", ").join((Iterable)Lists.transform((List)Ints.asList((int[])values), (Function)Functions.toStringFunction())));
        }

        private String createMultipleValuesPredicate(long[] values, String operator) {
            return String.format("%s %s [%s]", this.field, operator, Joiner.on((String)", ").join((Iterable)Lists.transform((List)Longs.asList((long[])values), (Function)Functions.toStringFunction())));
        }

        private String createMultipleValuesPredicate(boolean[] values, String operator) {
            return String.format("%s %s [%s]", this.field, operator, Joiner.on((String)", ").join((Iterable)Lists.transform((List)Booleans.asList((boolean[])values), (Function)Functions.toStringFunction())));
        }
    }
}

