/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datacatalog;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class TagTemplateName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tagTemplates/{tag_template}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tagTemplate;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTagTemplate() {
        return this.tagTemplate;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TagTemplateName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tagTemplate = (String)Preconditions.checkNotNull((Object)builder.getTagTemplate());
    }

    public static TagTemplateName of(String project, String location, String tagTemplate) {
        return TagTemplateName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).build();
    }

    public static String format(String project, String location, String tagTemplate) {
        return TagTemplateName.newBuilder().setProject(project).setLocation(location).setTagTemplate(tagTemplate).build().toString();
    }

    public static TagTemplateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TagTemplateName.parse: formattedString not in valid format");
        return TagTemplateName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tag_template"));
    }

    public static List<TagTemplateName> parseList(List<String> formattedStrings) {
        ArrayList<TagTemplateName> list = new ArrayList<TagTemplateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TagTemplateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TagTemplateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TagTemplateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TagTemplateName tagTemplateName = this;
            synchronized (tagTemplateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"tagTemplate", (Object)this.tagTemplate);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "tag_template", this.tagTemplate});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TagTemplateName) {
            TagTemplateName that = (TagTemplateName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.tagTemplate.equals(that.tagTemplate);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.tagTemplate.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String tagTemplate;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTagTemplate() {
            return this.tagTemplate;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTagTemplate(String tagTemplate) {
            this.tagTemplate = tagTemplate;
            return this;
        }

        private Builder() {
        }

        private Builder(TagTemplateName tagTemplateName) {
            this.project = tagTemplateName.project;
            this.location = tagTemplateName.location;
            this.tagTemplate = tagTemplateName.tagTemplate;
        }

        public TagTemplateName build() {
            return new TagTemplateName(this);
        }
    }
}

