/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/vision/v1/product_search_service.proto

package com.google.cloud.vision.v1;

/**
 *
 *
 * <pre>
 * Response message for the `ImportProductSets` method.
 * This message is returned by the
 * [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
 * [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
 * </pre>
 *
 * Protobuf type {@code google.cloud.vision.v1.ImportProductSetsResponse}
 */
public final class ImportProductSetsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.vision.v1.ImportProductSetsResponse)
    ImportProductSetsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ImportProductSetsResponse.newBuilder() to construct.
  private ImportProductSetsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ImportProductSetsResponse() {
    referenceImages_ = java.util.Collections.emptyList();
    statuses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ImportProductSetsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ImportProductSetsResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                referenceImages_ =
                    new java.util.ArrayList<com.google.cloud.vision.v1.ReferenceImage>();
                mutable_bitField0_ |= 0x00000001;
              }
              referenceImages_.add(
                  input.readMessage(
                      com.google.cloud.vision.v1.ReferenceImage.parser(), extensionRegistry));
              break;
            }
          case 18:
            {
              if (!((mutable_bitField0_ & 0x00000002) != 0)) {
                statuses_ = new java.util.ArrayList<com.google.rpc.Status>();
                mutable_bitField0_ |= 0x00000002;
              }
              statuses_.add(input.readMessage(com.google.rpc.Status.parser(), extensionRegistry));
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        referenceImages_ = java.util.Collections.unmodifiableList(referenceImages_);
      }
      if (((mutable_bitField0_ & 0x00000002) != 0)) {
        statuses_ = java.util.Collections.unmodifiableList(statuses_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.vision.v1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1_ImportProductSetsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.vision.v1.ProductSearchServiceProto
        .internal_static_google_cloud_vision_v1_ImportProductSetsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.vision.v1.ImportProductSetsResponse.class,
            com.google.cloud.vision.v1.ImportProductSetsResponse.Builder.class);
  }

  public static final int REFERENCE_IMAGES_FIELD_NUMBER = 1;
  private java.util.List<com.google.cloud.vision.v1.ReferenceImage> referenceImages_;
  /**
   *
   *
   * <pre>
   * The list of reference_images that are imported successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
   */
  public java.util.List<com.google.cloud.vision.v1.ReferenceImage> getReferenceImagesList() {
    return referenceImages_;
  }
  /**
   *
   *
   * <pre>
   * The list of reference_images that are imported successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
   */
  public java.util.List<? extends com.google.cloud.vision.v1.ReferenceImageOrBuilder>
      getReferenceImagesOrBuilderList() {
    return referenceImages_;
  }
  /**
   *
   *
   * <pre>
   * The list of reference_images that are imported successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
   */
  public int getReferenceImagesCount() {
    return referenceImages_.size();
  }
  /**
   *
   *
   * <pre>
   * The list of reference_images that are imported successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
   */
  public com.google.cloud.vision.v1.ReferenceImage getReferenceImages(int index) {
    return referenceImages_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The list of reference_images that are imported successfully.
   * </pre>
   *
   * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
   */
  public com.google.cloud.vision.v1.ReferenceImageOrBuilder getReferenceImagesOrBuilder(int index) {
    return referenceImages_.get(index);
  }

  public static final int STATUSES_FIELD_NUMBER = 2;
  private java.util.List<com.google.rpc.Status> statuses_;
  /**
   *
   *
   * <pre>
   * The rpc status for each ImportProductSet request, including both successes
   * and errors.
   * The number of statuses here matches the number of lines in the csv file,
   * and statuses[i] stores the success or failure status of processing the i-th
   * line of the csv, starting from line 0.
   * </pre>
   *
   * <code>repeated .google.rpc.Status statuses = 2;</code>
   */
  public java.util.List<com.google.rpc.Status> getStatusesList() {
    return statuses_;
  }
  /**
   *
   *
   * <pre>
   * The rpc status for each ImportProductSet request, including both successes
   * and errors.
   * The number of statuses here matches the number of lines in the csv file,
   * and statuses[i] stores the success or failure status of processing the i-th
   * line of the csv, starting from line 0.
   * </pre>
   *
   * <code>repeated .google.rpc.Status statuses = 2;</code>
   */
  public java.util.List<? extends com.google.rpc.StatusOrBuilder> getStatusesOrBuilderList() {
    return statuses_;
  }
  /**
   *
   *
   * <pre>
   * The rpc status for each ImportProductSet request, including both successes
   * and errors.
   * The number of statuses here matches the number of lines in the csv file,
   * and statuses[i] stores the success or failure status of processing the i-th
   * line of the csv, starting from line 0.
   * </pre>
   *
   * <code>repeated .google.rpc.Status statuses = 2;</code>
   */
  public int getStatusesCount() {
    return statuses_.size();
  }
  /**
   *
   *
   * <pre>
   * The rpc status for each ImportProductSet request, including both successes
   * and errors.
   * The number of statuses here matches the number of lines in the csv file,
   * and statuses[i] stores the success or failure status of processing the i-th
   * line of the csv, starting from line 0.
   * </pre>
   *
   * <code>repeated .google.rpc.Status statuses = 2;</code>
   */
  public com.google.rpc.Status getStatuses(int index) {
    return statuses_.get(index);
  }
  /**
   *
   *
   * <pre>
   * The rpc status for each ImportProductSet request, including both successes
   * and errors.
   * The number of statuses here matches the number of lines in the csv file,
   * and statuses[i] stores the success or failure status of processing the i-th
   * line of the csv, starting from line 0.
   * </pre>
   *
   * <code>repeated .google.rpc.Status statuses = 2;</code>
   */
  public com.google.rpc.StatusOrBuilder getStatusesOrBuilder(int index) {
    return statuses_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < referenceImages_.size(); i++) {
      output.writeMessage(1, referenceImages_.get(i));
    }
    for (int i = 0; i < statuses_.size(); i++) {
      output.writeMessage(2, statuses_.get(i));
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < referenceImages_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, referenceImages_.get(i));
    }
    for (int i = 0; i < statuses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, statuses_.get(i));
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.vision.v1.ImportProductSetsResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.vision.v1.ImportProductSetsResponse other =
        (com.google.cloud.vision.v1.ImportProductSetsResponse) obj;

    if (!getReferenceImagesList().equals(other.getReferenceImagesList())) return false;
    if (!getStatusesList().equals(other.getStatusesList())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getReferenceImagesCount() > 0) {
      hash = (37 * hash) + REFERENCE_IMAGES_FIELD_NUMBER;
      hash = (53 * hash) + getReferenceImagesList().hashCode();
    }
    if (getStatusesCount() > 0) {
      hash = (37 * hash) + STATUSES_FIELD_NUMBER;
      hash = (53 * hash) + getStatusesList().hashCode();
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.vision.v1.ImportProductSetsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for the `ImportProductSets` method.
   * This message is returned by the
   * [google.longrunning.Operations.GetOperation][google.longrunning.Operations.GetOperation] method in the returned
   * [google.longrunning.Operation.response][google.longrunning.Operation.response] field.
   * </pre>
   *
   * Protobuf type {@code google.cloud.vision.v1.ImportProductSetsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.vision.v1.ImportProductSetsResponse)
      com.google.cloud.vision.v1.ImportProductSetsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.vision.v1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1_ImportProductSetsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.vision.v1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1_ImportProductSetsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.vision.v1.ImportProductSetsResponse.class,
              com.google.cloud.vision.v1.ImportProductSetsResponse.Builder.class);
    }

    // Construct using com.google.cloud.vision.v1.ImportProductSetsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getReferenceImagesFieldBuilder();
        getStatusesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (referenceImagesBuilder_ == null) {
        referenceImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        referenceImagesBuilder_.clear();
      }
      if (statusesBuilder_ == null) {
        statuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
      } else {
        statusesBuilder_.clear();
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.vision.v1.ProductSearchServiceProto
          .internal_static_google_cloud_vision_v1_ImportProductSetsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImportProductSetsResponse getDefaultInstanceForType() {
      return com.google.cloud.vision.v1.ImportProductSetsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImportProductSetsResponse build() {
      com.google.cloud.vision.v1.ImportProductSetsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.vision.v1.ImportProductSetsResponse buildPartial() {
      com.google.cloud.vision.v1.ImportProductSetsResponse result =
          new com.google.cloud.vision.v1.ImportProductSetsResponse(this);
      int from_bitField0_ = bitField0_;
      if (referenceImagesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          referenceImages_ = java.util.Collections.unmodifiableList(referenceImages_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.referenceImages_ = referenceImages_;
      } else {
        result.referenceImages_ = referenceImagesBuilder_.build();
      }
      if (statusesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          statuses_ = java.util.Collections.unmodifiableList(statuses_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.statuses_ = statuses_;
      } else {
        result.statuses_ = statusesBuilder_.build();
      }
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.vision.v1.ImportProductSetsResponse) {
        return mergeFrom((com.google.cloud.vision.v1.ImportProductSetsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.vision.v1.ImportProductSetsResponse other) {
      if (other == com.google.cloud.vision.v1.ImportProductSetsResponse.getDefaultInstance())
        return this;
      if (referenceImagesBuilder_ == null) {
        if (!other.referenceImages_.isEmpty()) {
          if (referenceImages_.isEmpty()) {
            referenceImages_ = other.referenceImages_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureReferenceImagesIsMutable();
            referenceImages_.addAll(other.referenceImages_);
          }
          onChanged();
        }
      } else {
        if (!other.referenceImages_.isEmpty()) {
          if (referenceImagesBuilder_.isEmpty()) {
            referenceImagesBuilder_.dispose();
            referenceImagesBuilder_ = null;
            referenceImages_ = other.referenceImages_;
            bitField0_ = (bitField0_ & ~0x00000001);
            referenceImagesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getReferenceImagesFieldBuilder()
                    : null;
          } else {
            referenceImagesBuilder_.addAllMessages(other.referenceImages_);
          }
        }
      }
      if (statusesBuilder_ == null) {
        if (!other.statuses_.isEmpty()) {
          if (statuses_.isEmpty()) {
            statuses_ = other.statuses_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureStatusesIsMutable();
            statuses_.addAll(other.statuses_);
          }
          onChanged();
        }
      } else {
        if (!other.statuses_.isEmpty()) {
          if (statusesBuilder_.isEmpty()) {
            statusesBuilder_.dispose();
            statusesBuilder_ = null;
            statuses_ = other.statuses_;
            bitField0_ = (bitField0_ & ~0x00000002);
            statusesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStatusesFieldBuilder()
                    : null;
          } else {
            statusesBuilder_.addAllMessages(other.statuses_);
          }
        }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.cloud.vision.v1.ImportProductSetsResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage =
            (com.google.cloud.vision.v1.ImportProductSetsResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.cloud.vision.v1.ReferenceImage> referenceImages_ =
        java.util.Collections.emptyList();

    private void ensureReferenceImagesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        referenceImages_ =
            new java.util.ArrayList<com.google.cloud.vision.v1.ReferenceImage>(referenceImages_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1.ReferenceImage,
            com.google.cloud.vision.v1.ReferenceImage.Builder,
            com.google.cloud.vision.v1.ReferenceImageOrBuilder>
        referenceImagesBuilder_;

    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1.ReferenceImage> getReferenceImagesList() {
      if (referenceImagesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(referenceImages_);
      } else {
        return referenceImagesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public int getReferenceImagesCount() {
      if (referenceImagesBuilder_ == null) {
        return referenceImages_.size();
      } else {
        return referenceImagesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public com.google.cloud.vision.v1.ReferenceImage getReferenceImages(int index) {
      if (referenceImagesBuilder_ == null) {
        return referenceImages_.get(index);
      } else {
        return referenceImagesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder setReferenceImages(int index, com.google.cloud.vision.v1.ReferenceImage value) {
      if (referenceImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferenceImagesIsMutable();
        referenceImages_.set(index, value);
        onChanged();
      } else {
        referenceImagesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder setReferenceImages(
        int index, com.google.cloud.vision.v1.ReferenceImage.Builder builderForValue) {
      if (referenceImagesBuilder_ == null) {
        ensureReferenceImagesIsMutable();
        referenceImages_.set(index, builderForValue.build());
        onChanged();
      } else {
        referenceImagesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder addReferenceImages(com.google.cloud.vision.v1.ReferenceImage value) {
      if (referenceImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferenceImagesIsMutable();
        referenceImages_.add(value);
        onChanged();
      } else {
        referenceImagesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder addReferenceImages(int index, com.google.cloud.vision.v1.ReferenceImage value) {
      if (referenceImagesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureReferenceImagesIsMutable();
        referenceImages_.add(index, value);
        onChanged();
      } else {
        referenceImagesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder addReferenceImages(
        com.google.cloud.vision.v1.ReferenceImage.Builder builderForValue) {
      if (referenceImagesBuilder_ == null) {
        ensureReferenceImagesIsMutable();
        referenceImages_.add(builderForValue.build());
        onChanged();
      } else {
        referenceImagesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder addReferenceImages(
        int index, com.google.cloud.vision.v1.ReferenceImage.Builder builderForValue) {
      if (referenceImagesBuilder_ == null) {
        ensureReferenceImagesIsMutable();
        referenceImages_.add(index, builderForValue.build());
        onChanged();
      } else {
        referenceImagesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder addAllReferenceImages(
        java.lang.Iterable<? extends com.google.cloud.vision.v1.ReferenceImage> values) {
      if (referenceImagesBuilder_ == null) {
        ensureReferenceImagesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, referenceImages_);
        onChanged();
      } else {
        referenceImagesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder clearReferenceImages() {
      if (referenceImagesBuilder_ == null) {
        referenceImages_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        referenceImagesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public Builder removeReferenceImages(int index) {
      if (referenceImagesBuilder_ == null) {
        ensureReferenceImagesIsMutable();
        referenceImages_.remove(index);
        onChanged();
      } else {
        referenceImagesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public com.google.cloud.vision.v1.ReferenceImage.Builder getReferenceImagesBuilder(int index) {
      return getReferenceImagesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public com.google.cloud.vision.v1.ReferenceImageOrBuilder getReferenceImagesOrBuilder(
        int index) {
      if (referenceImagesBuilder_ == null) {
        return referenceImages_.get(index);
      } else {
        return referenceImagesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public java.util.List<? extends com.google.cloud.vision.v1.ReferenceImageOrBuilder>
        getReferenceImagesOrBuilderList() {
      if (referenceImagesBuilder_ != null) {
        return referenceImagesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(referenceImages_);
      }
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public com.google.cloud.vision.v1.ReferenceImage.Builder addReferenceImagesBuilder() {
      return getReferenceImagesFieldBuilder()
          .addBuilder(com.google.cloud.vision.v1.ReferenceImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public com.google.cloud.vision.v1.ReferenceImage.Builder addReferenceImagesBuilder(int index) {
      return getReferenceImagesFieldBuilder()
          .addBuilder(index, com.google.cloud.vision.v1.ReferenceImage.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The list of reference_images that are imported successfully.
     * </pre>
     *
     * <code>repeated .google.cloud.vision.v1.ReferenceImage reference_images = 1;</code>
     */
    public java.util.List<com.google.cloud.vision.v1.ReferenceImage.Builder>
        getReferenceImagesBuilderList() {
      return getReferenceImagesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.vision.v1.ReferenceImage,
            com.google.cloud.vision.v1.ReferenceImage.Builder,
            com.google.cloud.vision.v1.ReferenceImageOrBuilder>
        getReferenceImagesFieldBuilder() {
      if (referenceImagesBuilder_ == null) {
        referenceImagesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.vision.v1.ReferenceImage,
                com.google.cloud.vision.v1.ReferenceImage.Builder,
                com.google.cloud.vision.v1.ReferenceImageOrBuilder>(
                referenceImages_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        referenceImages_ = null;
      }
      return referenceImagesBuilder_;
    }

    private java.util.List<com.google.rpc.Status> statuses_ = java.util.Collections.emptyList();

    private void ensureStatusesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        statuses_ = new java.util.ArrayList<com.google.rpc.Status>(statuses_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusesBuilder_;

    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public java.util.List<com.google.rpc.Status> getStatusesList() {
      if (statusesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(statuses_);
      } else {
        return statusesBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public int getStatusesCount() {
      if (statusesBuilder_ == null) {
        return statuses_.size();
      } else {
        return statusesBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public com.google.rpc.Status getStatuses(int index) {
      if (statusesBuilder_ == null) {
        return statuses_.get(index);
      } else {
        return statusesBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder setStatuses(int index, com.google.rpc.Status value) {
      if (statusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusesIsMutable();
        statuses_.set(index, value);
        onChanged();
      } else {
        statusesBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder setStatuses(int index, com.google.rpc.Status.Builder builderForValue) {
      if (statusesBuilder_ == null) {
        ensureStatusesIsMutable();
        statuses_.set(index, builderForValue.build());
        onChanged();
      } else {
        statusesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder addStatuses(com.google.rpc.Status value) {
      if (statusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusesIsMutable();
        statuses_.add(value);
        onChanged();
      } else {
        statusesBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder addStatuses(int index, com.google.rpc.Status value) {
      if (statusesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStatusesIsMutable();
        statuses_.add(index, value);
        onChanged();
      } else {
        statusesBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder addStatuses(com.google.rpc.Status.Builder builderForValue) {
      if (statusesBuilder_ == null) {
        ensureStatusesIsMutable();
        statuses_.add(builderForValue.build());
        onChanged();
      } else {
        statusesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder addStatuses(int index, com.google.rpc.Status.Builder builderForValue) {
      if (statusesBuilder_ == null) {
        ensureStatusesIsMutable();
        statuses_.add(index, builderForValue.build());
        onChanged();
      } else {
        statusesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder addAllStatuses(java.lang.Iterable<? extends com.google.rpc.Status> values) {
      if (statusesBuilder_ == null) {
        ensureStatusesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, statuses_);
        onChanged();
      } else {
        statusesBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder clearStatuses() {
      if (statusesBuilder_ == null) {
        statuses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        statusesBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public Builder removeStatuses(int index) {
      if (statusesBuilder_ == null) {
        ensureStatusesIsMutable();
        statuses_.remove(index);
        onChanged();
      } else {
        statusesBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public com.google.rpc.Status.Builder getStatusesBuilder(int index) {
      return getStatusesFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusesOrBuilder(int index) {
      if (statusesBuilder_ == null) {
        return statuses_.get(index);
      } else {
        return statusesBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public java.util.List<? extends com.google.rpc.StatusOrBuilder> getStatusesOrBuilderList() {
      if (statusesBuilder_ != null) {
        return statusesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(statuses_);
      }
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public com.google.rpc.Status.Builder addStatusesBuilder() {
      return getStatusesFieldBuilder().addBuilder(com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public com.google.rpc.Status.Builder addStatusesBuilder(int index) {
      return getStatusesFieldBuilder()
          .addBuilder(index, com.google.rpc.Status.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * The rpc status for each ImportProductSet request, including both successes
     * and errors.
     * The number of statuses here matches the number of lines in the csv file,
     * and statuses[i] stores the success or failure status of processing the i-th
     * line of the csv, starting from line 0.
     * </pre>
     *
     * <code>repeated .google.rpc.Status statuses = 2;</code>
     */
    public java.util.List<com.google.rpc.Status.Builder> getStatusesBuilderList() {
      return getStatusesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusesFieldBuilder() {
      if (statusesBuilder_ == null) {
        statusesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(
                statuses_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
        statuses_ = null;
      }
      return statusesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.vision.v1.ImportProductSetsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.vision.v1.ImportProductSetsResponse)
  private static final com.google.cloud.vision.v1.ImportProductSetsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.vision.v1.ImportProductSetsResponse();
  }

  public static com.google.cloud.vision.v1.ImportProductSetsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ImportProductSetsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ImportProductSetsResponse>() {
        @java.lang.Override
        public ImportProductSetsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ImportProductSetsResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ImportProductSetsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ImportProductSetsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.vision.v1.ImportProductSetsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
