/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar;

/**
 * Available OAuth 2.0 scopes for use with the Calendar API.
 *
 * @since 1.4
 */
public class CalendarScopes {

  /** See, edit, share, and permanently delete all the calendars you can access using Google Calendar. */
  public static final String CALENDAR = "https://www.googleapis.com/auth/calendar";

  /** View and edit events on all your calendars. */
  public static final String CALENDAR_EVENTS = "https://www.googleapis.com/auth/calendar.events";

  /** View events on all your calendars. */
  public static final String CALENDAR_EVENTS_READONLY = "https://www.googleapis.com/auth/calendar.events.readonly";

  /** View your calendars. */
  public static final String CALENDAR_READONLY = "https://www.googleapis.com/auth/calendar.readonly";

  /** View your Calendar settings. */
  public static final String CALENDAR_SETTINGS_READONLY = "https://www.googleapis.com/auth/calendar.settings.readonly";

  /**
   * Returns an unmodifiable set that contains all scopes declared by this class.
   *
   * @since 1.16
   */
  public static java.util.Set<String> all() {
    java.util.Set<String> set = new java.util.HashSet<String>();
    set.add(CALENDAR);
    set.add(CALENDAR_EVENTS);
    set.add(CALENDAR_EVENTS_READONLY);
    set.add(CALENDAR_READONLY);
    set.add(CALENDAR_SETTINGS_READONLY);
    return java.util.Collections.unmodifiableSet(set);
  }

  private CalendarScopes() {
  }
}
