/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for AclRule.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AclRule extends com.google.api.client.json.GenericJson {

  /**
   * ETag of the resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String etag;

  /**
   * Identifier of the ACL rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String id;

  /**
   * Type of the resource ("calendar#aclRule").
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String kind;

  /**
   * The role assigned to the scope. Possible values are: - "none" - Provides no access.  -
   * "freeBusyReader" - Provides read access to free/busy information.  - "reader" - Provides read
   * access to the calendar. Private events will appear to users with reader access, but event
   * details will be hidden.  - "writer" - Provides read and write access to the calendar. Private
   * events will appear to users with writer access, and event details will be visible.  - "owner" -
   * Provides ownership of the calendar. This role has all of the permissions of the writer role
   * with the additional ability to see and manipulate ACLs.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The scope of the rule.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Scope scope;

  /**
   * ETag of the resource.
   * @return value or {@code null} for none
   */
  public java.lang.String getEtag() {
    return etag;
  }

  /**
   * ETag of the resource.
   * @param etag etag or {@code null} for none
   */
  public AclRule setEtag(java.lang.String etag) {
    this.etag = etag;
    return this;
  }

  /**
   * Identifier of the ACL rule.
   * @return value or {@code null} for none
   */
  public java.lang.String getId() {
    return id;
  }

  /**
   * Identifier of the ACL rule.
   * @param id id or {@code null} for none
   */
  public AclRule setId(java.lang.String id) {
    this.id = id;
    return this;
  }

  /**
   * Type of the resource ("calendar#aclRule").
   * @return value or {@code null} for none
   */
  public java.lang.String getKind() {
    return kind;
  }

  /**
   * Type of the resource ("calendar#aclRule").
   * @param kind kind or {@code null} for none
   */
  public AclRule setKind(java.lang.String kind) {
    this.kind = kind;
    return this;
  }

  /**
   * The role assigned to the scope. Possible values are: - "none" - Provides no access.  -
   * "freeBusyReader" - Provides read access to free/busy information.  - "reader" - Provides read
   * access to the calendar. Private events will appear to users with reader access, but event
   * details will be hidden.  - "writer" - Provides read and write access to the calendar. Private
   * events will appear to users with writer access, and event details will be visible.  - "owner" -
   * Provides ownership of the calendar. This role has all of the permissions of the writer role
   * with the additional ability to see and manipulate ACLs.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role assigned to the scope. Possible values are: - "none" - Provides no access.  -
   * "freeBusyReader" - Provides read access to free/busy information.  - "reader" - Provides read
   * access to the calendar. Private events will appear to users with reader access, but event
   * details will be hidden.  - "writer" - Provides read and write access to the calendar. Private
   * events will appear to users with writer access, and event details will be visible.  - "owner" -
   * Provides ownership of the calendar. This role has all of the permissions of the writer role
   * with the additional ability to see and manipulate ACLs.
   * @param role role or {@code null} for none
   */
  public AclRule setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The scope of the rule.
   * @return value or {@code null} for none
   */
  public Scope getScope() {
    return scope;
  }

  /**
   * The scope of the rule.
   * @param scope scope or {@code null} for none
   */
  public AclRule setScope(Scope scope) {
    this.scope = scope;
    return this;
  }

  @Override
  public AclRule set(String fieldName, Object value) {
    return (AclRule) super.set(fieldName, value);
  }

  @Override
  public AclRule clone() {
    return (AclRule) super.clone();
  }

  /**
   * The scope of the rule.
   */
  public static final class Scope extends com.google.api.client.json.GenericJson {

    /**
     * The type of the scope. Possible values are: - "default" - The public scope. This is the default
     * value.  - "user" - Limits the scope to a single user.  - "group" - Limits the scope to a group.
     * - "domain" - Limits the scope to a domain.  Note: The permissions granted to the "default", or
     * public, scope apply to any user, authenticated or not.
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String type;

    /**
     * The email address of a user or group, or the name of a domain, depending on the scope type.
     * Omitted for type "default".
     * The value may be {@code null}.
     */
    @com.google.api.client.util.Key
    private java.lang.String value;

    /**
     * The type of the scope. Possible values are: - "default" - The public scope. This is the default
     * value.  - "user" - Limits the scope to a single user.  - "group" - Limits the scope to a group.
     * - "domain" - Limits the scope to a domain.  Note: The permissions granted to the "default", or
     * public, scope apply to any user, authenticated or not.
     * @return value or {@code null} for none
     */
    public java.lang.String getType() {
      return type;
    }

    /**
     * The type of the scope. Possible values are: - "default" - The public scope. This is the default
     * value.  - "user" - Limits the scope to a single user.  - "group" - Limits the scope to a group.
     * - "domain" - Limits the scope to a domain.  Note: The permissions granted to the "default", or
     * public, scope apply to any user, authenticated or not.
     * @param type type or {@code null} for none
     */
    public Scope setType(java.lang.String type) {
      this.type = type;
      return this;
    }

    /**
     * The email address of a user or group, or the name of a domain, depending on the scope type.
     * Omitted for type "default".
     * @return value or {@code null} for none
     */
    public java.lang.String getValue() {
      return value;
    }

    /**
     * The email address of a user or group, or the name of a domain, depending on the scope type.
     * Omitted for type "default".
     * @param value value or {@code null} for none
     */
    public Scope setValue(java.lang.String value) {
      this.value = value;
      return this;
    }

    @Override
    public Scope set(String fieldName, Object value) {
      return (Scope) super.set(fieldName, value);
    }

    @Override
    public Scope clone() {
      return (Scope) super.clone();
    }

  }
}
