/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.calendar.model;

/**
 * Model definition for CalendarNotification.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Calendar API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class CalendarNotification extends com.google.api.client.json.GenericJson {

  /**
   * The method used to deliver the notification. The possible value is: - "email" - Notifications
   * are sent via email.   Required when adding a notification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String method;

  /**
   * The type of notification. Possible values are: - "eventCreation" - Notification sent when a new
   * event is put on the calendar.  - "eventChange" - Notification sent when an event is changed.  -
   * "eventCancellation" - Notification sent when an event is cancelled.  - "eventResponse" -
   * Notification sent when an attendee responds to the event invitation.  - "agenda" - An agenda
   * with the events of the day (sent out in the morning).   Required when adding a notification.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * The method used to deliver the notification. The possible value is: - "email" - Notifications
   * are sent via email.   Required when adding a notification.
   * @return value or {@code null} for none
   */
  public java.lang.String getMethod() {
    return method;
  }

  /**
   * The method used to deliver the notification. The possible value is: - "email" - Notifications
   * are sent via email.   Required when adding a notification.
   * @param method method or {@code null} for none
   */
  public CalendarNotification setMethod(java.lang.String method) {
    this.method = method;
    return this;
  }

  /**
   * The type of notification. Possible values are: - "eventCreation" - Notification sent when a new
   * event is put on the calendar.  - "eventChange" - Notification sent when an event is changed.  -
   * "eventCancellation" - Notification sent when an event is cancelled.  - "eventResponse" -
   * Notification sent when an attendee responds to the event invitation.  - "agenda" - An agenda
   * with the events of the day (sent out in the morning).   Required when adding a notification.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * The type of notification. Possible values are: - "eventCreation" - Notification sent when a new
   * event is put on the calendar.  - "eventChange" - Notification sent when an event is changed.  -
   * "eventCancellation" - Notification sent when an event is cancelled.  - "eventResponse" -
   * Notification sent when an attendee responds to the event invitation.  - "agenda" - An agenda
   * with the events of the day (sent out in the morning).   Required when adding a notification.
   * @param type type or {@code null} for none
   */
  public CalendarNotification setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  @Override
  public CalendarNotification set(String fieldName, Object value) {
    return (CalendarNotification) super.set(fieldName, value);
  }

  @Override
  public CalendarNotification clone() {
    return (CalendarNotification) super.clone();
  }

}
