/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.drive.model;

/**
 * A wrapper for the role and view of an access proposal.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the Google Drive API. For a detailed explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class AccessProposalRoleAndView extends com.google.api.client.json.GenericJson {

  /**
   * The role that was proposed by the requester New values may be added in the future, but the
   * following are currently possible: * `writer` * `commenter` * `reader`
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Indicates the view for this access proposal. Only populated for proposals that belong to a
   * view. `published` is the only supported value.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String view;

  /**
   * The role that was proposed by the requester New values may be added in the future, but the
   * following are currently possible: * `writer` * `commenter` * `reader`
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * The role that was proposed by the requester New values may be added in the future, but the
   * following are currently possible: * `writer` * `commenter` * `reader`
   * @param role role or {@code null} for none
   */
  public AccessProposalRoleAndView setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Indicates the view for this access proposal. Only populated for proposals that belong to a
   * view. `published` is the only supported value.
   * @return value or {@code null} for none
   */
  public java.lang.String getView() {
    return view;
  }

  /**
   * Indicates the view for this access proposal. Only populated for proposals that belong to a
   * view. `published` is the only supported value.
   * @param view view or {@code null} for none
   */
  public AccessProposalRoleAndView setView(java.lang.String view) {
    this.view = view;
    return this;
  }

  @Override
  public AccessProposalRoleAndView set(String fieldName, Object value) {
    return (AccessProposalRoleAndView) super.set(fieldName, value);
  }

  @Override
  public AccessProposalRoleAndView clone() {
    return (AccessProposalRoleAndView) super.clone();
  }

}
