/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.mybusinessaccountmanagement.v1;

/**
 * Service definition for MyBusinessAccountManagement (v1).
 *
 * <p>
 * The My Business Account Management API provides an interface for managing access to a location on Google.
 * </p>
 *
 * <p>
 * For more information about this service, see the
 * <a href="https://developers.google.com/my-business/" target="_blank">API Documentation</a>
 * </p>
 *
 * <p>
 * This service uses {@link MyBusinessAccountManagementRequestInitializer} to initialize global parameters via its
 * {@link Builder}.
 * </p>
 *
 * @since 1.3
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public class MyBusinessAccountManagement extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient {

  // Note: Leave this static initializer at the top of the file.
  static {
    com.google.api.client.util.Preconditions.checkState(
        com.google.api.client.googleapis.GoogleUtils.MAJOR_VERSION == 1 &&
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION >= 32 ||
        (com.google.api.client.googleapis.GoogleUtils.MINOR_VERSION == 31 &&
        com.google.api.client.googleapis.GoogleUtils.BUGFIX_VERSION >= 1)),
        "You are currently running with version %s of google-api-client. " +
        "You need at least version 1.31.1 of google-api-client to run version " +
        "1.32.1 of the My Business Account Management API library.", com.google.api.client.googleapis.GoogleUtils.VERSION);
  }

  /**
   * The default encoded root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_ROOT_URL = "https://mybusinessaccountmanagement.googleapis.com/";

  /**
   * The default encoded mTLS root URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   *
   * @since 1.31
   */
  public static final String DEFAULT_MTLS_ROOT_URL = "https://mybusinessaccountmanagement.mtls.googleapis.com/";

  /**
   * The default encoded service path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.7
   */
  public static final String DEFAULT_SERVICE_PATH = "";

  /**
   * The default encoded batch path of the service. This is determined when the library is
   * generated and normally should not be changed.
   *
   * @since 1.23
   */
  public static final String DEFAULT_BATCH_PATH = "batch";

  /**
   * The default encoded base URL of the service. This is determined when the library is generated
   * and normally should not be changed.
   */
  public static final String DEFAULT_BASE_URL = DEFAULT_ROOT_URL + DEFAULT_SERVICE_PATH;

  /**
   * Constructor.
   *
   * <p>
   * Use {@link Builder} if you need to specify any of the optional parameters.
   * </p>
   *
   * @param transport HTTP transport, which should normally be:
   *        <ul>
   *        <li>Google App Engine:
   *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
   *        <li>Android: {@code newCompatibleTransport} from
   *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
   *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
   *        </li>
   *        </ul>
   * @param jsonFactory JSON factory, which may be:
   *        <ul>
   *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
   *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
   *        <li>Android Honeycomb or higher:
   *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
   *        </ul>
   * @param httpRequestInitializer HTTP request initializer or {@code null} for none
   * @since 1.7
   */
  public MyBusinessAccountManagement(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
      com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
    this(new Builder(transport, jsonFactory, httpRequestInitializer));
  }

  /**
   * @param builder builder
   */
  MyBusinessAccountManagement(Builder builder) {
    super(builder);
  }

  @Override
  protected void initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest<?> httpClientRequest) throws java.io.IOException {
    super.initialize(httpClientRequest);
  }

  /**
   * An accessor for creating requests from the Accounts collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusinessAccountManagement mybusinessaccountmanagement = new MyBusinessAccountManagement(...);}
   *   {@code MyBusinessAccountManagement.Accounts.List request = mybusinessaccountmanagement.accounts().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Accounts accounts() {
    return new Accounts();
  }

  /**
   * The "accounts" collection of methods.
   */
  public class Accounts {

    /**
     * Creates an account with the specified name and type under the given parent. - Personal accounts
     * and Organizations cannot be created. - User Groups cannot be created with a Personal account as
     * primary owner. - Location Groups cannot be created with a primary owner of a Personal account if
     * the Personal account is in an Organization. - Location Groups cannot own Location Groups.
     *
     * Create a request for the method "accounts.create".
     *
     * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
     * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
     * operation.
     *
     * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Account}
     * @return the request
     */
    public Create create(com.google.api.services.mybusinessaccountmanagement.v1.model.Account content) throws java.io.IOException {
      Create result = new Create(content);
      initialize(result);
      return result;
    }

    public class Create extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Account> {

      private static final String REST_PATH = "v1/accounts";

      /**
       * Creates an account with the specified name and type under the given parent. - Personal accounts
       * and Organizations cannot be created. - User Groups cannot be created with a Personal account as
       * primary owner. - Location Groups cannot be created with a primary owner of a Personal account
       * if the Personal account is in an Organization. - Location Groups cannot own Location Groups.
       *
       * Create a request for the method "accounts.create".
       *
       * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation. <p> {@link
       * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Account}
       * @since 1.13
       */
      protected Create(com.google.api.services.mybusinessaccountmanagement.v1.model.Account content) {
        super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Account.class);
      }

      @Override
      public Create set$Xgafv(java.lang.String $Xgafv) {
        return (Create) super.set$Xgafv($Xgafv);
      }

      @Override
      public Create setAccessToken(java.lang.String accessToken) {
        return (Create) super.setAccessToken(accessToken);
      }

      @Override
      public Create setAlt(java.lang.String alt) {
        return (Create) super.setAlt(alt);
      }

      @Override
      public Create setCallback(java.lang.String callback) {
        return (Create) super.setCallback(callback);
      }

      @Override
      public Create setFields(java.lang.String fields) {
        return (Create) super.setFields(fields);
      }

      @Override
      public Create setKey(java.lang.String key) {
        return (Create) super.setKey(key);
      }

      @Override
      public Create setOauthToken(java.lang.String oauthToken) {
        return (Create) super.setOauthToken(oauthToken);
      }

      @Override
      public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Create) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Create setQuotaUser(java.lang.String quotaUser) {
        return (Create) super.setQuotaUser(quotaUser);
      }

      @Override
      public Create setUploadType(java.lang.String uploadType) {
        return (Create) super.setUploadType(uploadType);
      }

      @Override
      public Create setUploadProtocol(java.lang.String uploadProtocol) {
        return (Create) super.setUploadProtocol(uploadProtocol);
      }

      @Override
      public Create set(String parameterName, Object value) {
        return (Create) super.set(parameterName, value);
      }
    }
    /**
     * Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller
     * does not have access rights to it.
     *
     * Create a request for the method "accounts.get".
     *
     * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
     * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
     * operation.
     *
     * @param name Required. The name of the account to fetch.
     * @return the request
     */
    public Get get(java.lang.String name) throws java.io.IOException {
      Get result = new Get(name);
      initialize(result);
      return result;
    }

    public class Get extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Account> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Gets the specified account. Returns `NOT_FOUND` if the account does not exist or if the caller
       * does not have access rights to it.
       *
       * Create a request for the method "accounts.get".
       *
       * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Get#execute()} method to invoke the remote
       * operation. <p> {@link
       * Get#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the account to fetch.
       * @since 1.13
       */
      protected Get(java.lang.String name) {
        super(MyBusinessAccountManagement.this, "GET", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.Account.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public Get set$Xgafv(java.lang.String $Xgafv) {
        return (Get) super.set$Xgafv($Xgafv);
      }

      @Override
      public Get setAccessToken(java.lang.String accessToken) {
        return (Get) super.setAccessToken(accessToken);
      }

      @Override
      public Get setAlt(java.lang.String alt) {
        return (Get) super.setAlt(alt);
      }

      @Override
      public Get setCallback(java.lang.String callback) {
        return (Get) super.setCallback(callback);
      }

      @Override
      public Get setFields(java.lang.String fields) {
        return (Get) super.setFields(fields);
      }

      @Override
      public Get setKey(java.lang.String key) {
        return (Get) super.setKey(key);
      }

      @Override
      public Get setOauthToken(java.lang.String oauthToken) {
        return (Get) super.setOauthToken(oauthToken);
      }

      @Override
      public Get setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Get) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Get setQuotaUser(java.lang.String quotaUser) {
        return (Get) super.setQuotaUser(quotaUser);
      }

      @Override
      public Get setUploadType(java.lang.String uploadType) {
        return (Get) super.setUploadType(uploadType);
      }

      @Override
      public Get setUploadProtocol(java.lang.String uploadProtocol) {
        return (Get) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the account to fetch. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the account to fetch.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. The name of the account to fetch. */
      public Get setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Get set(String parameterName, Object value) {
        return (Get) super.set(parameterName, value);
      }
    }
    /**
     * Lists all of the accounts for the authenticated user. This includes all accounts that the user
     * owns, as well as any accounts for which the user has management rights.
     *
     * Create a request for the method "accounts.list".
     *
     * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
     * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
     * operation.
     *
     * @return the request
     */
    public List list() throws java.io.IOException {
      List result = new List();
      initialize(result);
      return result;
    }

    public class List extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.ListAccountsResponse> {

      private static final String REST_PATH = "v1/accounts";

      /**
       * Lists all of the accounts for the authenticated user. This includes all accounts that the user
       * owns, as well as any accounts for which the user has management rights.
       *
       * Create a request for the method "accounts.list".
       *
       * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
       * operation. <p> {@link
       * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
       * called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @since 1.13
       */
      protected List() {
        super(MyBusinessAccountManagement.this, "GET", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.ListAccountsResponse.class);
      }

      @Override
      public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
        return super.executeUsingHead();
      }

      @Override
      public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
        return super.buildHttpRequestUsingHead();
      }

      @Override
      public List set$Xgafv(java.lang.String $Xgafv) {
        return (List) super.set$Xgafv($Xgafv);
      }

      @Override
      public List setAccessToken(java.lang.String accessToken) {
        return (List) super.setAccessToken(accessToken);
      }

      @Override
      public List setAlt(java.lang.String alt) {
        return (List) super.setAlt(alt);
      }

      @Override
      public List setCallback(java.lang.String callback) {
        return (List) super.setCallback(callback);
      }

      @Override
      public List setFields(java.lang.String fields) {
        return (List) super.setFields(fields);
      }

      @Override
      public List setKey(java.lang.String key) {
        return (List) super.setKey(key);
      }

      @Override
      public List setOauthToken(java.lang.String oauthToken) {
        return (List) super.setOauthToken(oauthToken);
      }

      @Override
      public List setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (List) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public List setQuotaUser(java.lang.String quotaUser) {
        return (List) super.setQuotaUser(quotaUser);
      }

      @Override
      public List setUploadType(java.lang.String uploadType) {
        return (List) super.setUploadType(uploadType);
      }

      @Override
      public List setUploadProtocol(java.lang.String uploadProtocol) {
        return (List) super.setUploadProtocol(uploadProtocol);
      }

      /**
       * Optional. A filter constraining the accounts to return. The response includes only entries
       * that match the filter. If `filter` is empty, then no constraints are applied and all
       * accounts (paginated) are retrieved for the requested account. For example, a request with
       * the filter `type=USER_GROUP` will only return user groups. The `type` field is the only
       * supported filter.
       */
      @com.google.api.client.util.Key
      private java.lang.String filter;

      /** Optional. A filter constraining the accounts to return. The response includes only entries that
     match the filter. If `filter` is empty, then no constraints are applied and all accounts
     (paginated) are retrieved for the requested account. For example, a request with the filter
     `type=USER_GROUP` will only return user groups. The `type` field is the only supported filter.
       */
      public java.lang.String getFilter() {
        return filter;
      }

      /**
       * Optional. A filter constraining the accounts to return. The response includes only entries
       * that match the filter. If `filter` is empty, then no constraints are applied and all
       * accounts (paginated) are retrieved for the requested account. For example, a request with
       * the filter `type=USER_GROUP` will only return user groups. The `type` field is the only
       * supported filter.
       */
      public List setFilter(java.lang.String filter) {
        this.filter = filter;
        return this;
      }

      /**
       * Optional. How many accounts to fetch per page. The minimum supported page_size is 2. The
       * default and maximum is 20.
       */
      @com.google.api.client.util.Key
      private java.lang.Integer pageSize;

      /** Optional. How many accounts to fetch per page. The minimum supported page_size is 2. The default
     and maximum is 20.
       */
      public java.lang.Integer getPageSize() {
        return pageSize;
      }

      /**
       * Optional. How many accounts to fetch per page. The minimum supported page_size is 2. The
       * default and maximum is 20.
       */
      public List setPageSize(java.lang.Integer pageSize) {
        this.pageSize = pageSize;
        return this;
      }

      /**
       * Optional. If specified, the next page of accounts is retrieved. The `pageToken` is returned
       * when a call to `accounts.list` returns more results than can fit into the requested page
       * size.
       */
      @com.google.api.client.util.Key
      private java.lang.String pageToken;

      /** Optional. If specified, the next page of accounts is retrieved. The `pageToken` is returned when a
     call to `accounts.list` returns more results than can fit into the requested page size.
       */
      public java.lang.String getPageToken() {
        return pageToken;
      }

      /**
       * Optional. If specified, the next page of accounts is retrieved. The `pageToken` is returned
       * when a call to `accounts.list` returns more results than can fit into the requested page
       * size.
       */
      public List setPageToken(java.lang.String pageToken) {
        this.pageToken = pageToken;
        return this;
      }

      /**
       * Optional. The resource name of the account for which the list of directly accessible
       * accounts is to be retrieved. This only makes sense for Organizations and User Groups. If
       * empty, will return `ListAccounts` for the authenticated user. `accounts/{account_id}`.
       */
      @com.google.api.client.util.Key
      private java.lang.String parentAccount;

      /** Optional. The resource name of the account for which the list of directly accessible accounts is to
     be retrieved. This only makes sense for Organizations and User Groups. If empty, will return
     `ListAccounts` for the authenticated user. `accounts/{account_id}`.
       */
      public java.lang.String getParentAccount() {
        return parentAccount;
      }

      /**
       * Optional. The resource name of the account for which the list of directly accessible
       * accounts is to be retrieved. This only makes sense for Organizations and User Groups. If
       * empty, will return `ListAccounts` for the authenticated user. `accounts/{account_id}`.
       */
      public List setParentAccount(java.lang.String parentAccount) {
        this.parentAccount = parentAccount;
        return this;
      }

      @Override
      public List set(String parameterName, Object value) {
        return (List) super.set(parameterName, value);
      }
    }
    /**
     * Updates the specified business account. Personal accounts cannot be updated using this method.
     *
     * Create a request for the method "accounts.patch".
     *
     * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
     * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
     * operation.
     *
     * @param name Immutable. The resource name, in the format `accounts/{account_id}`.
     * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Account}
     * @return the request
     */
    public Patch patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Account content) throws java.io.IOException {
      Patch result = new Patch(name, content);
      initialize(result);
      return result;
    }

    public class Patch extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Account> {

      private static final String REST_PATH = "v1/{+name}";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^accounts/[^/]+$");

      /**
       * Updates the specified business account. Personal accounts cannot be updated using this method.
       *
       * Create a request for the method "accounts.patch".
       *
       * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation. <p> {@link
       * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
       * be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Immutable. The resource name, in the format `accounts/{account_id}`.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Account}
       * @since 1.13
       */
      protected Patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Account content) {
        super(MyBusinessAccountManagement.this, "PATCH", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Account.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
      }

      @Override
      public Patch set$Xgafv(java.lang.String $Xgafv) {
        return (Patch) super.set$Xgafv($Xgafv);
      }

      @Override
      public Patch setAccessToken(java.lang.String accessToken) {
        return (Patch) super.setAccessToken(accessToken);
      }

      @Override
      public Patch setAlt(java.lang.String alt) {
        return (Patch) super.setAlt(alt);
      }

      @Override
      public Patch setCallback(java.lang.String callback) {
        return (Patch) super.setCallback(callback);
      }

      @Override
      public Patch setFields(java.lang.String fields) {
        return (Patch) super.setFields(fields);
      }

      @Override
      public Patch setKey(java.lang.String key) {
        return (Patch) super.setKey(key);
      }

      @Override
      public Patch setOauthToken(java.lang.String oauthToken) {
        return (Patch) super.setOauthToken(oauthToken);
      }

      @Override
      public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Patch) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Patch setQuotaUser(java.lang.String quotaUser) {
        return (Patch) super.setQuotaUser(quotaUser);
      }

      @Override
      public Patch setUploadType(java.lang.String uploadType) {
        return (Patch) super.setUploadType(uploadType);
      }

      @Override
      public Patch setUploadProtocol(java.lang.String uploadProtocol) {
        return (Patch) super.setUploadProtocol(uploadProtocol);
      }

      /** Immutable. The resource name, in the format `accounts/{account_id}`. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Immutable. The resource name, in the format `accounts/{account_id}`.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Immutable. The resource name, in the format `accounts/{account_id}`. */
      public Patch setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^accounts/[^/]+$");
        }
        this.name = name;
        return this;
      }

      /**
       * Required. The specific fields that should be updated. The only editable field is
       * `accountName`.
       */
      @com.google.api.client.util.Key
      private String updateMask;

      /** Required. The specific fields that should be updated. The only editable field is `accountName`.
       */
      public String getUpdateMask() {
        return updateMask;
      }

      /**
       * Required. The specific fields that should be updated. The only editable field is
       * `accountName`.
       */
      public Patch setUpdateMask(String updateMask) {
        this.updateMask = updateMask;
        return this;
      }

      /** Optional. If true, the request is validated without actually updating the account. */
      @com.google.api.client.util.Key
      private java.lang.Boolean validateOnly;

      /** Optional. If true, the request is validated without actually updating the account.
       */
      public java.lang.Boolean getValidateOnly() {
        return validateOnly;
      }

      /** Optional. If true, the request is validated without actually updating the account. */
      public Patch setValidateOnly(java.lang.Boolean validateOnly) {
        this.validateOnly = validateOnly;
        return this;
      }

      @Override
      public Patch set(String parameterName, Object value) {
        return (Patch) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Admins collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusinessAccountManagement mybusinessaccountmanagement = new MyBusinessAccountManagement(...);}
     *   {@code MyBusinessAccountManagement.Admins.List request = mybusinessaccountmanagement.admins().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Admins admins() {
      return new Admins();
    }

    /**
     * The "admins" collection of methods.
     */
    public class Admins {

      /**
       * Invites the specified user to become an administrator for the specified account. The invitee must
       * accept the invitation in order to be granted access to the account. See AcceptInvitation to
       * programmatically accept an invitation.
       *
       * Create a request for the method "admins.create".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. The resource name of the account this admin is created for. `accounts/{account_id}`.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Admin> {

        private static final String REST_PATH = "v1/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Invites the specified user to become an administrator for the specified account. The invitee
         * must accept the invitation in order to be granted access to the account. See AcceptInvitation
         * to programmatically accept an invitation.
         *
         * Create a request for the method "admins.create".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the account this admin is created for. `accounts/{account_id}`.
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) {
          super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the account this admin is created for.
         * `accounts/{account_id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the account this admin is created for. `accounts/{account_id}`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the account this admin is created for.
         * `accounts/{account_id}`.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Removes the specified admin from the specified account.
       *
       * Create a request for the method "admins.delete".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. The resource name of the admin to remove from the account.
       *        `accounts/{account_id}/admins/{admin_id}`.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/admins/[^/]+$");

        /**
         * Removes the specified admin from the specified account.
         *
         * Create a request for the method "admins.delete".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Delete#execute()} method to invoke the remote
         * operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the admin to remove from the account.
       *        `accounts/{account_id}/admins/{admin_id}`.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(MyBusinessAccountManagement.this, "DELETE", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the admin to remove from the account.
         * `accounts/{account_id}/admins/{admin_id}`.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the admin to remove from the account.
       `accounts/{account_id}/admins/{admin_id}`.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The resource name of the admin to remove from the account.
         * `accounts/{account_id}/admins/{admin_id}`.
         */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists the admins for the specified account.
       *
       * Create a request for the method "admins.list".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. The name of the account from which to retrieve a list of admins.
       *        `accounts/{account_id}/admins`.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.ListAccountAdminsResponse> {

        private static final String REST_PATH = "v1/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Lists the admins for the specified account.
         *
         * Create a request for the method "admins.list".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
         * operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the account from which to retrieve a list of admins.
       *        `accounts/{account_id}/admins`.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusinessAccountManagement.this, "GET", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.ListAccountAdminsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the account from which to retrieve a list of admins.
         * `accounts/{account_id}/admins`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the account from which to retrieve a list of admins.
       `accounts/{account_id}/admins`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the account from which to retrieve a list of admins.
         * `accounts/{account_id}/admins`.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the Admin for the specified Account Admin.
       *
       * Create a request for the method "admins.patch".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * @param name Immutable. The resource name. For account admins, this is in the form:
       *        `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       *        `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       *        creation.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Admin> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/admins/[^/]+$");

        /**
         * Updates the Admin for the specified Account Admin.
         *
         * Create a request for the method "admins.patch".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
         * operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Immutable. The resource name. For account admins, this is in the form:
       *        `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       *        `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       *        creation.
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) {
          super(MyBusinessAccountManagement.this, "PATCH", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Immutable. The resource name. For account admins, this is in the form:
         * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
         * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during
         * admin creation.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Immutable. The resource name. For account admins, this is in the form:
       `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       creation.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Immutable. The resource name. For account admins, this is in the form:
         * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
         * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during
         * admin creation.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The specific fields that should be updated. The only editable field is role.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The specific fields that should be updated. The only editable field is role.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The specific fields that should be updated. The only editable field is role.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
    /**
     * An accessor for creating requests from the Invitations collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusinessAccountManagement mybusinessaccountmanagement = new MyBusinessAccountManagement(...);}
     *   {@code MyBusinessAccountManagement.Invitations.List request = mybusinessaccountmanagement.invitations().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Invitations invitations() {
      return new Invitations();
    }

    /**
     * The "invitations" collection of methods.
     */
    public class Invitations {

      /**
       * Accepts the specified invitation.
       *
       * Create a request for the method "invitations.accept".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Accept#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. The name of the invitation that is being accepted.
       *        `accounts/{account_id}/invitations/{invitation_id}`
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.AcceptInvitationRequest}
       * @return the request
       */
      public Accept accept(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.AcceptInvitationRequest content) throws java.io.IOException {
        Accept result = new Accept(name, content);
        initialize(result);
        return result;
      }

      public class Accept extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}:accept";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");

        /**
         * Accepts the specified invitation.
         *
         * Create a request for the method "invitations.accept".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Accept#execute()} method to invoke the remote
         * operation. <p> {@link
         * Accept#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the invitation that is being accepted.
       *        `accounts/{account_id}/invitations/{invitation_id}`
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.AcceptInvitationRequest}
         * @since 1.13
         */
        protected Accept(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.AcceptInvitationRequest content) {
          super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
        }

        @Override
        public Accept set$Xgafv(java.lang.String $Xgafv) {
          return (Accept) super.set$Xgafv($Xgafv);
        }

        @Override
        public Accept setAccessToken(java.lang.String accessToken) {
          return (Accept) super.setAccessToken(accessToken);
        }

        @Override
        public Accept setAlt(java.lang.String alt) {
          return (Accept) super.setAlt(alt);
        }

        @Override
        public Accept setCallback(java.lang.String callback) {
          return (Accept) super.setCallback(callback);
        }

        @Override
        public Accept setFields(java.lang.String fields) {
          return (Accept) super.setFields(fields);
        }

        @Override
        public Accept setKey(java.lang.String key) {
          return (Accept) super.setKey(key);
        }

        @Override
        public Accept setOauthToken(java.lang.String oauthToken) {
          return (Accept) super.setOauthToken(oauthToken);
        }

        @Override
        public Accept setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Accept) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Accept setQuotaUser(java.lang.String quotaUser) {
          return (Accept) super.setQuotaUser(quotaUser);
        }

        @Override
        public Accept setUploadType(java.lang.String uploadType) {
          return (Accept) super.setUploadType(uploadType);
        }

        @Override
        public Accept setUploadProtocol(java.lang.String uploadProtocol) {
          return (Accept) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the invitation that is being accepted.
         * `accounts/{account_id}/invitations/{invitation_id}`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the invitation that is being accepted.
       `accounts/{account_id}/invitations/{invitation_id}`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the invitation that is being accepted.
         * `accounts/{account_id}/invitations/{invitation_id}`
         */
        public Accept setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Accept set(String parameterName, Object value) {
          return (Accept) super.set(parameterName, value);
        }
      }
      /**
       * Declines the specified invitation.
       *
       * Create a request for the method "invitations.decline".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Decline#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. The name of the account invitation that is being declined.
       *        `accounts/{account_id}/invitations/{invitation_id}`
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.DeclineInvitationRequest}
       * @return the request
       */
      public Decline decline(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.DeclineInvitationRequest content) throws java.io.IOException {
        Decline result = new Decline(name, content);
        initialize(result);
        return result;
      }

      public class Decline extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}:decline";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+/invitations/[^/]+$");

        /**
         * Declines the specified invitation.
         *
         * Create a request for the method "invitations.decline".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Decline#execute()} method to invoke the remote
         * operation. <p> {@link
         * Decline#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The name of the account invitation that is being declined.
       *        `accounts/{account_id}/invitations/{invitation_id}`
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.DeclineInvitationRequest}
         * @since 1.13
         */
        protected Decline(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.DeclineInvitationRequest content) {
          super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
        }

        @Override
        public Decline set$Xgafv(java.lang.String $Xgafv) {
          return (Decline) super.set$Xgafv($Xgafv);
        }

        @Override
        public Decline setAccessToken(java.lang.String accessToken) {
          return (Decline) super.setAccessToken(accessToken);
        }

        @Override
        public Decline setAlt(java.lang.String alt) {
          return (Decline) super.setAlt(alt);
        }

        @Override
        public Decline setCallback(java.lang.String callback) {
          return (Decline) super.setCallback(callback);
        }

        @Override
        public Decline setFields(java.lang.String fields) {
          return (Decline) super.setFields(fields);
        }

        @Override
        public Decline setKey(java.lang.String key) {
          return (Decline) super.setKey(key);
        }

        @Override
        public Decline setOauthToken(java.lang.String oauthToken) {
          return (Decline) super.setOauthToken(oauthToken);
        }

        @Override
        public Decline setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Decline) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Decline setQuotaUser(java.lang.String quotaUser) {
          return (Decline) super.setQuotaUser(quotaUser);
        }

        @Override
        public Decline setUploadType(java.lang.String uploadType) {
          return (Decline) super.setUploadType(uploadType);
        }

        @Override
        public Decline setUploadProtocol(java.lang.String uploadProtocol) {
          return (Decline) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the account invitation that is being declined.
         * `accounts/{account_id}/invitations/{invitation_id}`
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The name of the account invitation that is being declined.
       `accounts/{account_id}/invitations/{invitation_id}`
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Required. The name of the account invitation that is being declined.
         * `accounts/{account_id}/invitations/{invitation_id}`
         */
        public Decline setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^accounts/[^/]+/invitations/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Decline set(String parameterName, Object value) {
          return (Decline) super.set(parameterName, value);
        }
      }
      /**
       * Lists pending invitations for the specified account.
       *
       * Create a request for the method "invitations.list".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. The name of the account from which the list of invitations is being retrieved.
       *        `accounts/{account_id}/invitations`
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.ListInvitationsResponse> {

        private static final String REST_PATH = "v1/{+parent}/invitations";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^accounts/[^/]+$");

        /**
         * Lists pending invitations for the specified account.
         *
         * Create a request for the method "invitations.list".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
         * operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the account from which the list of invitations is being retrieved.
       *        `accounts/{account_id}/invitations`
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusinessAccountManagement.this, "GET", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.ListInvitationsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the account from which the list of invitations is being retrieved.
         * `accounts/{account_id}/invitations`
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the account from which the list of invitations is being retrieved.
       `accounts/{account_id}/invitations`
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the account from which the list of invitations is being retrieved.
         * `accounts/{account_id}/invitations`
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^accounts/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        /** Optional. Filtering the response is supported via the Invitation.target_type field. */
        @com.google.api.client.util.Key
        private java.lang.String filter;

        /** Optional. Filtering the response is supported via the Invitation.target_type field.
         */
        public java.lang.String getFilter() {
          return filter;
        }

        /** Optional. Filtering the response is supported via the Invitation.target_type field. */
        public List setFilter(java.lang.String filter) {
          this.filter = filter;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * An accessor for creating requests from the Locations collection.
   *
   * <p>The typical use is:</p>
   * <pre>
   *   {@code MyBusinessAccountManagement mybusinessaccountmanagement = new MyBusinessAccountManagement(...);}
   *   {@code MyBusinessAccountManagement.Locations.List request = mybusinessaccountmanagement.locations().list(parameters ...)}
   * </pre>
   *
   * @return the resource collection
   */
  public Locations locations() {
    return new Locations();
  }

  /**
   * The "locations" collection of methods.
   */
  public class Locations {

    /**
     * Moves a location from an account that the user owns to another account that the same user
     * administers. The user must be an owner of the account the location is currently associated with
     * and must also be at least a manager of the destination account.
     *
     * Create a request for the method "locations.transfer".
     *
     * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
     * setting any optional parameters, call the {@link Transfer#execute()} method to invoke the remote
     * operation.
     *
     * @param name Required. The name of the location to transfer. `locations/{location_id}`.
     * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.TransferLocationRequest}
     * @return the request
     */
    public Transfer transfer(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.TransferLocationRequest content) throws java.io.IOException {
      Transfer result = new Transfer(name, content);
      initialize(result);
      return result;
    }

    public class Transfer extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Empty> {

      private static final String REST_PATH = "v1/{+name}:transfer";

      private final java.util.regex.Pattern NAME_PATTERN =
          java.util.regex.Pattern.compile("^locations/[^/]+$");

      /**
       * Moves a location from an account that the user owns to another account that the same user
       * administers. The user must be an owner of the account the location is currently associated with
       * and must also be at least a manager of the destination account.
       *
       * Create a request for the method "locations.transfer".
       *
       * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Transfer#execute()} method to invoke the
       * remote operation. <p> {@link
       * Transfer#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)}
       * must be called to initialize this instance immediately after invoking the constructor. </p>
       *
       * @param name Required. The name of the location to transfer. `locations/{location_id}`.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.TransferLocationRequest}
       * @since 1.13
       */
      protected Transfer(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.TransferLocationRequest content) {
        super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Empty.class);
        this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^locations/[^/]+$");
        }
      }

      @Override
      public Transfer set$Xgafv(java.lang.String $Xgafv) {
        return (Transfer) super.set$Xgafv($Xgafv);
      }

      @Override
      public Transfer setAccessToken(java.lang.String accessToken) {
        return (Transfer) super.setAccessToken(accessToken);
      }

      @Override
      public Transfer setAlt(java.lang.String alt) {
        return (Transfer) super.setAlt(alt);
      }

      @Override
      public Transfer setCallback(java.lang.String callback) {
        return (Transfer) super.setCallback(callback);
      }

      @Override
      public Transfer setFields(java.lang.String fields) {
        return (Transfer) super.setFields(fields);
      }

      @Override
      public Transfer setKey(java.lang.String key) {
        return (Transfer) super.setKey(key);
      }

      @Override
      public Transfer setOauthToken(java.lang.String oauthToken) {
        return (Transfer) super.setOauthToken(oauthToken);
      }

      @Override
      public Transfer setPrettyPrint(java.lang.Boolean prettyPrint) {
        return (Transfer) super.setPrettyPrint(prettyPrint);
      }

      @Override
      public Transfer setQuotaUser(java.lang.String quotaUser) {
        return (Transfer) super.setQuotaUser(quotaUser);
      }

      @Override
      public Transfer setUploadType(java.lang.String uploadType) {
        return (Transfer) super.setUploadType(uploadType);
      }

      @Override
      public Transfer setUploadProtocol(java.lang.String uploadProtocol) {
        return (Transfer) super.setUploadProtocol(uploadProtocol);
      }

      /** Required. The name of the location to transfer. `locations/{location_id}`. */
      @com.google.api.client.util.Key
      private java.lang.String name;

      /** Required. The name of the location to transfer. `locations/{location_id}`.
       */
      public java.lang.String getName() {
        return name;
      }

      /** Required. The name of the location to transfer. `locations/{location_id}`. */
      public Transfer setName(java.lang.String name) {
        if (!getSuppressPatternChecks()) {
          com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
              "Parameter name must conform to the pattern " +
              "^locations/[^/]+$");
        }
        this.name = name;
        return this;
      }

      @Override
      public Transfer set(String parameterName, Object value) {
        return (Transfer) super.set(parameterName, value);
      }
    }

    /**
     * An accessor for creating requests from the Admins collection.
     *
     * <p>The typical use is:</p>
     * <pre>
     *   {@code MyBusinessAccountManagement mybusinessaccountmanagement = new MyBusinessAccountManagement(...);}
     *   {@code MyBusinessAccountManagement.Admins.List request = mybusinessaccountmanagement.admins().list(parameters ...)}
     * </pre>
     *
     * @return the resource collection
     */
    public Admins admins() {
      return new Admins();
    }

    /**
     * The "admins" collection of methods.
     */
    public class Admins {

      /**
       * Invites the specified user to become an administrator for the specified location. The invitee
       * must accept the invitation in order to be granted access to the location. See AcceptInvitation to
       * programmatically accept an invitation.
       *
       * Create a request for the method "admins.create".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. The resource name of the location this admin is created for.
       *        `locations/{location_id}/admins`.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
       * @return the request
       */
      public Create create(java.lang.String parent, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) throws java.io.IOException {
        Create result = new Create(parent, content);
        initialize(result);
        return result;
      }

      public class Create extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Admin> {

        private static final String REST_PATH = "v1/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^locations/[^/]+$");

        /**
         * Invites the specified user to become an administrator for the specified location. The invitee
         * must accept the invitation in order to be granted access to the location. See AcceptInvitation
         * to programmatically accept an invitation.
         *
         * Create a request for the method "admins.create".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Create#execute()} method to invoke the remote
         * operation. <p> {@link
         * Create#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The resource name of the location this admin is created for.
       *        `locations/{location_id}/admins`.
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
         * @since 1.13
         */
        protected Create(java.lang.String parent, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) {
          super(MyBusinessAccountManagement.this, "POST", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^locations/[^/]+$");
          }
        }

        @Override
        public Create set$Xgafv(java.lang.String $Xgafv) {
          return (Create) super.set$Xgafv($Xgafv);
        }

        @Override
        public Create setAccessToken(java.lang.String accessToken) {
          return (Create) super.setAccessToken(accessToken);
        }

        @Override
        public Create setAlt(java.lang.String alt) {
          return (Create) super.setAlt(alt);
        }

        @Override
        public Create setCallback(java.lang.String callback) {
          return (Create) super.setCallback(callback);
        }

        @Override
        public Create setFields(java.lang.String fields) {
          return (Create) super.setFields(fields);
        }

        @Override
        public Create setKey(java.lang.String key) {
          return (Create) super.setKey(key);
        }

        @Override
        public Create setOauthToken(java.lang.String oauthToken) {
          return (Create) super.setOauthToken(oauthToken);
        }

        @Override
        public Create setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Create) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Create setQuotaUser(java.lang.String quotaUser) {
          return (Create) super.setQuotaUser(quotaUser);
        }

        @Override
        public Create setUploadType(java.lang.String uploadType) {
          return (Create) super.setUploadType(uploadType);
        }

        @Override
        public Create setUploadProtocol(java.lang.String uploadProtocol) {
          return (Create) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The resource name of the location this admin is created for.
         * `locations/{location_id}/admins`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The resource name of the location this admin is created for.
       `locations/{location_id}/admins`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The resource name of the location this admin is created for.
         * `locations/{location_id}/admins`.
         */
        public Create setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public Create set(String parameterName, Object value) {
          return (Create) super.set(parameterName, value);
        }
      }
      /**
       * Removes the specified admin as a manager of the specified location.
       *
       * Create a request for the method "admins.delete".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Delete#execute()} method to invoke the remote
       * operation.
       *
       * @param name Required. The resource name of the admin to remove from the location.
       * @return the request
       */
      public Delete delete(java.lang.String name) throws java.io.IOException {
        Delete result = new Delete(name);
        initialize(result);
        return result;
      }

      public class Delete extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Empty> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^locations/[^/]+/admins/[^/]+$");

        /**
         * Removes the specified admin as a manager of the specified location.
         *
         * Create a request for the method "admins.delete".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Delete#execute()} method to invoke the remote
         * operation. <p> {@link
         * Delete#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Required. The resource name of the admin to remove from the location.
         * @since 1.13
         */
        protected Delete(java.lang.String name) {
          super(MyBusinessAccountManagement.this, "DELETE", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.Empty.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Delete set$Xgafv(java.lang.String $Xgafv) {
          return (Delete) super.set$Xgafv($Xgafv);
        }

        @Override
        public Delete setAccessToken(java.lang.String accessToken) {
          return (Delete) super.setAccessToken(accessToken);
        }

        @Override
        public Delete setAlt(java.lang.String alt) {
          return (Delete) super.setAlt(alt);
        }

        @Override
        public Delete setCallback(java.lang.String callback) {
          return (Delete) super.setCallback(callback);
        }

        @Override
        public Delete setFields(java.lang.String fields) {
          return (Delete) super.setFields(fields);
        }

        @Override
        public Delete setKey(java.lang.String key) {
          return (Delete) super.setKey(key);
        }

        @Override
        public Delete setOauthToken(java.lang.String oauthToken) {
          return (Delete) super.setOauthToken(oauthToken);
        }

        @Override
        public Delete setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Delete) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Delete setQuotaUser(java.lang.String quotaUser) {
          return (Delete) super.setQuotaUser(quotaUser);
        }

        @Override
        public Delete setUploadType(java.lang.String uploadType) {
          return (Delete) super.setUploadType(uploadType);
        }

        @Override
        public Delete setUploadProtocol(java.lang.String uploadProtocol) {
          return (Delete) super.setUploadProtocol(uploadProtocol);
        }

        /** Required. The resource name of the admin to remove from the location. */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Required. The resource name of the admin to remove from the location.
         */
        public java.lang.String getName() {
          return name;
        }

        /** Required. The resource name of the admin to remove from the location. */
        public Delete setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        @Override
        public Delete set(String parameterName, Object value) {
          return (Delete) super.set(parameterName, value);
        }
      }
      /**
       * Lists all of the admins for the specified location.
       *
       * Create a request for the method "admins.list".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
       * operation.
       *
       * @param parent Required. The name of the location to list admins of. `locations/{location_id}/admins`.
       * @return the request
       */
      public List list(java.lang.String parent) throws java.io.IOException {
        List result = new List(parent);
        initialize(result);
        return result;
      }

      public class List extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.ListLocationAdminsResponse> {

        private static final String REST_PATH = "v1/{+parent}/admins";

        private final java.util.regex.Pattern PARENT_PATTERN =
            java.util.regex.Pattern.compile("^locations/[^/]+$");

        /**
         * Lists all of the admins for the specified location.
         *
         * Create a request for the method "admins.list".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link List#execute()} method to invoke the remote
         * operation. <p> {@link
         * List#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must be
         * called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param parent Required. The name of the location to list admins of. `locations/{location_id}/admins`.
         * @since 1.13
         */
        protected List(java.lang.String parent) {
          super(MyBusinessAccountManagement.this, "GET", REST_PATH, null, com.google.api.services.mybusinessaccountmanagement.v1.model.ListLocationAdminsResponse.class);
          this.parent = com.google.api.client.util.Preconditions.checkNotNull(parent, "Required parameter parent must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^locations/[^/]+$");
          }
        }

        @Override
        public com.google.api.client.http.HttpResponse executeUsingHead() throws java.io.IOException {
          return super.executeUsingHead();
        }

        @Override
        public com.google.api.client.http.HttpRequest buildHttpRequestUsingHead() throws java.io.IOException {
          return super.buildHttpRequestUsingHead();
        }

        @Override
        public List set$Xgafv(java.lang.String $Xgafv) {
          return (List) super.set$Xgafv($Xgafv);
        }

        @Override
        public List setAccessToken(java.lang.String accessToken) {
          return (List) super.setAccessToken(accessToken);
        }

        @Override
        public List setAlt(java.lang.String alt) {
          return (List) super.setAlt(alt);
        }

        @Override
        public List setCallback(java.lang.String callback) {
          return (List) super.setCallback(callback);
        }

        @Override
        public List setFields(java.lang.String fields) {
          return (List) super.setFields(fields);
        }

        @Override
        public List setKey(java.lang.String key) {
          return (List) super.setKey(key);
        }

        @Override
        public List setOauthToken(java.lang.String oauthToken) {
          return (List) super.setOauthToken(oauthToken);
        }

        @Override
        public List setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (List) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public List setQuotaUser(java.lang.String quotaUser) {
          return (List) super.setQuotaUser(quotaUser);
        }

        @Override
        public List setUploadType(java.lang.String uploadType) {
          return (List) super.setUploadType(uploadType);
        }

        @Override
        public List setUploadProtocol(java.lang.String uploadProtocol) {
          return (List) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Required. The name of the location to list admins of. `locations/{location_id}/admins`.
         */
        @com.google.api.client.util.Key
        private java.lang.String parent;

        /** Required. The name of the location to list admins of. `locations/{location_id}/admins`.
         */
        public java.lang.String getParent() {
          return parent;
        }

        /**
         * Required. The name of the location to list admins of. `locations/{location_id}/admins`.
         */
        public List setParent(java.lang.String parent) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(PARENT_PATTERN.matcher(parent).matches(),
                "Parameter parent must conform to the pattern " +
                "^locations/[^/]+$");
          }
          this.parent = parent;
          return this;
        }

        @Override
        public List set(String parameterName, Object value) {
          return (List) super.set(parameterName, value);
        }
      }
      /**
       * Updates the Admin for the specified location. Only the AdminRole of the Admin can be updated.
       *
       * Create a request for the method "admins.patch".
       *
       * This request holds the parameters needed by the mybusinessaccountmanagement server.  After
       * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
       * operation.
       *
       * @param name Immutable. The resource name. For account admins, this is in the form:
       *        `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       *        `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       *        creation.
       * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
       * @return the request
       */
      public Patch patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) throws java.io.IOException {
        Patch result = new Patch(name, content);
        initialize(result);
        return result;
      }

      public class Patch extends MyBusinessAccountManagementRequest<com.google.api.services.mybusinessaccountmanagement.v1.model.Admin> {

        private static final String REST_PATH = "v1/{+name}";

        private final java.util.regex.Pattern NAME_PATTERN =
            java.util.regex.Pattern.compile("^locations/[^/]+/admins/[^/]+$");

        /**
         * Updates the Admin for the specified location. Only the AdminRole of the Admin can be updated.
         *
         * Create a request for the method "admins.patch".
         *
         * This request holds the parameters needed by the the mybusinessaccountmanagement server.  After
         * setting any optional parameters, call the {@link Patch#execute()} method to invoke the remote
         * operation. <p> {@link
         * Patch#initialize(com.google.api.client.googleapis.services.AbstractGoogleClientRequest)} must
         * be called to initialize this instance immediately after invoking the constructor. </p>
         *
         * @param name Immutable. The resource name. For account admins, this is in the form:
       *        `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       *        `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       *        creation.
         * @param content the {@link com.google.api.services.mybusinessaccountmanagement.v1.model.Admin}
         * @since 1.13
         */
        protected Patch(java.lang.String name, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin content) {
          super(MyBusinessAccountManagement.this, "PATCH", REST_PATH, content, com.google.api.services.mybusinessaccountmanagement.v1.model.Admin.class);
          this.name = com.google.api.client.util.Preconditions.checkNotNull(name, "Required parameter name must be specified.");
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/admins/[^/]+$");
          }
        }

        @Override
        public Patch set$Xgafv(java.lang.String $Xgafv) {
          return (Patch) super.set$Xgafv($Xgafv);
        }

        @Override
        public Patch setAccessToken(java.lang.String accessToken) {
          return (Patch) super.setAccessToken(accessToken);
        }

        @Override
        public Patch setAlt(java.lang.String alt) {
          return (Patch) super.setAlt(alt);
        }

        @Override
        public Patch setCallback(java.lang.String callback) {
          return (Patch) super.setCallback(callback);
        }

        @Override
        public Patch setFields(java.lang.String fields) {
          return (Patch) super.setFields(fields);
        }

        @Override
        public Patch setKey(java.lang.String key) {
          return (Patch) super.setKey(key);
        }

        @Override
        public Patch setOauthToken(java.lang.String oauthToken) {
          return (Patch) super.setOauthToken(oauthToken);
        }

        @Override
        public Patch setPrettyPrint(java.lang.Boolean prettyPrint) {
          return (Patch) super.setPrettyPrint(prettyPrint);
        }

        @Override
        public Patch setQuotaUser(java.lang.String quotaUser) {
          return (Patch) super.setQuotaUser(quotaUser);
        }

        @Override
        public Patch setUploadType(java.lang.String uploadType) {
          return (Patch) super.setUploadType(uploadType);
        }

        @Override
        public Patch setUploadProtocol(java.lang.String uploadProtocol) {
          return (Patch) super.setUploadProtocol(uploadProtocol);
        }

        /**
         * Immutable. The resource name. For account admins, this is in the form:
         * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
         * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during
         * admin creation.
         */
        @com.google.api.client.util.Key
        private java.lang.String name;

        /** Immutable. The resource name. For account admins, this is in the form:
       `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
       `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
       creation.
         */
        public java.lang.String getName() {
          return name;
        }

        /**
         * Immutable. The resource name. For account admins, this is in the form:
         * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
         * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during
         * admin creation.
         */
        public Patch setName(java.lang.String name) {
          if (!getSuppressPatternChecks()) {
            com.google.api.client.util.Preconditions.checkArgument(NAME_PATTERN.matcher(name).matches(),
                "Parameter name must conform to the pattern " +
                "^locations/[^/]+/admins/[^/]+$");
          }
          this.name = name;
          return this;
        }

        /**
         * Required. The specific fields that should be updated. The only editable field is role.
         */
        @com.google.api.client.util.Key
        private String updateMask;

        /** Required. The specific fields that should be updated. The only editable field is role.
         */
        public String getUpdateMask() {
          return updateMask;
        }

        /**
         * Required. The specific fields that should be updated. The only editable field is role.
         */
        public Patch setUpdateMask(String updateMask) {
          this.updateMask = updateMask;
          return this;
        }

        @Override
        public Patch set(String parameterName, Object value) {
          return (Patch) super.set(parameterName, value);
        }
      }

    }
  }

  /**
   * Builder for {@link MyBusinessAccountManagement}.
   *
   * <p>
   * Implementation is not thread-safe.
   * </p>
   *
   * @since 1.3.0
   */
  public static final class Builder extends com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient.Builder {

    private static String chooseEndpoint(com.google.api.client.http.HttpTransport transport) {
      // If the GOOGLE_API_USE_MTLS_ENDPOINT environment variable value is "always", use mTLS endpoint.
      // If the env variable is "auto", use mTLS endpoint if and only if the transport is mTLS.
      // Use the regular endpoint for all other cases.
      String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
      useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
      if ("always".equals(useMtlsEndpoint) || ("auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls())) {
        return DEFAULT_MTLS_ROOT_URL;
      }
      return DEFAULT_ROOT_URL;
    }

    /**
     * Returns an instance of a new builder.
     *
     * @param transport HTTP transport, which should normally be:
     *        <ul>
     *        <li>Google App Engine:
     *        {@code com.google.api.client.extensions.appengine.http.UrlFetchTransport}</li>
     *        <li>Android: {@code newCompatibleTransport} from
     *        {@code com.google.api.client.extensions.android.http.AndroidHttp}</li>
     *        <li>Java: {@link com.google.api.client.googleapis.javanet.GoogleNetHttpTransport#newTrustedTransport()}
     *        </li>
     *        </ul>
     * @param jsonFactory JSON factory, which may be:
     *        <ul>
     *        <li>Jackson: {@code com.google.api.client.json.jackson2.JacksonFactory}</li>
     *        <li>Google GSON: {@code com.google.api.client.json.gson.GsonFactory}</li>
     *        <li>Android Honeycomb or higher:
     *        {@code com.google.api.client.extensions.android.json.AndroidJsonFactory}</li>
     *        </ul>
     * @param httpRequestInitializer HTTP request initializer or {@code null} for none
     * @since 1.7
     */
    public Builder(com.google.api.client.http.HttpTransport transport, com.google.api.client.json.JsonFactory jsonFactory,
        com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      super(
          transport,
          jsonFactory,
          Builder.chooseEndpoint(transport),
          DEFAULT_SERVICE_PATH,
          httpRequestInitializer,
          false);
      setBatchPath(DEFAULT_BATCH_PATH);
    }

    /** Builds a new instance of {@link MyBusinessAccountManagement}. */
    @Override
    public MyBusinessAccountManagement build() {
      return new MyBusinessAccountManagement(this);
    }

    @Override
    public Builder setRootUrl(String rootUrl) {
      return (Builder) super.setRootUrl(rootUrl);
    }

    @Override
    public Builder setServicePath(String servicePath) {
      return (Builder) super.setServicePath(servicePath);
    }

    @Override
    public Builder setBatchPath(String batchPath) {
      return (Builder) super.setBatchPath(batchPath);
    }

    @Override
    public Builder setHttpRequestInitializer(com.google.api.client.http.HttpRequestInitializer httpRequestInitializer) {
      return (Builder) super.setHttpRequestInitializer(httpRequestInitializer);
    }

    @Override
    public Builder setApplicationName(String applicationName) {
      return (Builder) super.setApplicationName(applicationName);
    }

    @Override
    public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
      return (Builder) super.setSuppressPatternChecks(suppressPatternChecks);
    }

    @Override
    public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
      return (Builder) super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
    }

    @Override
    public Builder setSuppressAllChecks(boolean suppressAllChecks) {
      return (Builder) super.setSuppressAllChecks(suppressAllChecks);
    }

    /**
     * Set the {@link MyBusinessAccountManagementRequestInitializer}.
     *
     * @since 1.12
     */
    public Builder setMyBusinessAccountManagementRequestInitializer(
        MyBusinessAccountManagementRequestInitializer mybusinessaccountmanagementRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(mybusinessaccountmanagementRequestInitializer);
    }

    @Override
    public Builder setGoogleClientRequestInitializer(
        com.google.api.client.googleapis.services.GoogleClientRequestInitializer googleClientRequestInitializer) {
      return (Builder) super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
    }
  }
}
