/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.mybusinessaccountmanagement.v1.model;

/**
 * An account is a container for your location. If you are the only user who manages locations for
 * your business, you can use your personal Google Account. To share management of locations with
 * multiple users, [create a business account]
 * (https://support.google.com/business/answer/6085339?ref_topic=6085325).
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the My Business Account Management API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Account extends com.google.api.client.json.GenericJson {

  /**
   * Required. The name of the account. For an account of type `PERSONAL`, this is the first and
   * last name of the user account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountName;

  /**
   * Output only. Account reference number if provisioned.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String accountNumber;

  /**
   * Immutable. The resource name, in the format `accounts/{account_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Additional info for an organization. This is populated only for an organization
   * account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private OrganizationInfo organizationInfo;

  /**
   * Output only. Specifies the permission level the user has for this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String permissionLevel;

  /**
   * Required. Input only. The resource name of the account which will be the primary owner of the
   * account being created. It should be of the form `accounts/{account_id}/`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String primaryOwner;

  /**
   * Output only. Specifies the AccountRole of this account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Required. Contains the type of account. Accounts of type PERSONAL and ORGANIZATION cannot be
   * created using this API.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String type;

  /**
   * Output only. If verified, future locations that are created are automatically connected to
   * Google Maps, and have Google+ pages created, without requiring moderation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String verificationState;

  /**
   * Output only. Indicates whether the account is vetted by Google. A vetted account is able to
   * verify locations via the VETTED_PARTNER method.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String vettedState;

  /**
   * Required. The name of the account. For an account of type `PERSONAL`, this is the first and
   * last name of the user account.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountName() {
    return accountName;
  }

  /**
   * Required. The name of the account. For an account of type `PERSONAL`, this is the first and
   * last name of the user account.
   * @param accountName accountName or {@code null} for none
   */
  public Account setAccountName(java.lang.String accountName) {
    this.accountName = accountName;
    return this;
  }

  /**
   * Output only. Account reference number if provisioned.
   * @return value or {@code null} for none
   */
  public java.lang.String getAccountNumber() {
    return accountNumber;
  }

  /**
   * Output only. Account reference number if provisioned.
   * @param accountNumber accountNumber or {@code null} for none
   */
  public Account setAccountNumber(java.lang.String accountNumber) {
    this.accountNumber = accountNumber;
    return this;
  }

  /**
   * Immutable. The resource name, in the format `accounts/{account_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Immutable. The resource name, in the format `accounts/{account_id}`.
   * @param name name or {@code null} for none
   */
  public Account setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Additional info for an organization. This is populated only for an organization
   * account.
   * @return value or {@code null} for none
   */
  public OrganizationInfo getOrganizationInfo() {
    return organizationInfo;
  }

  /**
   * Output only. Additional info for an organization. This is populated only for an organization
   * account.
   * @param organizationInfo organizationInfo or {@code null} for none
   */
  public Account setOrganizationInfo(OrganizationInfo organizationInfo) {
    this.organizationInfo = organizationInfo;
    return this;
  }

  /**
   * Output only. Specifies the permission level the user has for this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getPermissionLevel() {
    return permissionLevel;
  }

  /**
   * Output only. Specifies the permission level the user has for this account.
   * @param permissionLevel permissionLevel or {@code null} for none
   */
  public Account setPermissionLevel(java.lang.String permissionLevel) {
    this.permissionLevel = permissionLevel;
    return this;
  }

  /**
   * Required. Input only. The resource name of the account which will be the primary owner of the
   * account being created. It should be of the form `accounts/{account_id}/`.
   * @return value or {@code null} for none
   */
  public java.lang.String getPrimaryOwner() {
    return primaryOwner;
  }

  /**
   * Required. Input only. The resource name of the account which will be the primary owner of the
   * account being created. It should be of the form `accounts/{account_id}/`.
   * @param primaryOwner primaryOwner or {@code null} for none
   */
  public Account setPrimaryOwner(java.lang.String primaryOwner) {
    this.primaryOwner = primaryOwner;
    return this;
  }

  /**
   * Output only. Specifies the AccountRole of this account.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Output only. Specifies the AccountRole of this account.
   * @param role role or {@code null} for none
   */
  public Account setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * Required. Contains the type of account. Accounts of type PERSONAL and ORGANIZATION cannot be
   * created using this API.
   * @return value or {@code null} for none
   */
  public java.lang.String getType() {
    return type;
  }

  /**
   * Required. Contains the type of account. Accounts of type PERSONAL and ORGANIZATION cannot be
   * created using this API.
   * @param type type or {@code null} for none
   */
  public Account setType(java.lang.String type) {
    this.type = type;
    return this;
  }

  /**
   * Output only. If verified, future locations that are created are automatically connected to
   * Google Maps, and have Google+ pages created, without requiring moderation.
   * @return value or {@code null} for none
   */
  public java.lang.String getVerificationState() {
    return verificationState;
  }

  /**
   * Output only. If verified, future locations that are created are automatically connected to
   * Google Maps, and have Google+ pages created, without requiring moderation.
   * @param verificationState verificationState or {@code null} for none
   */
  public Account setVerificationState(java.lang.String verificationState) {
    this.verificationState = verificationState;
    return this;
  }

  /**
   * Output only. Indicates whether the account is vetted by Google. A vetted account is able to
   * verify locations via the VETTED_PARTNER method.
   * @return value or {@code null} for none
   */
  public java.lang.String getVettedState() {
    return vettedState;
  }

  /**
   * Output only. Indicates whether the account is vetted by Google. A vetted account is able to
   * verify locations via the VETTED_PARTNER method.
   * @param vettedState vettedState or {@code null} for none
   */
  public Account setVettedState(java.lang.String vettedState) {
    this.vettedState = vettedState;
    return this;
  }

  @Override
  public Account set(String fieldName, Object value) {
    return (Account) super.set(fieldName, value);
  }

  @Override
  public Account clone() {
    return (Account) super.clone();
  }

}
