/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.mybusinessaccountmanagement.v1.model;

/**
 * An administrator of an Account or a location.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the My Business Account Management API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Admin extends com.google.api.client.json.GenericJson {

  /**
   * Optional. The name of the admin. When making the initial invitation, this is the invitee's
   * email address. On `GET` calls, the user's email address is returned if the invitation is still
   * pending. Otherwise, it contains the user's first and last names. This field is only needed to
   * be set during admin creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String admin;

  /**
   * Immutable. The resource name. For account admins, this is in the form:
   * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
   * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
   * creation.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. Indicates whether this admin has a pending invitation for the specified resource.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.Boolean pendingInvitation;

  /**
   * Required. Specifies the role that this admin uses with the specified Account or Location.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * Optional. The name of the admin. When making the initial invitation, this is the invitee's
   * email address. On `GET` calls, the user's email address is returned if the invitation is still
   * pending. Otherwise, it contains the user's first and last names. This field is only needed to
   * be set during admin creation.
   * @return value or {@code null} for none
   */
  public java.lang.String getAdmin() {
    return admin;
  }

  /**
   * Optional. The name of the admin. When making the initial invitation, this is the invitee's
   * email address. On `GET` calls, the user's email address is returned if the invitation is still
   * pending. Otherwise, it contains the user's first and last names. This field is only needed to
   * be set during admin creation.
   * @param admin admin or {@code null} for none
   */
  public Admin setAdmin(java.lang.String admin) {
    this.admin = admin;
    return this;
  }

  /**
   * Immutable. The resource name. For account admins, this is in the form:
   * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
   * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
   * creation.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Immutable. The resource name. For account admins, this is in the form:
   * `accounts/{account_id}/admins/{admin_id}` For location admins, this is in the form:
   * `locations/{location_id}/admins/{admin_id}` This field will be ignored if set during admin
   * creation.
   * @param name name or {@code null} for none
   */
  public Admin setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. Indicates whether this admin has a pending invitation for the specified resource.
   * @return value or {@code null} for none
   */
  public java.lang.Boolean getPendingInvitation() {
    return pendingInvitation;
  }

  /**
   * Output only. Indicates whether this admin has a pending invitation for the specified resource.
   * @param pendingInvitation pendingInvitation or {@code null} for none
   */
  public Admin setPendingInvitation(java.lang.Boolean pendingInvitation) {
    this.pendingInvitation = pendingInvitation;
    return this;
  }

  /**
   * Required. Specifies the role that this admin uses with the specified Account or Location.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Required. Specifies the role that this admin uses with the specified Account or Location.
   * @param role role or {@code null} for none
   */
  public Admin setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  @Override
  public Admin set(String fieldName, Object value) {
    return (Admin) super.set(fieldName, value);
  }

  @Override
  public Admin clone() {
    return (Admin) super.clone();
  }

}
