/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.mybusinessaccountmanagement.v1.model;

/**
 * Represents a pending invitation.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the My Business Account Management API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class Invitation extends com.google.api.client.json.GenericJson {

  /**
   * Required. The resource name for the invitation.
   * `accounts/{account_id}/invitations/{invitation_id}`.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String name;

  /**
   * Output only. The invited role on the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String role;

  /**
   * The sparsely populated account this invitation is for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private Account targetAccount;

  /**
   * The target location this invitation is for.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private TargetLocation targetLocation;

  /**
   * Output only. Specifies which target types should appear in the response.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String targetType;

  /**
   * Required. The resource name for the invitation.
   * `accounts/{account_id}/invitations/{invitation_id}`.
   * @return value or {@code null} for none
   */
  public java.lang.String getName() {
    return name;
  }

  /**
   * Required. The resource name for the invitation.
   * `accounts/{account_id}/invitations/{invitation_id}`.
   * @param name name or {@code null} for none
   */
  public Invitation setName(java.lang.String name) {
    this.name = name;
    return this;
  }

  /**
   * Output only. The invited role on the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getRole() {
    return role;
  }

  /**
   * Output only. The invited role on the account.
   * @param role role or {@code null} for none
   */
  public Invitation setRole(java.lang.String role) {
    this.role = role;
    return this;
  }

  /**
   * The sparsely populated account this invitation is for.
   * @return value or {@code null} for none
   */
  public Account getTargetAccount() {
    return targetAccount;
  }

  /**
   * The sparsely populated account this invitation is for.
   * @param targetAccount targetAccount or {@code null} for none
   */
  public Invitation setTargetAccount(Account targetAccount) {
    this.targetAccount = targetAccount;
    return this;
  }

  /**
   * The target location this invitation is for.
   * @return value or {@code null} for none
   */
  public TargetLocation getTargetLocation() {
    return targetLocation;
  }

  /**
   * The target location this invitation is for.
   * @param targetLocation targetLocation or {@code null} for none
   */
  public Invitation setTargetLocation(TargetLocation targetLocation) {
    this.targetLocation = targetLocation;
    return this;
  }

  /**
   * Output only. Specifies which target types should appear in the response.
   * @return value or {@code null} for none
   */
  public java.lang.String getTargetType() {
    return targetType;
  }

  /**
   * Output only. Specifies which target types should appear in the response.
   * @param targetType targetType or {@code null} for none
   */
  public Invitation setTargetType(java.lang.String targetType) {
    this.targetType = targetType;
    return this;
  }

  @Override
  public Invitation set(String fieldName, Object value) {
    return (Invitation) super.set(fieldName, value);
  }

  @Override
  public Invitation clone() {
    return (Invitation) super.clone();
  }

}
