/*
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except
 * in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License
 * is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied. See the License for the specific language governing permissions and limitations under
 * the License.
 */
/*
 * This code was generated by https://github.com/googleapis/google-api-java-client-services/
 * Modify at your own risk.
 */

package com.google.api.services.mybusinessaccountmanagement.v1.model;

/**
 * Additional information stored for an organization.
 *
 * <p> This is the Java data model class that specifies how to parse/serialize into the JSON that is
 * transmitted over HTTP when working with the My Business Account Management API. For a detailed
 * explanation see:
 * <a href="https://developers.google.com/api-client-library/java/google-http-java-client/json">https://developers.google.com/api-client-library/java/google-http-java-client/json</a>
 * </p>
 *
 * @author Google, Inc.
 */
@SuppressWarnings("javadoc")
public final class OrganizationInfo extends com.google.api.client.json.GenericJson {

  /**
   * Output only. The postal address for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private PostalAddress address;

  /**
   * Output only. The contact number for the organization.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String phoneNumber;

  /**
   * Output only. The registered domain for the account.
   * The value may be {@code null}.
   */
  @com.google.api.client.util.Key
  private java.lang.String registeredDomain;

  /**
   * Output only. The postal address for the account.
   * @return value or {@code null} for none
   */
  public PostalAddress getAddress() {
    return address;
  }

  /**
   * Output only. The postal address for the account.
   * @param address address or {@code null} for none
   */
  public OrganizationInfo setAddress(PostalAddress address) {
    this.address = address;
    return this;
  }

  /**
   * Output only. The contact number for the organization.
   * @return value or {@code null} for none
   */
  public java.lang.String getPhoneNumber() {
    return phoneNumber;
  }

  /**
   * Output only. The contact number for the organization.
   * @param phoneNumber phoneNumber or {@code null} for none
   */
  public OrganizationInfo setPhoneNumber(java.lang.String phoneNumber) {
    this.phoneNumber = phoneNumber;
    return this;
  }

  /**
   * Output only. The registered domain for the account.
   * @return value or {@code null} for none
   */
  public java.lang.String getRegisteredDomain() {
    return registeredDomain;
  }

  /**
   * Output only. The registered domain for the account.
   * @param registeredDomain registeredDomain or {@code null} for none
   */
  public OrganizationInfo setRegisteredDomain(java.lang.String registeredDomain) {
    this.registeredDomain = registeredDomain;
    return this;
  }

  @Override
  public OrganizationInfo set(String fieldName, Object value) {
    return (OrganizationInfo) super.set(fieldName, value);
  }

  @Override
  public OrganizationInfo clone() {
    return (OrganizationInfo) super.clone();
  }

}
