/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.html.types;

import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyle;
import com.google.appengine.repackaged.com.google.common.html.types.SafeStyleProto;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CheckReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CompileTimeConstant;

@CheckReturnValue
@GwtCompatible
public final class SafeStyles {
    private SafeStyles() {
    }

    public static SafeStyle fromConstant(@CompileTimeConstant String style) {
        if (style.length() == 0) {
            return SafeStyle.EMPTY;
        }
        for (int i = 0; i < style.length(); ++i) {
            if (style.charAt(i) != '<' && style.charAt(i) != '>') continue;
            String string = String.valueOf(style);
            throw new IllegalArgumentException(string.length() != 0 ? "Forbidden characters in style string: ".concat(string) : new String("Forbidden characters in style string: "));
        }
        if (style.charAt(style.length() - 1) != ';') {
            String string = String.valueOf(style);
            throw new IllegalArgumentException(string.length() != 0 ? "Last character of style string is not ';': ".concat(string) : new String("Last character of style string is not ';': "));
        }
        if (!style.contains(":")) {
            String string = String.valueOf(style);
            throw new IllegalArgumentException(string.length() != 0 ? "Style string must contain at least one ':', to specify a \"name: value\" pair: ".concat(string) : new String("Style string must contain at least one ':', to specify a \"name: value\" pair: "));
        }
        return SafeStyles.create(style);
    }

    public static SafeStyle fromProto(SafeStyleProto proto) {
        return SafeStyles.create(proto.getPrivateDoNotAccessOrElseSafeStyleWrappedValue());
    }

    public static SafeStyleProto toProto(SafeStyle style) {
        return SafeStyleProto.newBuilder().setPrivateDoNotAccessOrElseSafeStyleWrappedValue(style.getSafeStyleString()).build();
    }

    public static SafeStyle concat(SafeStyle ... styles) {
        StringBuilder styleString = new StringBuilder();
        for (SafeStyle style : styles) {
            styleString.append(style.getSafeStyleString());
        }
        return SafeStyles.create(styleString.toString());
    }

    static SafeStyle create(String style) {
        return new SafeStyle(style);
    }
}

