/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.util.concurrent;

import com.google.appengine.repackaged.com.google.common.annotations.GoogleInternal;
import com.google.appengine.repackaged.com.google.common.annotations.GwtCompatible;
import com.google.appengine.repackaged.com.google.common.annotations.GwtIncompatible;
import com.google.appengine.repackaged.com.google.common.base.Pair;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.common.util.concurrent.AggregateFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ListenableFuture;
import com.google.appengine.repackaged.com.google.common.util.concurrent.ParametricNullness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.CheckForNull;
import org.jspecify.nullness.NullMarked;
import org.jspecify.nullness.Nullable;

@NullMarked
@GwtCompatible(emulated=true)
abstract class CollectionFuture<V, C>
extends AggregateFuture<V, C> {
    @CheckForNull
    private List<@Nullable Present<V>> values;

    CollectionFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
        super(futures, allMustSucceed, true);
        List<@Nullable T> values = futures.isEmpty() ? Collections.emptyList() : Lists.newArrayListWithCapacity(futures.size());
        for (int i = 0; i < futures.size(); ++i) {
            values.add(null);
        }
        this.values = values;
    }

    @Override
    final void collectOneValue(int index, @ParametricNullness V returnValue) {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            localValues.set(index, new Present<V>(returnValue));
        }
    }

    @Override
    final void handleAllCompleted() {
        List<@Nullable Present<V>> localValues = this.values;
        if (localValues != null) {
            this.set(this.combine(localValues));
        }
    }

    @Override
    void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
        super.releaseResources(reason);
        this.values = null;
    }

    abstract C combine(List<@Nullable Present<V>> var1);

    private static final class Present<V> {
        V value;

        Present(V value) {
            this.value = value;
        }
    }

    @GoogleInternal
    @GwtIncompatible
    static final class MapFuture<K, V>
    extends CollectionFuture<V, Map<K, V>> {
        @CheckForNull
        private ImmutableMap<? extends K, ? extends Future<? extends V>> futures;

        MapFuture(ImmutableMap<? extends K, ? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures.values(), allMustSucceed);
            this.futures = futures;
            this.init();
        }

        @Override
        public Map<K, V> combine(List<@Nullable Present<V>> values) {
            LinkedHashMap result = Maps.newLinkedHashMapWithExpectedSize(values.size());
            ImmutableMap<K, Future<V>> localFutures = this.futures;
            if (localFutures == null) {
                return Collections.emptyMap();
            }
            for (Pair entry : Iterables.pairUp(localFutures.keySet(), values)) {
                if (entry.second == null) continue;
                result.put(entry.first, ((Present)entry.second).value);
            }
            return Collections.unmodifiableMap(result);
        }

        @Override
        void releaseResources(AggregateFuture.ReleaseResourcesReason reason) {
            super.releaseResources(reason);
            this.futures = null;
        }
    }

    static final class ListFuture<V>
    extends CollectionFuture<V, List<V>> {
        ListFuture(ImmutableCollection<? extends ListenableFuture<? extends V>> futures, boolean allMustSucceed) {
            super(futures, allMustSucceed);
            this.init();
        }

        @Override
        public List<@Nullable V> combine(List<@Nullable Present<V>> values) {
            ArrayList<@Nullable Object> result = Lists.newArrayListWithCapacity(values.size());
            for (Present<V> element : values) {
                result.add(element != null ? (Object)element.value : null);
            }
            return Collections.unmodifiableList(result);
        }
    }
}

