/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.http.GenericUrl;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequest;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.appengine.repackaged.com.google.api.client.http.HttpResponse;
import com.google.appengine.repackaged.com.google.api.client.http.protobuf.ProtoHttpContent;
import com.google.appengine.repackaged.com.google.api.client.util.IOUtils;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.datastore.v1.client.ChecksumEnforcingInputStream;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreException;
import com.google.appengine.repackaged.com.google.datastore.v1.client.EndToEndChecksumHandler;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.rpc.Code;
import com.google.appengine.repackaged.com.google.rpc.Status;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class RemoteRpc {
    private static final Logger logger = Logger.getLogger(RemoteRpc.class.getName());
    @VisibleForTesting
    static final String API_FORMAT_VERSION_HEADER = "X-Goog-Api-Format-Version";
    private static final String API_FORMAT_VERSION = "2";
    private final HttpRequestFactory client;
    private final HttpRequestInitializer initializer;
    private final String url;
    private final AtomicInteger rpcCount = new AtomicInteger(0);
    private static boolean enableE2EChecksum = Boolean.parseBoolean(System.getenv("GOOGLE_CLOUD_DATASTORE_HTTP_ENABLE_E2E_CHECKSUM"));

    RemoteRpc(HttpRequestFactory client, HttpRequestInitializer initializer, String url) {
        this.client = client;
        this.initializer = initializer;
        this.url = url;
        try {
            this.resolveURL("dummyRpc");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(new StringBuilder(56 + String.valueOf(url).length()).append("Unable to construct RemoteRpc due to unsupported url: <").append(url).append(">").toString(), e);
        }
    }

    public InputStream call(String methodName, MessageLite request) throws DatastoreException {
        String string = String.valueOf(methodName);
        logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc", "call", string.length() != 0 ? "remote datastore call ".concat(string) : new String("remote datastore call "));
        long startTime = System.currentTimeMillis();
        try {
            HttpResponse httpResponse;
            this.rpcCount.incrementAndGet();
            ProtoHttpContent payload = new ProtoHttpContent(request);
            HttpRequest httpRequest = this.client.buildPostRequest(this.resolveURL(methodName), payload);
            this.setHeaders(request, httpRequest);
            httpRequest.setThrowExceptionOnExecuteError(false);
            httpRequest.setReadTimeout(65000);
            if (this.initializer != null) {
                this.initializer.initialize(httpRequest);
            }
            if (!(httpResponse = httpRequest.execute()).isSuccessStatusCode()) {
                InputStream content = httpResponse.getContent();
                try {
                    throw RemoteRpc.makeException(this.url, methodName, content, httpResponse.getContentType(), httpResponse.getContentCharset(), null, httpResponse.getStatusCode());
                }
                catch (Throwable throwable) {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            InputStream inputStream = httpResponse.getContent();
            InputStream inputStream2 = enableE2EChecksum && EndToEndChecksumHandler.hasChecksumHeader(httpResponse) ? new ChecksumEnforcingInputStream(inputStream, httpResponse) : inputStream;
            return inputStream2;
        }
        catch (SocketTimeoutException e) {
            throw RemoteRpc.makeException(this.url, methodName, Code.DEADLINE_EXCEEDED, "Deadline exceeded", e);
        }
        catch (IOException e) {
            throw RemoteRpc.makeException(this.url, methodName, Code.UNAVAILABLE, "I/O error", e);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc", "call", new StringBuilder(51 + String.valueOf(methodName).length()).append("remote datastore call ").append(methodName).append(" took ").append(elapsedTime).append(" ms").toString());
        }
    }

    @VisibleForTesting
    void setHeaders(MessageLite request, HttpRequest httpRequest) {
        String checksum;
        httpRequest.getHeaders().put(API_FORMAT_VERSION_HEADER, (Object)API_FORMAT_VERSION);
        if (enableE2EChecksum && request != null && (checksum = EndToEndChecksumHandler.computeChecksum(request.toByteArray())) != null) {
            httpRequest.getHeaders().put("x-request-checksum-348659783", (Object)checksum);
        }
    }

    @VisibleForTesting
    HttpRequestFactory getClient() {
        return this.client;
    }

    @VisibleForTesting
    static void setSystemEnvE2EChecksum(boolean enableE2EChecksum) {
        RemoteRpc.enableE2EChecksum = enableE2EChecksum;
    }

    void resetRpcCount() {
        this.rpcCount.set(0);
    }

    int getRpcCount() {
        return this.rpcCount.get();
    }

    public String getUrl() {
        return this.url;
    }

    GenericUrl resolveURL(String path) {
        String string = this.url;
        return new GenericUrl(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(path).length()).append(string).append(":").append(path).toString());
    }

    HttpRequestFactory getHttpRequestFactory() {
        return this.client;
    }

    public static DatastoreException makeException(String url, String methodName, Code code, String message, Throwable cause) {
        logger.logp(Level.FINE, "com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc", "makeException", new StringBuilder(40 + String.valueOf(methodName).length() + String.valueOf(url).length() + String.valueOf(message).length()).append("remote datastore call ").append(methodName).append(" against ").append(url).append(" failed: ").append(message).toString());
        return new DatastoreException(methodName, code, message, cause);
    }

    static DatastoreException makeException(String url, String methodName, InputStream content, String contentType, Charset contentCharset, Throwable cause, int httpStatusCode) {
        Status rpcStatus;
        if (!contentType.equals("application/x-protobuf")) {
            String responseContent;
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                IOUtils.copy(content, out, false);
                responseContent = out.toString(contentCharset.name());
            }
            catch (IOException e) {
                responseContent = "";
            }
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Non-protobuf error: %s. HTTP status code was %d.", responseContent, httpStatusCode), cause);
        }
        try {
            rpcStatus = Status.parseFrom(content);
        }
        catch (IOException e) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Unable to parse Status protocol buffer: HTTP status code was %s.", httpStatusCode), e);
        }
        Code code = Code.forNumber(rpcStatus.getCode());
        if (code == null) {
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Invalid error code: %d. Message: %s.", rpcStatus.getCode(), rpcStatus.getMessage()), cause);
        }
        if (code == Code.OK) {
            if (httpStatusCode == 401) {
                return RemoteRpc.makeException(url, methodName, Code.UNAUTHENTICATED, "Unauthenticated.", cause);
            }
            return RemoteRpc.makeException(url, methodName, Code.INTERNAL, String.format("Unexpected OK error code with HTTP status code of %d. Message: %s.", httpStatusCode, rpcStatus.getMessage()), cause);
        }
        return RemoteRpc.makeException(url, methodName, code, rpcStatus.getMessage(), cause);
    }
}

