/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.gson.internal.reflect;

import com.google.appengine.repackaged.com.google.gson.JsonIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;

public class ReflectionHelper {
    private ReflectionHelper() {
    }

    public static void makeAccessible(Field field) throws JsonIOException {
        try {
            field.setAccessible(true);
        }
        catch (Exception exception) {
            String string = field.getDeclaringClass().getName();
            String string2 = field.getName();
            throw new JsonIOException(new StringBuilder(117 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failed making field '").append(string).append("#").append(string2).append("' accessible; either change its visibility or write a custom TypeAdapter for its declaring type").toString(), exception);
        }
    }

    private static String constructorToString(Constructor<?> constructor) {
        StringBuilder stringBuilder = new StringBuilder(constructor.getDeclaringClass().getName()).append('#').append(constructor.getDeclaringClass().getSimpleName()).append('(');
        Class<?>[] parameters = constructor.getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            if (i > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(parameters[i].getSimpleName());
        }
        return stringBuilder.append(')').toString();
    }

    public static String tryMakeAccessible(Constructor<?> constructor) {
        try {
            constructor.setAccessible(true);
            return null;
        }
        catch (Exception exception) {
            String string = ReflectionHelper.constructorToString(constructor);
            String string2 = exception.getMessage();
            return new StringBuilder(143 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Failed making constructor '").append(string).append("' accessible; either change its visibility or write a custom InstanceCreator or TypeAdapter for its declaring type: ").append(string2).toString();
        }
    }
}

