/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.dev;

import com.google.appengine.api.search.dev.BinaryNumericExpression;
import com.google.appengine.api.search.dev.EvaluationException;
import com.google.appengine.api.search.dev.Expression;
import com.google.appengine.api.search.dev.FieldExpression;
import com.google.appengine.api.search.dev.LuceneUtils;
import com.google.appengine.api.search.dev.NumericExpression;
import com.google.appengine.api.search.dev.RankExpression;
import com.google.appengine.api.search.dev.ScoreExpression;
import com.google.appengine.api.search.dev.SearchException;
import com.google.appengine.api.search.dev.SnippetExpression;
import com.google.appengine.api.search.query.ExpressionLexer;
import com.google.appengine.api.search.query.ExpressionParser;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.geometry.S2LatLng;
import com.google.appengine.repackaged.org.antlr.runtime.ANTLRStringStream;
import com.google.appengine.repackaged.org.antlr.runtime.CharStream;
import com.google.appengine.repackaged.org.antlr.runtime.RecognitionException;
import com.google.appengine.repackaged.org.antlr.runtime.TokenRewriteStream;
import com.google.appengine.repackaged.org.antlr.runtime.TokenSource;
import com.google.appengine.repackaged.org.antlr.runtime.TokenStream;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;
import com.google.appengine.repackaged.org.apache.lucene.document.Document;
import com.google.appengine.repackaged.org.apache.lucene.document.Field;
import com.google.apphosting.api.search.DocumentPb;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExpressionBuilder {
    private static final Logger log = Logger.getLogger(ExpressionBuilder.class.getName());
    private final Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes;

    public ExpressionBuilder(Map<String, Set<DocumentPb.FieldValue.ContentType>> fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public Expression parse(String expr) {
        Tree tree;
        if (expr == null) {
            throw new IllegalArgumentException("Unexpected null expression");
        }
        String trimmed = expr.trim();
        if (trimmed.isEmpty()) {
            return new EmptyExpression();
        }
        ANTLRStringStream stream = new ANTLRStringStream(expr);
        ExpressionLexer lexer = new ExpressionLexer((CharStream)stream);
        TokenRewriteStream tokens = new TokenRewriteStream((TokenSource)lexer);
        ExpressionParser parser = new ExpressionParser((TokenStream)tokens);
        try {
            tree = (Tree)parser.expression().getTree();
        }
        catch (RecognitionException cause) {
            String message = String.format("parse error at line %d position %d", cause.line, cause.charPositionInLine);
            throw new IllegalArgumentException(message);
        }
        if (!tree.isNil()) {
            String string = String.valueOf(expr);
            throw new IllegalArgumentException(string.length() != 0 ? "AST is missing nil root ".concat(string) : new String("AST is missing nil root "));
        }
        return this.makeExpression(tree.getChild(0));
    }

    private void print(int offset, String msg) {
        for (int i = 0; i < offset; ++i) {
            System.err.print(" ");
        }
        System.err.println(msg);
    }

    private void dumpTree(Tree tree, int offset) {
        this.print(offset, String.format("%s", ExpressionBuilder.getTokenName(tree.getType())));
        if (!tree.getText().isEmpty()) {
            this.print(offset + 2, String.format("TEXT: %s", tree.getText()));
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            this.print(offset, String.format("%s[%d]", ExpressionBuilder.getTokenName(tree.getType()), i));
            this.dumpTree(tree.getChild(i), offset + 2);
        }
    }

    private String getText(Tree tree) {
        if (tree.getType() == 26) {
            return tree.getText();
        }
        if (tree.getType() == 35) {
            String text = tree.getText();
            return text.substring(1, text.length() - 1);
        }
        String string = String.valueOf(ExpressionBuilder.getTokenName(tree.getType()));
        throw new IllegalArgumentException(string.length() != 0 ? "text expression expected instead of ".concat(string) : new String("text expression expected instead of "));
    }

    private CountFieldsFunction makeCountFieldsFunction(Tree tree) {
        Object luceneFieldNames;
        if (tree.getChildCount() != 1) {
            throw new IllegalArgumentException("count() requires exactly 1 argument");
        }
        Tree field = tree.getChild(0);
        if (field.getType() != 26) {
            throw new IllegalArgumentException("Field name expected");
        }
        String fieldName = field.getText();
        Set<DocumentPb.FieldValue.ContentType> types = this.fieldTypes.get(fieldName);
        if (types == null) {
            luceneFieldNames = ImmutableList.of();
        } else {
            luceneFieldNames = new ArrayList(types.size());
            for (DocumentPb.FieldValue.ContentType type : types) {
                luceneFieldNames.add(LuceneUtils.makeLuceneFieldName(fieldName, type));
            }
        }
        return new CountFieldsFunction((List<String>)luceneFieldNames, fieldName);
    }

    private NumericExpression makeAbsoluteValueFunction(Tree tree) {
        if (tree.getChildCount() != 1) {
            throw new IllegalArgumentException("abs() requires exactly 1 argument");
        }
        final NumericExpression arg = this.makeNumericExpression(tree.getChild(0));
        return new NumericExpression(this){

            @Override
            public double evalDouble(Document doc) throws EvaluationException {
                return Math.abs(arg.evalDouble(doc));
            }
        };
    }

    private NumericExpression makeLogFunction(Tree tree) {
        if (tree.getChildCount() != 1) {
            throw new IllegalArgumentException("log() requires exactly 1 argument");
        }
        final NumericExpression arg = this.makeNumericExpression(tree.getChild(0));
        return new NumericExpression(this){

            @Override
            public double evalDouble(Document doc) throws EvaluationException {
                return Math.log(arg.evalDouble(doc));
            }
        };
    }

    private NumericExpression makeMinFunction(Tree tree) {
        final int n = tree.getChildCount();
        if (n < 2) {
            throw new IllegalArgumentException("min() requires at least 2 arguments");
        }
        final NumericExpression[] args = new NumericExpression[n];
        for (int i = 0; i < n; ++i) {
            args[i] = this.makeNumericExpression(tree.getChild(i));
        }
        return new NumericExpression(this){

            @Override
            public double evalDouble(Document doc) throws EvaluationException {
                double value = args[0].evalDouble(doc);
                for (int i = 1; i < n; ++i) {
                    value = Math.min(value, args[i].evalDouble(doc));
                }
                return value;
            }
        };
    }

    private NumericExpression makeMaxFunction(Tree tree) {
        final int n = tree.getChildCount();
        if (n < 2) {
            throw new IllegalArgumentException("max() requires at least 2 arguments");
        }
        final NumericExpression[] args = new NumericExpression[n];
        for (int i = 0; i < n; ++i) {
            args[i] = this.makeNumericExpression(tree.getChild(i));
        }
        return new NumericExpression(this){

            @Override
            public double evalDouble(Document doc) throws EvaluationException {
                double value = args[0].evalDouble(doc);
                for (int i = 1; i < n; ++i) {
                    value = Math.max(value, args[i].evalDouble(doc));
                }
                return value;
            }
        };
    }

    private NumericExpression makeDistanceFunction(Tree tree) {
        Expression arg1;
        Expression arg0;
        if (tree.getChildCount() != 2) {
            throw new IllegalArgumentException("distance() requires exactly 2 arguments");
        }
        try {
            arg0 = this.makeGeoExpression(tree.getChild(0));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("distance argument 1 must be geo", e);
        }
        try {
            arg1 = this.makeGeoExpression(tree.getChild(1));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("distance argument 2 must be geo", e);
        }
        return new NumericExpression(this){

            @Override
            public double evalDouble(Document doc) throws EvaluationException {
                DocumentPb.FieldValue value0 = arg0.eval(doc);
                DocumentPb.FieldValue value1 = arg1.eval(doc);
                S2LatLng p0 = S2LatLng.fromDegrees(value0.getGeo().getLat(), value0.getGeo().getLng());
                S2LatLng p1 = S2LatLng.fromDegrees(value1.getGeo().getLat(), value1.getGeo().getLng());
                return p0.getDistance(p1).radians() * 6371010.0;
            }
        };
    }

    private Expression makeSnippetFunction(Tree tree) {
        int nchildren = tree.getChildCount();
        if (nchildren < 2) {
            throw new IllegalArgumentException("Missing required arguments: query and fieldName");
        }
        String query = this.getText(tree.getChild(0));
        Tree field = tree.getChild(1);
        if (field.getType() != 26) {
            throw new IllegalArgumentException("Field name expected");
        }
        String fieldName = field.getText();
        Set<DocumentPb.FieldValue.ContentType> types = this.fieldTypes.get(fieldName);
        if (types == null) {
            String string = String.valueOf(fieldName);
            throw new IllegalArgumentException(string.length() != 0 ? "Unknown field: ".concat(string) : new String("Unknown field: "));
        }
        NumericExpression maxCharsExpression = nchildren < 3 ? new IntValueExpression(160.0) : this.makeNumericExpression(tree.getChild(2));
        NumericExpression maxSnippetsExpression = nchildren < 4 ? new IntValueExpression(3.0) : this.makeNumericExpression(tree.getChild(3));
        return SnippetExpression.makeSnippetExpression(query, fieldName, types, maxCharsExpression, maxSnippetsExpression);
    }

    static String getTokenName(int tokenType) {
        return new ExpressionParser(null).getTokenNames()[tokenType];
    }

    private BinaryNumericExpression makeNumericBinaryExpression(Tree tree) {
        BinaryNumericExpression op = BinaryNumericExpression.make(tree.getType());
        op.init(this.makeNumericExpression(tree.getChild(0)), this.makeNumericExpression(tree.getChild(1)));
        return op;
    }

    private NumericExpression makeNumericExpression(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 38: {
                return this.makeCountFieldsFunction(tree);
            }
            case 37: {
                return this.makeAbsoluteValueFunction(tree);
            }
            case 39: {
                return this.makeDistanceFunction(tree);
            }
            case 40: {
                return this.makeLogFunction(tree);
            }
            case 41: {
                return this.makeMaxFunction(tree);
            }
            case 42: {
                return this.makeMinFunction(tree);
            }
            case 45: {
                String string = tree.getText();
                throw new IllegalArgumentException(new StringBuilder(29 + String.valueOf(string).length()).append("Function ").append(string).append(" not yet implemented").toString());
            }
            case 33: 
            case 44: {
                String string = tree.getText();
                throw new IllegalArgumentException(new StringBuilder(39 + String.valueOf(string).length()).append("Function ").append(string).append(" does not return numeric value").toString());
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 43: {
                return this.makeNumericBinaryExpression(tree);
            }
            case 24: 
            case 34: {
                return this.makeNumericValueExpression(tree);
            }
            case 4: {
                return new NegExpression(this.makeNumericExpression(tree.getChild(0)));
            }
            case 26: {
                if ("_score".equals(tree.getText())) {
                    return new ScoreExpression();
                }
                FieldExpression e = FieldExpression.makeFieldExpression(tree.getText(), this.fieldTypes.get(tree.getText()));
                e.checkType(DocumentPb.FieldValue.ContentType.NUMBER);
                return e;
            }
        }
        String string = String.valueOf(ExpressionBuilder.getTokenName(tree.getType()));
        throw new IllegalArgumentException(string.length() != 0 ? "Not yet implemented or unexpected: ".concat(string) : new String("Not yet implemented or unexpected: "));
    }

    private IntValueExpression makeNumericValueExpression(Tree tree) {
        String value = tree.getText();
        try {
            return new IntValueExpression(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "Wrong number format: ".concat(string) : new String("Wrong number format: "));
        }
    }

    private Expression makeGeopointFunction(Tree tree) {
        if (tree.getChildCount() != 2) {
            throw new IllegalArgumentException("geopoint() requires exactly 2 arguments");
        }
        final NumericExpression lat = this.makeNumericExpression(tree.getChild(0));
        final NumericExpression lng = this.makeNumericExpression(tree.getChild(1));
        return new Expression(this){

            @Override
            public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
                DocumentPb.FieldValue.Builder b = DocumentPb.FieldValue.newBuilder().setType(DocumentPb.FieldValue.ContentType.GEO);
                b.getGeoBuilder().setLat(lat.evalDouble(doc));
                b.getGeoBuilder().setLng(lng.evalDouble(doc));
                return b.build();
            }

            @Override
            public List<Expression.Sorter> getSorters(int sign, double defaultValueNumeric, String defaultValueText) {
                throw new SearchException("geopoint() is not supported in sort expressions");
            }
        };
    }

    private Expression makeGeoFieldExpression(Tree tree) {
        String fieldName = tree.getText();
        final String luceneFieldName = LuceneUtils.makeLuceneFieldName(fieldName, DocumentPb.FieldValue.ContentType.GEO);
        return new Expression(this){

            @Override
            public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
                Field[] fields = doc.getFields(luceneFieldName);
                if (fields.length == 0) {
                    throw new EvaluationException("geo field was not found");
                }
                double[] value = (double[])LuceneUtils.luceneFieldToValue(fields[0], DocumentPb.FieldValue.ContentType.GEO);
                DocumentPb.FieldValue.Builder b = DocumentPb.FieldValue.newBuilder().setType(DocumentPb.FieldValue.ContentType.GEO);
                b.getGeoBuilder().setLat(value[0]);
                b.getGeoBuilder().setLng(value[1]);
                return b.build();
            }

            @Override
            public List<Expression.Sorter> getSorters(int sign, double defaultValueNumeric, String defaultValueText) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Expression makeGeoExpression(Tree tree) {
        switch (tree.getType()) {
            case 33: {
                return this.makeGeopointFunction(tree);
            }
            case 26: {
                return this.makeGeoFieldExpression(tree);
            }
        }
        throw new IllegalArgumentException();
    }

    private Expression makeExpression(Tree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Unexpected null node encountered");
        }
        switch (tree.getType()) {
            case 38: {
                return this.makeCountFieldsFunction(tree);
            }
            case 44: {
                return this.makeSnippetFunction(tree);
            }
            case 37: {
                return this.makeAbsoluteValueFunction(tree);
            }
            case 40: {
                return this.makeLogFunction(tree);
            }
            case 39: {
                return this.makeDistanceFunction(tree);
            }
            case 33: {
                return this.makeGeopointFunction(tree);
            }
            case 41: {
                return this.makeMaxFunction(tree);
            }
            case 42: {
                return this.makeMinFunction(tree);
            }
            case 45: {
                log.logp(Level.WARNING, "com.google.appengine.api.search.dev.ExpressionBuilder", "makeExpression", String.format("Function %s not implemented. Using dummy expression.", tree.getText()));
                return new EmptyExpression();
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 43: {
                return this.makeNumericBinaryExpression(tree);
            }
            case 24: 
            case 34: {
                return this.makeNumericValueExpression(tree);
            }
            case 4: {
                return new NegExpression(this.makeNumericExpression(tree.getChild(0)));
            }
            case 26: {
                switch (tree.getText()) {
                    case "_score": {
                        return new ScoreExpression();
                    }
                    case "_rank": {
                        return new RankExpression();
                    }
                }
                return FieldExpression.makeFieldExpression(tree.getText(), this.fieldTypes.get(tree.getText()));
            }
        }
        String string = String.valueOf(ExpressionBuilder.getTokenName(tree.getType()));
        throw new IllegalArgumentException(string.length() != 0 ? "Not yet implemented: ".concat(string) : new String("Not yet implemented: "));
    }

    private static class NegExpression
    extends NumericExpression {
        private final NumericExpression input;

        NegExpression(NumericExpression input) {
            this.input = input;
        }

        @Override
        public double evalDouble(Document doc) throws EvaluationException {
            return -this.input.evalDouble(doc);
        }
    }

    public static class IntValueExpression
    extends NumericExpression {
        private final Double value;

        IntValueExpression(double value) {
            this.value = value;
        }

        @Override
        public double evalDouble(Document doc) {
            return this.value;
        }
    }

    private static class CountFieldsFunction
    extends NumericExpression {
        private final List<String> luceneFieldNames;
        private final String fieldName;

        CountFieldsFunction(List<String> luceneFieldNames, String fieldName) {
            this.luceneFieldNames = luceneFieldNames;
            this.fieldName = fieldName;
        }

        @Override
        public double evalDouble(Document doc) {
            int result = 0;
            for (String fieldName : this.luceneFieldNames) {
                result += doc.getFields(fieldName).length;
            }
            return result;
        }

        @Override
        public List<Expression.Sorter> getSorters(int sign, double defaultValueNumeric, String defaultValueText) {
            String string = this.fieldName;
            throw new SearchException(new StringBuilder(87 + String.valueOf(string).length()).append("Failed to parse sort expression 'count(").append(string).append(")': count() is not supported in sort expressions").toString());
        }
    }

    public static class EmptyExpression
    extends Expression {
        @Override
        public DocumentPb.FieldValue eval(Document doc) throws EvaluationException {
            throw new EvaluationException("empty expression");
        }

        @Override
        public List<Expression.Sorter> getSorters(int sign, double dfltD, String dfltT) {
            return new ArrayList<Expression.Sorter>();
        }
    }
}

