/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.DatastorePb;
import com.google.cloud.datastore.core.appengv3.AppEngV3DatabaseRefExtractor;
import com.google.cloud.datastore.core.exception.InvalidConversionException;
import com.google.cloud.datastore.core.internal.Transactions;
import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.internal.Transaction;

public class LocalTransactionConverter {
    public ByteString toTransactionBytes(DatastorePb.Transaction transactionV3) {
        return this.toTransactionBytes(transactionV3.getHandle());
    }

    public ByteString toTransactionBytes(long transactionHandle) {
        return this.toTransactionProto(transactionHandle).toByteString();
    }

    public DatastorePb.Transaction toV3Transaction(ByteString transactionBytesV1, String appId, String databaseId) throws InvalidConversionException {
        DatastorePb.Transaction transactionV3 = new DatastorePb.Transaction();
        transactionV3.setHandle(Transactions.getTransactionHandle(transactionBytesV1));
        AppEngV3DatabaseRefExtractor.set(transactionV3, DatabaseRef.createForApp(appId, databaseId));
        return transactionV3;
    }

    public Transaction toTransactionProto(long transactionHandle) {
        return Transaction.newBuilder().setHandle(transactionHandle).build();
    }
}

