/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.appengv3;

import com.google.storage.onestore.v3.OnestoreEntity;

public class PropertyTypeExtractor {
    public static String extractPropertyType(OnestoreEntity.Property property) {
        if (property.getValue().hasBooleanValue()) {
            return "Boolean";
        }
        if (property.getValue().hasInt64Value()) {
            OnestoreEntity.Property.Meaning meaning = property.getMeaningEnum();
            if (meaning == OnestoreEntity.Property.Meaning.GD_RATING) {
                return "Rating";
            }
            if (meaning == OnestoreEntity.Property.Meaning.GD_WHEN) {
                return "Date/Time";
            }
            return "Integer";
        }
        if (property.getValue().hasStringValue()) {
            OnestoreEntity.Property.Meaning meaning = property.getMeaningEnum();
            if (meaning == OnestoreEntity.Property.Meaning.ATOM_CATEGORY) {
                return "Category";
            }
            if (meaning == OnestoreEntity.Property.Meaning.ATOM_LINK) {
                return "Link";
            }
            if (meaning == OnestoreEntity.Property.Meaning.BLOB) {
                return "Blob";
            }
            if (meaning == OnestoreEntity.Property.Meaning.BLOBKEY) {
                return "BlobKey";
            }
            if (meaning == OnestoreEntity.Property.Meaning.GD_EMAIL) {
                return "Email";
            }
            if (meaning == OnestoreEntity.Property.Meaning.GD_IM) {
                return "IM";
            }
            if (meaning == OnestoreEntity.Property.Meaning.GD_PHONENUMBER) {
                return "PhoneNumber";
            }
            if (meaning == OnestoreEntity.Property.Meaning.GD_POSTALADDRESS) {
                return "PostalAddress";
            }
            if (meaning == OnestoreEntity.Property.Meaning.TEXT) {
                return "Text";
            }
            if (meaning == OnestoreEntity.Property.Meaning.ENTITY_PROTO) {
                return "EmbeddedEntity";
            }
            return "String";
        }
        if (property.getValue().hasDoubleValue()) {
            return "Float";
        }
        if (property.getValue().hasPointValue()) {
            return "GeoPt";
        }
        if (property.getValue().hasReferenceValue()) {
            return "Key";
        }
        if (property.getValue().hasUserValue()) {
            return "User";
        }
        return "NULL";
    }
}

