/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.cloud.datastore.core.rep.DatabaseRef;
import com.google.cloud.datastore.core.rep.ListRequest;

final class AutoValue_ListRequest
extends ListRequest {
    private final DatabaseRef databaseRef;
    private final String filter;
    private final int pageSize;
    private final String pageToken;

    private AutoValue_ListRequest(DatabaseRef databaseRef, String filter, int pageSize, String pageToken) {
        this.databaseRef = databaseRef;
        this.filter = filter;
        this.pageSize = pageSize;
        this.pageToken = pageToken;
    }

    @Override
    public DatabaseRef databaseRef() {
        return this.databaseRef;
    }

    @Override
    public String filter() {
        return this.filter;
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public String pageToken() {
        return this.pageToken;
    }

    public String toString() {
        String string = String.valueOf(this.databaseRef);
        String string2 = this.filter;
        int n = this.pageSize;
        String string3 = this.pageToken;
        return new StringBuilder(68 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ListRequest{databaseRef=").append(string).append(", filter=").append(string2).append(", pageSize=").append(n).append(", pageToken=").append(string3).append("}").toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ListRequest) {
            ListRequest that = (ListRequest)o;
            return this.databaseRef.equals(that.databaseRef()) && this.filter.equals(that.filter()) && this.pageSize == that.pageSize() && this.pageToken.equals(that.pageToken());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.databaseRef.hashCode();
        h$ *= 1000003;
        h$ ^= this.filter.hashCode();
        h$ *= 1000003;
        h$ ^= this.pageSize;
        h$ *= 1000003;
        return h$ ^= this.pageToken.hashCode();
    }

    static final class Builder
    extends ListRequest.Builder {
        private DatabaseRef databaseRef;
        private String filter;
        private Integer pageSize;
        private String pageToken;

        Builder() {
        }

        @Override
        public ListRequest.Builder databaseRef(DatabaseRef databaseRef) {
            if (databaseRef == null) {
                throw new NullPointerException("Null databaseRef");
            }
            this.databaseRef = databaseRef;
            return this;
        }

        @Override
        public ListRequest.Builder filter(String filter) {
            if (filter == null) {
                throw new NullPointerException("Null filter");
            }
            this.filter = filter;
            return this;
        }

        @Override
        public ListRequest.Builder pageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public ListRequest.Builder pageToken(String pageToken) {
            if (pageToken == null) {
                throw new NullPointerException("Null pageToken");
            }
            this.pageToken = pageToken;
            return this;
        }

        @Override
        ListRequest autoBuild() {
            String missing = "";
            if (this.databaseRef == null) {
                missing = String.valueOf(missing).concat(" databaseRef");
            }
            if (this.filter == null) {
                missing = String.valueOf(missing).concat(" filter");
            }
            if (this.pageSize == null) {
                missing = String.valueOf(missing).concat(" pageSize");
            }
            if (this.pageToken == null) {
                missing = String.valueOf(missing).concat(" pageToken");
            }
            if (!missing.isEmpty()) {
                String string = String.valueOf(missing);
                throw new IllegalStateException(string.length() != 0 ? "Missing required properties:".concat(string) : new String("Missing required properties:"));
            }
            return new AutoValue_ListRequest(this.databaseRef, this.filter, this.pageSize, this.pageToken);
        }
    }
}

