/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.auto.value.AutoValue;
import com.google.cloud.datastore.core.rep.AutoValue_IndexValueRange;
import com.google.cloud.datastore.core.rep.IndexValue;
import com.google.cloud.datastore.core.rep.IndexValueOrder;
import javax.annotation.Nullable;

@AutoValue
public abstract class IndexValueRange {
    public abstract IndexValueOrder order();

    @Nullable
    public abstract IndexValue start();

    public abstract boolean startInclusive();

    @Nullable
    public abstract IndexValue end();

    public abstract boolean endInclusive();

    public static IndexValueRange all(IndexValueOrder order) {
        Preconditions.checkNotNull((Object)order);
        return IndexValueRange.create(order, order.minValue(), true, null, true);
    }

    public static IndexValueRange empty(IndexValueOrder order) {
        return IndexValueRange.create(order, null, false, null, false);
    }

    public static IndexValueRange singleton(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)indexValue);
        return IndexValueRange.create(order, indexValue, true, indexValue, true);
    }

    public static IndexValueRange lessThan(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        return IndexValueRange.create(order, order.minValueOfCategory(indexValue), true, indexValue, false);
    }

    public static IndexValueRange lessThanOrEqual(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        return IndexValueRange.create(order, order.minValueOfCategory(indexValue), true, indexValue, true);
    }

    public static IndexValueRange greaterThan(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue end = order.minValueOfNextCategory(indexValue);
        return IndexValueRange.create(order, indexValue, false, end, end == null);
    }

    public static IndexValueRange greaterThanOrEqual(IndexValueOrder order, IndexValue indexValue) {
        Preconditions.checkNotNull((Object)order);
        Preconditions.checkNotNull((Object)indexValue);
        IndexValue end = order.minValueOfNextCategory(indexValue);
        return IndexValueRange.create(order, indexValue, true, end, end == null);
    }

    @VisibleForTesting
    static IndexValueRange create(IndexValueOrder order, IndexValue start, boolean startInclusive, IndexValue end, boolean endInclusive) {
        return new AutoValue_IndexValueRange(order, start, startInclusive, end, endInclusive);
    }

    public boolean isAll() {
        return this.order().compare(this.start(), this.order().minValue()) == 0 && this.startInclusive() && this.end() == null && this.endInclusive();
    }

    public boolean isEmpty() {
        int cmp = this.order().compare(this.start(), this.end());
        return cmp > 0 || cmp == 0 && (!this.startInclusive() || !this.endInclusive());
    }

    public boolean isSingleton() {
        return this.order().compare(this.start(), this.end()) == 0 && this.startInclusive() && this.endInclusive();
    }

    public boolean contains(IndexValue indexValue) {
        int cmp = this.order().compare(this.start(), (IndexValue)Preconditions.checkNotNull((Object)indexValue));
        if (cmp > 0) {
            return false;
        }
        if (cmp == 0 && !this.startInclusive()) {
            return false;
        }
        cmp = this.order().compare(this.end(), indexValue);
        if (cmp < 0) {
            return false;
        }
        return cmp > 0 || this.endInclusive();
    }

    public IndexValueRange intersect(IndexValueRange other) {
        boolean newEndInclusive;
        IndexValue newEndValue;
        boolean newStartInclusive;
        IndexValue newStartValue;
        Preconditions.checkArgument((other.order() == this.order() ? 1 : 0) != 0);
        int cmp = this.order().compare(other.start(), this.start());
        if (cmp < 0) {
            newStartValue = this.start();
            newStartInclusive = this.startInclusive();
        } else if (cmp > 0) {
            newStartValue = other.start();
            newStartInclusive = other.startInclusive();
        } else {
            newStartValue = this.start();
            newStartInclusive = this.startInclusive() && other.startInclusive();
        }
        cmp = this.order().compare(other.end(), this.end());
        if (cmp > 0) {
            newEndValue = this.end();
            newEndInclusive = this.endInclusive();
        } else if (cmp < 0) {
            newEndValue = other.end();
            newEndInclusive = other.endInclusive();
        } else {
            newEndValue = this.end();
            newEndInclusive = this.endInclusive() && other.endInclusive();
        }
        return IndexValueRange.create(this.order(), newStartValue, newStartInclusive, newEndValue, newEndInclusive);
    }
}

