/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.datastore.core.rep;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.cloud.datastore.core.rep.AutoValue_SingleFieldIndexingConfiguration;
import com.google.cloud.datastore.core.rep.SingleFieldIndex;
import com.google.cloud.datastore.core.rep.SingleFieldIndexingRule;
import com.google.cloud.datastore.core.rep.SingleFieldRef;
import com.google.cloud.datastore.core.rep.WorkflowState;
import javax.annotation.Nullable;

@AutoValue
public abstract class SingleFieldIndexingConfiguration {
    public static final SingleFieldIndexingConfiguration EMPTY = SingleFieldIndexingConfiguration.create((Iterable<SingleFieldIndexingRule>)ImmutableList.of((Object)SingleFieldIndexingRule.EMPTY_DATABASE_RULE));

    public abstract ImmutableMap<SingleFieldRef, SingleFieldIndexingRule> rules();

    @Memoized
    public SingleFieldIndexingRule databaseDefaults() {
        return (SingleFieldIndexingRule)this.rules().get((Object)SingleFieldRef.database());
    }

    @Memoized
    public ImmutableMultimap<String, SingleFieldIndexingRule> kindRules() {
        ImmutableMultimap.Builder kinds = ImmutableMultimap.builder();
        for (SingleFieldIndexingRule rule : this.rules().values()) {
            if (rule.ref().kind() == null) continue;
            kinds.put((Object)rule.ref().kind(), (Object)rule);
        }
        return kinds.build();
    }

    public SingleFieldIndexingRule generatingRule(SingleFieldRef ref) {
        SingleFieldIndexingRule rule = null;
        while (rule == null || rule.state() == WorkflowState.DELETED) {
            rule = (SingleFieldIndexingRule)this.rules().get((Object)ref);
            ref = ref.parent();
        }
        return rule;
    }

    @Nullable
    @Memoized
    public Long lastUpdated() {
        Preconditions.checkState((!this.rules().isEmpty() ? 1 : 0) != 0);
        long maxUpdateTime = 0L;
        for (SingleFieldIndexingRule rule : this.rules().values()) {
            if (rule.lastUpdated() == null) {
                return null;
            }
            maxUpdateTime = Math.max(maxUpdateTime, rule.lastUpdated());
        }
        return maxUpdateTime;
    }

    public static SingleFieldIndexingConfiguration createWithDatabaseRule(ImmutableMap<SingleFieldIndex.Mode, WorkflowState> indexes, @Nullable Long updateTimeMicros) {
        return SingleFieldIndexingConfiguration.create((Iterable<SingleFieldIndexingRule>)ImmutableList.of((Object)SingleFieldIndexingRule.createDatabaseRule(indexes, updateTimeMicros)));
    }

    public static SingleFieldIndexingConfiguration create(Iterable<SingleFieldIndexingRule> rules) {
        ImmutableMap.Builder ruleMapBuilder = ImmutableMap.builder();
        for (SingleFieldIndexingRule rule : rules) {
            ruleMapBuilder.put((Object)rule.ref(), (Object)rule);
        }
        ImmutableMap ruleMap = ruleMapBuilder.build();
        Preconditions.checkArgument((boolean)ruleMap.containsKey((Object)SingleFieldRef.database()));
        return new AutoValue_SingleFieldIndexingConfiguration((ImmutableMap<SingleFieldRef, SingleFieldIndexingRule>)ruleMap);
    }
}

