/*
 * Decompiled with CFR 0.152.
 */
package mediautil.image.jpeg;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import mediautil.gen.FileFormatException;
import mediautil.gen.Log;
import mediautil.gen.Rational;
import mediautil.image.jpeg.AbstractImageInfo;
import mediautil.image.jpeg.Entry;
import mediautil.image.jpeg.IFD;
import mediautil.image.jpeg.LLJTran;
import mediautil.image.jpeg.Naming;

public class Exif
extends AbstractImageInfo<LLJTran> {
    public static final String FORMAT = "Exif";
    public static final byte[] EXIF_MARK = new byte[]{69, 120, 105, 102, 0, 0};
    static final int FIRST_IFD_OFF = 6;
    static final int MIN_JPEG_SIZE = 100;
    public static final int NEWSUBFILETYPE = 254;
    public static final int IMAGEWIDTH = 256;
    public static final int IMAGELENGTH = 257;
    public static final int BITSPERSAMPLE = 258;
    public static final int COMPRESSION = 259;
    public static final int PHOTOMETRICINTERPRETATION = 262;
    public static final int FILLORDER = 266;
    public static final int DOCUMENTNAME = 269;
    public static final int IMAGEDESCRIPTION = 270;
    public static final int MAKE = 271;
    public static final int MODEL = 272;
    public static final int STRIPOFFSETS = 273;
    public static final int ORIENTATION = 274;
    public static final int SAMPLESPERPIXEL = 277;
    public static final int ROWSPERSTRIP = 278;
    public static final int STRIPBYTECOUNTS = 279;
    public static final int XRESOLUTION = 282;
    public static final int YRESOLUTION = 283;
    public static final int PLANARCONFIGURATION = 284;
    public static final int RESOLUTIONUNIT = 296;
    public static final int TRANSFERFUNCTION = 301;
    public static final int SOFTWARE = 305;
    public static final int DATETIME = 306;
    public static final int ARTIST = 315;
    public static final int WHITEPOINT = 318;
    public static final int PRIMARYCHROMATICITIES = 319;
    public static final int SUBIFDS = 330;
    public static final int JPEGTABLES = 347;
    public static final int TRANSFERRANGE = 342;
    public static final int JPEGPROC = 512;
    public static final int JPEGINTERCHANGEFORMAT = 513;
    public static final int JPEGINTERCHANGEFORMATLENGTH = 514;
    public static final int YCBCRCOEFFICIENTS = 529;
    public static final int YCBCRSUBSAMPLING = 530;
    public static final int YCBCRPOSITIONING = 531;
    public static final int REFERENCEBLACKWHITE = 532;
    public static final int CFAREPEATPATTERNDIM = 33421;
    public static final int CFAPATTERN = 33422;
    public static final int BATTERYLEVEL = 33423;
    public static final int COPYRIGHT = 33432;
    public static final int EXPOSURETIME = 33434;
    public static final int FNUMBER = 33437;
    public static final int IPTC_NAA = 33723;
    public static final int EXIFOFFSET = 34665;
    public static final int INTERCOLORPROFILE = 34675;
    public static final int EXPOSUREPROGRAM = 34850;
    public static final int SPECTRALSENSITIVITY = 34852;
    public static final int GPSINFO = 34853;
    public static final int ISOSPEEDRATINGS = 34855;
    public static final int OECF = 34856;
    public static final int EXIFVERSION = 36864;
    public static final int DATETIMEORIGINAL = 36867;
    public static final int DATETIMEDIGITIZED = 36868;
    public static final int COMPONENTSCONFIGURATION = 37121;
    public static final int COMPRESSEDBITSPERPIXEL = 37122;
    public static final int SHUTTERSPEEDVALUE = 37377;
    public static final int APERTUREVALUE = 37378;
    public static final int BRIGHTNESSVALUE = 37379;
    public static final int EXPOSUREBIASVALUE = 37380;
    public static final int MAXAPERTUREVALUE = 37381;
    public static final int SUBJECTDISTANCE = 37382;
    public static final int METERINGMODE = 37383;
    public static final int LIGHTSOURCE = 37384;
    public static final int FLASH = 37385;
    public static final int FOCALLENGTH = 37386;
    public static final int MAKERNOTE = 37500;
    public static final int USERCOMMENT = 37510;
    public static final int SUBSECTIME = 37520;
    public static final int SUBSECTIMEORIGINAL = 37521;
    public static final int SUBSECTIMEDIGITIZED = 37522;
    public static final int FLASHPIXVERSION = 40960;
    public static final int COLORSPACE = 40961;
    public static final int EXIFIMAGEWIDTH = 40962;
    public static final int EXIFIMAGELENGTH = 40963;
    public static final int INTEROPERABILITYOFFSET = 40965;
    public static final int FLASHENERGY = 41483;
    public static final int SPATIALFREQUENCYRESPONSE = 41484;
    public static final int FOCALPLANEXRESOLUTION = 41486;
    public static final int FOCALPLANEYRESOLUTION = 41487;
    public static final int FOCALPLANERESOLUTIONUNIT = 41488;
    public static final int SUBJECTLOCATION = 41492;
    public static final int EXPOSUREINDEX = 41493;
    public static final int SENSINGMETHOD = 41495;
    public static final int FILESOURCE = 41728;
    public static final int SCENETYPE = 41729;
    public static final int FOCALLENGTHIN35MMFILM = 41989;
    public static final int SHARPNESS = 41994;
    public static final int CUSTOMRENDERED = 41985;
    public static final int EXPOSUREMODE = 41986;
    public static final int WHITEBALANCE = 41987;
    public static final int DIGITALZOOMRATIO = 41988;
    public static final int SATURATION = 41993;
    public static final int SCENECAPTURETYPE = 41990;
    public static final int GAINCONTROL = 41991;
    public static final int CONTRAST = 41992;
    public static final int PRINTMODE = 50341;
    public static final int GPSVersionID = 0;
    public static final int GPSLatitudeRef = 1;
    public static final int GPSLatitude = 2;
    public static final int GPSLongitudeRef = 3;
    public static final int GPSLongitude = 4;
    public static final int GPSAltitudeRef = 5;
    public static final int GPSAltitude = 6;
    public static final int GPSTimeStamp = 7;
    public static final int GPSSatellites = 8;
    public static final int GPSStatus = 9;
    public static final int GPSMeasureMode = 10;
    public static final int GPSDOP = 11;
    public static final int GPSSpeedRef = 12;
    public static final int GPSSpeed = 13;
    public static final int GPSTrackRef = 14;
    public static final int GPSTrack = 15;
    public static final int GPSImgDirectionRef = 16;
    public static final int GPSImgDirection = 17;
    public static final int GPSMapDatum = 18;
    public static final int GPSDestLatitudeRef = 19;
    public static final int GPSDestLatitude = 20;
    public static final int GPSDestLongitudeRef = 21;
    public static final int GPSDestLongitude = 22;
    public static final int GPSDestBearingRef = 23;
    public static final int GPSDestBearing = 24;
    public static final int GPSDestDistanceRef = 25;
    public static final int GPSDestDistance = 26;
    public static final int GPSProcessingMethod = 27;
    public static final int GPSAreaInformation = 28;
    public static final int GPSDateStamp = 29;
    public static final int GPSDifferential = 30;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int ORIENTATION_TOPLEFT = 1;
    public static final int ORIENTATION_TOPRIGHT = 2;
    public static final int ORIENTATION_BOTRIGHT = 3;
    public static final int ORIENTATION_BOTLEFT = 4;
    public static final int ORIENTATION_LEFTTOP = 5;
    public static final int ORIENTATION_RIGHTTOP = 6;
    public static final int ORIENTATION_RIGHTBOT = 7;
    public static final int ORIENTATION_LEFTBOT = 8;
    public static final String[] EXPOSURE_PROGRAMS = new String[]{"P0", "P1", "Normal", "P3", "P5"};
    public static final String[] METERING_MODES = new String[]{"P0", "P1", "Normal", "P3", "PATTERN"};
    static final int DIR_ENTRY_SIZE = 12;
    public static final int[] TYPELENGTH = new int[]{1, 1, 2, 4, 8, 1, 1, 2, 4, 8};
    private static final int[] posForOrientationTags = new int[]{-1, 27, 78, 177, 228, 57, 108, 147, 198};
    public static final int[] opToCorrectOrientation = new int[]{-1, 0, 1, 6, 2, 3, 5, 4, 7};
    protected int currentimage;
    protected int version;
    protected IFD[] ifds;

    public Exif(InputStream is, byte[] data, int offset, String name, String comments, LLJTran format) throws FileFormatException {
        super(is, data, offset, name, comments, format);
    }

    public Exif() {
        this.ifds = new IFD[2];
        this.intel = true;
        this.version = 2;
    }

    @Override
    public String getFormat() {
        return FORMAT;
    }

    public static byte[] getMarkerData() {
        return new byte[]{-1, -31, 0, 40, 69, 120, 105, 102, 0, 0, 73, 73, 42, 0, 8, 0, 0, 0, 1, 0, 15, 1, 2, 0, 5, 0, 0, 0, 26, 0, 0, 0, 0, 0, 0, 0, 70, 65, 75, 69, 0, 0};
    }

    public Entry getTagValue(int tag, boolean main) {
        return this.getTagValue(new Integer(tag), -1, main);
    }

    public Entry getTagValue(Integer tag, int subTag, boolean main) {
        return this.ifds[main ? 0 : 1] != null ? this.ifds[main ? 0 : 1].getEntry(tag, subTag) : null;
    }

    public void setTagValue(int tag, int subTag, Entry value, boolean main) {
        if (this.ifds[main ? 0 : 1] != null) {
            this.ifds[main ? 0 : 1].setEntry(new Integer(tag), subTag, value);
        }
    }

    @Override
    public int getThumbnailLength() {
        int retVal = 0;
        Entry e = this.getTagValue(514, false);
        if (e == null) {
            e = this.getTagValue(279, false);
        }
        if (e != null) {
            retVal = (Integer)e.getValue(0);
        }
        return retVal;
    }

    @Override
    public int getThumbnailOffset() {
        int retVal = 0;
        Entry e = this.getTagValue(513, false);
        if (e == null) {
            e = this.getTagValue(273, false);
        }
        if (e != null) {
            retVal = (Integer)e.getValue(0) + 6;
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveThumbnailImage(OutputStream os) throws IOException {
        int min_len;
        if (os == null || this.format == null) {
            return false;
        }
        boolean success = false;
        String ext = this.getThumbnailExtension();
        int offset = this.getThumbnailOffset();
        int length = this.getThumbnailLength();
        int n = min_len = "jpeg".equals(ext) ? 100 : 0;
        if (offset > 0 && length > min_len) {
            try (InputStream is = null;){
                if ("jpeg".equals(ext)) {
                    int jpeg_offset;
                    is = new FileInputStream(this.getImageFile());
                    byte[] image = new byte[length];
                    Exif.skip(is, this.offset + offset);
                    Exif.read(is, image);
                    for (jpeg_offset = 0; (image[jpeg_offset] != -1 || image[jpeg_offset + 1] != -40) && jpeg_offset < image.length - 1; ++jpeg_offset) {
                    }
                    if (image.length - jpeg_offset > 100) {
                        os.write(image, jpeg_offset, image.length - jpeg_offset);
                        success = true;
                    }
                } else if ("bmp".equals(ext)) {
                    is = new FileInputStream(this.getImageFile());
                    Exif.skip(is, this.offset + offset);
                    Entry e = this.getTagValue(279, false);
                    if (e != null) {
                        length = (Integer)e.getValue(0);
                        int imgwidth = 0;
                        int imglength = 0;
                        e = this.getTagValue(256, false);
                        if (e != null) {
                            imgwidth = (Integer)e.getValue(0);
                        }
                        if ((e = this.getTagValue(257, false)) != null) {
                            imglength = (Integer)e.getValue(0);
                        }
                        int bitspix = 8;
                        e = this.getTagValue(258, false);
                        if (e != null) {
                            bitspix = (Integer)e.getValue(0);
                        }
                        int simpleperpix = 3;
                        e = this.getTagValue(277, false);
                        if (e != null) {
                            simpleperpix = (Integer)e.getValue(0);
                        }
                        this.data = new byte[54];
                        System.arraycopy(BMP_SIG, 0, this.data, 0, BMP_SIG.length);
                        offset = 2;
                        int scanline_len = imgwidth * simpleperpix + 3 & 0xFFFFFFFC;
                        offset = this.i2bsI(offset, 54 + scanline_len * imglength, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, 54, 4);
                        offset = this.i2bsI(offset, 40, 4);
                        offset = this.i2bsI(offset, imgwidth, 4);
                        offset = this.i2bsI(offset, imglength, 4);
                        offset = this.i2bsI(offset, 1, 2);
                        offset = this.i2bsI(offset, simpleperpix * bitspix, 2);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, scanline_len * imglength, 4);
                        offset = this.i2bsI(offset, 2834, 4);
                        offset = this.i2bsI(offset, 2834, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        offset = this.i2bsI(offset, 0, 4);
                        os.write(this.data);
                        this.data = new byte[length];
                        Exif.read(is, this.data);
                        int filler = scanline_len - imgwidth * simpleperpix;
                        scanline_len = imgwidth * simpleperpix;
                        byte[] filldata = null;
                        if (filler != 0) {
                            filldata = new byte[filler];
                        }
                        for (offset = length - scanline_len; offset >= 0; offset -= scanline_len) {
                            for (int ro = 0; ro < scanline_len; ro += 3) {
                                os.write(this.data[offset + ro + 2]);
                                os.write(this.data[offset + ro + 1]);
                                os.write(this.data[offset + ro]);
                            }
                            if (filler == 0) continue;
                            os.write(filldata);
                        }
                    }
                    success = true;
                }
            }
        }
        if (!success) {
            return super.saveThumbnailImage(os);
        }
        return true;
    }

    @Override
    public String getThumbnailExtension() {
        return this.getTagValue(513, false) != null ? "jpeg" : (this.getTagValue(273, false) != null ? "bmp" : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Icon getThumbnailIcon(Dimension size) {
        block35: {
            block34: {
                int min_len;
                String ext = this.getThumbnailExtension();
                int offset = this.getThumbnailOffset();
                int length = this.getThumbnailLength();
                int n = min_len = "jpeg".equals(ext) ? 100 : 0;
                if (offset > 0 && length > min_len) {
                    InputStream is = null;
                    try {
                        if ("jpeg".equals(ext)) {
                            int jpeg_offset;
                            try {
                                is = new FileInputStream(this.getImageFile());
                                byte[] image = new byte[length];
                                Exif.skip(is, this.offset + offset);
                                is.read(image);
                                for (jpeg_offset = 0; (image[jpeg_offset] != -1 || image[jpeg_offset + 1] != -40) && jpeg_offset < image.length - 1; ++jpeg_offset) {
                                }
                                if (jpeg_offset < image.length - 100) {
                                    ImageIcon imageIcon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(image, jpeg_offset, image.length - jpeg_offset));
                                    return imageIcon;
                                }
                                break block34;
                            }
                            catch (IOException image) {
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                if (Log.debugLevel >= 1) {
                                    int n2 = jpeg_offset;
                                    String string = this.getName();
                                    System.err.println(new StringBuilder(26 + String.valueOf(string).length()).append("Bad index ").append(n2).append(" for ").append(string).toString());
                                }
                                break block34;
                            }
                        }
                        if (!"bmp".equals(ext)) break block34;
                        try {
                            is = new FileInputStream(this.getImageFile());
                            Exif.skip(is, this.offset + offset);
                            Entry e = this.getTagValue(279, false);
                            if (e != null) {
                                length = (Integer)e.getValue(0);
                                this.data = new byte[length];
                                Exif.read(is, this.data);
                                int imgwidth = 0;
                                int imglength = 0;
                                e = this.getTagValue(256, false);
                                if (e != null) {
                                    imgwidth = (Integer)e.getValue(0);
                                }
                                if ((e = this.getTagValue(257, false)) != null) {
                                    imglength = (Integer)e.getValue(0);
                                }
                                int bitspix = 8;
                                e = this.getTagValue(258, false);
                                if (e != null) {
                                    bitspix = (Integer)e.getValue(0);
                                }
                                int simpleperpix = 3;
                                e = this.getTagValue(277, false);
                                if (e != null) {
                                    simpleperpix = (Integer)e.getValue(0);
                                }
                                int[] image = new int[imgwidth * imglength];
                                int i = 0;
                                while (true) {
                                    if (i >= image.length) {
                                        MemoryImageSource mis = new MemoryImageSource(imgwidth, imglength, image, 0, imgwidth);
                                        Image img = Toolkit.getDefaultToolkit().createImage(mis);
                                        image = null;
                                        ImageIcon imageIcon = new ImageIcon(img);
                                        return imageIcon;
                                    }
                                    image[i] = ((this.data[i * 3] & 0xFF) << 16) + ((this.data[i * 3 + 1] & 0xFF) << 8) + (this.data[i * 3 + 2] & 0xFF) + -16777216;
                                    ++i;
                                }
                            }
                        }
                        catch (IOException x) {
                            if (Log.debugLevel >= 1) {
                                x.printStackTrace(System.err);
                            }
                        }
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.getAdvancedImage() != null) {
                try {
                    return this.getAdvancedImage().createThumbnailIcon(this.getImageFile().getPath(), null);
                }
                catch (Throwable e) {
                    if (Log.debugLevel < 1) break block35;
                    String string = String.valueOf(e);
                    System.err.println(new StringBuilder(9 + String.valueOf(string).length()).append("AdvImage:").append(string).toString());
                }
            }
        }
        if (Log.debugLevel < 3) return null;
        String string = String.valueOf(this.getImageFile());
        System.out.println(new StringBuilder(33 + String.valueOf(string).length()).append("Embedded thumbnail not found for ").append(string).toString());
        return null;
    }

    @Override
    public int getResolutionX() {
        Entry e = this.getTagValue(40962, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return -1;
    }

    public void setResolutionX(int xRes) {
        Entry e = this.getTagValue(40962, true);
        if (e == null) {
            e = new Entry(4);
            this.setTagValue(40962, 0, e, true);
        }
        e.setValue(0, new Integer(xRes));
    }

    @Override
    public int getResolutionY() {
        Entry e = this.getTagValue(40963, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return -1;
    }

    public void setResolutionY(int yRes) {
        Entry e = this.getTagValue(40963, true);
        if (e == null) {
            e = new Entry(4);
            this.setTagValue(40963, 0, e, true);
        }
        e.setValue(0, new Integer(yRes));
    }

    @Override
    public int getMetering() {
        Entry e = this.getTagValue(37383, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return 0;
    }

    public String getMeteringAsString() {
        int m = this.getMetering();
        if (m >= 0 && m < METERING_MODES.length) {
            return METERING_MODES[m];
        }
        return new StringBuilder(11).append(m).toString();
    }

    @Override
    public int getExpoProgram() {
        Entry e = this.getTagValue(34850, true);
        if (e != null) {
            return (Integer)e.getValue(0);
        }
        return 0;
    }

    public String getExpoProgramAsString() {
        int ep = this.getExpoProgram();
        if (ep >= 0 && ep < EXPOSURE_PROGRAMS.length) {
            return EXPOSURE_PROGRAMS[ep];
        }
        return new StringBuilder(11).append(ep).toString();
    }

    @Override
    public String getMake() {
        Entry e = this.getTagValue(271, true);
        if (e != null) {
            return e.toString();
        }
        return "n/a";
    }

    @Override
    public String getModel() {
        Entry e = this.getTagValue(272, true);
        if (e != null) {
            return e.toString();
        }
        return "n/a";
    }

    @Override
    public String getDataTimeOriginalString() {
        String result;
        Entry e = this.getTagValue(36867, true);
        if (e != null && (result = e.toString()).indexOf("0000:00:00") < 0) {
            return result;
        }
        return dateformat.format(new Date());
    }

    @Override
    public float getFNumber() {
        Entry e = this.getTagValue(33437, true);
        if (e != null) {
            return ((Rational)e.getValue(0)).floatValue();
        }
        e = this.getTagValue(37378, true);
        if (e != null) {
            return this.apertureToFnumber(((Rational)e.getValue(0)).floatValue());
        }
        return -1.0f;
    }

    @Override
    public Rational getShutter() {
        Entry e = this.getTagValue(33434, true);
        if (e != null) {
            return (Rational)e.getValue(0);
        }
        e = this.getTagValue(37377, true);
        try {
            return TV_TO_SEC[(int)((Rational)e.getValue(0)).floatValue()];
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    @Override
    public boolean isFlash() {
        Entry e = this.getTagValue(37385, true);
        if (e != null) {
            return ((Integer)e.getValue(0) & 1) == 1;
        }
        return false;
    }

    @Override
    public float getFocalLength() {
        Entry e = this.getTagValue(37386, true);
        if (e != null) {
            return Math.round((float)((double)(38.0f * ((Rational)e.getValue(0)).floatValue()) / 5.8));
        }
        return 0.0f;
    }

    @Override
    public String getQuality() {
        Entry e = this.getTagValue(37122, true);
        if (e == null) {
            return "Unknown";
        }
        switch (((Rational)e.getValue(0)).intValue()) {
            case 1: {
                return "BASIC";
            }
            case 2: {
                return "NORMAL";
            }
            case 4: {
                return "FINE";
            }
        }
        return this.getTagValue(37122, true).toString();
    }

    public String getOrientation() {
        Entry e = this.getTagValue(274, true);
        int orientation = (Integer)e.getValue(0);
        if (orientation > 0 && orientation <= Naming.OrientationNames.length) {
            return Naming.OrientationNames[orientation - 1];
        }
        return "Unknown";
    }

    @Override
    public String getReport() {
        StringBuffer report = new StringBuffer();
        Entry e = this.getTagValue(33434, true);
        report.append("Shutter: ");
        if (e != null) {
            report.append(e.toString());
        } else {
            e = this.getTagValue(37377, true);
            if (e != null) {
                report.append(e.toString());
            } else {
                report.append("n/a");
            }
        }
        report.append(", Aperture: ");
        e = this.getTagValue(33437, true);
        if (e == null) {
            e = this.getTagValue(37378, true);
            if (e != null) {
                report.append(fnumberformat.format((double)((Rational)e.getValue(0)).floatValue() * 0.4 + 1.0));
            } else {
                report.append("n/a");
            }
        } else {
            report.append(fnumberformat.format(((Rational)e.getValue(0)).floatValue()));
        }
        report.append(", Flash: ");
        e = this.getTagValue(37385, true);
        if (e != null) {
            report.append((Integer)e.getValue(0) == 1 ? "yes" : "no");
        } else {
            report.append("n/a");
        }
        return report.toString();
    }

    @Override
    public void readInfo() {
        this.ifds = new IFD[2];
        this.offset -= this.data.length;
        this.intel = this.data[6] == 73;
        boolean bl = this.motorola = this.data[6] == 77;
        if (!this.intel && !this.motorola) {
            return;
        }
        this.version = this.s2n(8, 2);
        this.processAllIFDs();
        String msg = this.correctThumbnailTags(this.data, 0);
        if (msg != null && Log.debugLevel >= 2) {
            String string = String.valueOf(msg);
            System.err.println(string.length() != 0 ? "Warning: Exif Read: ".concat(string) : new String("Warning: Exif Read: "));
        }
        this.data = null;
    }

    public static int transformOrientationTag(int tag, int op) {
        int newTag = 0;
        if (tag >= 1 && tag <= 8) {
            int positions;
            int newPositions = positions = posForOrientationTags[tag];
            switch (op) {
                case 3: {
                    newPositions = positions & 0xCC | (positions & 3) << 4 | positions >> 4 & 3;
                    break;
                }
                case 4: {
                    newPositions = positions & 0x33 | (positions & 0xC) << 4 | (positions & 0xC0) >> 4;
                    break;
                }
                case 5: {
                    newPositions = positions >> 2 | (positions & 3) << 6;
                    break;
                }
                case 7: {
                    newPositions = (positions << 2 | positions >> 6) & 0xFF;
                    break;
                }
                case 6: {
                    newPositions = (positions & 0xF) << 4 | positions >> 4;
                    break;
                }
                case 1: {
                    newPositions = (positions & 0x30) << 2 | (positions & 0xC0) >> 2 | (positions & 3) << 2 | (positions & 0xC) >> 2;
                    break;
                }
                case 2: {
                    newPositions = (positions & 3) << 6 | (positions & 0xC) << 2 | (positions & 0x30) >> 2 | positions >> 6;
                    break;
                }
            }
            newTag = 0;
            while (posForOrientationTags[++newTag] != newPositions) {
            }
        }
        return newTag;
    }

    private void printIfds(IFD ifd, int level, PrintStream op) {
        if (ifd != null) {
            op.println(new StringBuilder(23).append("print Lvl = ").append(level).toString());
            Map m = ifd.getEntries();
            for (Integer key : m.keySet()) {
                int keyVal = key;
                Entry ent = (Entry)m.get(key);
                String string = Integer.toHexString(keyVal);
                int n = ent.getType();
                op.print(new StringBuilder(27 + String.valueOf(string).length()).append("Key = 0x").append(string).append(" Type = ").append(n).toString());
                Object[] vals = ent.getValues();
                if (vals != null) {
                    for (int i = 0; i < vals.length; ++i) {
                        int n2 = i;
                        String string2 = String.valueOf(vals[i]);
                        op.print(new StringBuilder(18 + String.valueOf(string2).length()).append(" Val").append(n2).append(" = ").append(string2).toString());
                    }
                } else {
                    String string3 = ent.toString();
                    op.print(new StringBuilder(2 + String.valueOf(string3).length()).append("'").append(string3).append("'").toString());
                }
                op.println();
            }
            IFD[] subIfds = ifd.getIFDs();
            if (subIfds != null) {
                for (int i = 0; i < subIfds.length; ++i) {
                    this.printIfds(subIfds[i], level + 1, op);
                }
            }
        }
    }

    @Override
    public void writeInfo(byte[] markerData, OutputStream out, int op, int options, boolean modifyImageInfo, int imageWidth, int imageHeight, String encoding) throws IOException {
        int newOrientation;
        Object val;
        int orientation;
        if (this.ifds == null) {
            throw new IllegalStateException("EXIF data not filled.");
        }
        Entry[] orgEntries = null;
        Object[] orgVals = null;
        int numOrgEntries = 0;
        Entry orientationEntry = null;
        Object orientationVal = null;
        if ((options & 0x10) != 0 && (orientationEntry = this.getTagValue(274, true)) != null && (orientation = ((Integer)(val = orientationEntry.getValue(0))).intValue()) != (newOrientation = Exif.transformOrientationTag(orientation, op))) {
            orientationVal = val;
            orientationEntry.setValue(0, new Integer(newOrientation));
        }
        boolean dimensionModified = false;
        Entry resX = null;
        Object xVal = null;
        Object yVal = null;
        Entry resY = this.getTagValue(40963, true);
        if (resY != null) {
            yVal = resY.getValue(0);
            resX = this.getTagValue(40962, true);
            if (resX != null) {
                xVal = resX.getValue(0);
                if (imageWidth > 0 && imageHeight > 0) {
                    Integer xVal1 = new Integer(imageWidth);
                    Integer yVal1 = new Integer(imageHeight);
                    dimensionModified = true;
                    resY.setValue(0, yVal1);
                    resX.setValue(0, xVal1);
                    if (modifyImageInfo) {
                        xVal = xVal1;
                        yVal = yVal1;
                    }
                }
            }
        }
        if (!modifyImageInfo) {
            orgEntries = new Entry[16];
            orgVals = new Object[orgEntries.length];
        }
        switch (op) {
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                if (!dimensionModified && resX != null && resY != null) {
                    dimensionModified = true;
                    resY.setValue(0, xVal);
                    resX.setValue(0, yVal);
                }
                for (int i = 0; i < 2; ++i) {
                    Entry eResX = this.getTagValue(282, i == 0);
                    Entry eResY = this.getTagValue(283, i == 0);
                    if (eResX == null || eResY == null) continue;
                    Object eResXVal = eResX.getValue(0);
                    Object eResYVal = eResY.getValue(0);
                    if (!modifyImageInfo) {
                        orgEntries[numOrgEntries] = eResX;
                        orgVals[numOrgEntries] = eResXVal;
                        orgEntries[++numOrgEntries] = eResY;
                        orgVals[numOrgEntries] = eResYVal;
                        ++numOrgEntries;
                    }
                    eResY.setValue(0, eResXVal);
                    eResX.setValue(0, eResYVal);
                }
                break;
            }
        }
        if (!modifyImageInfo) {
            Object val2;
            Entry e;
            if (orientationVal != null) {
                orgEntries[numOrgEntries] = orientationEntry;
                orgVals[numOrgEntries] = orientationVal;
                ++numOrgEntries;
            }
            if ((e = this.getTagValue(513, false)) != null) {
                val2 = e.getValue(0);
                orgEntries[numOrgEntries] = e;
                orgVals[numOrgEntries] = val2;
                ++numOrgEntries;
            }
            if ((e = this.getTagValue(514, false)) != null) {
                val2 = e.getValue(0);
                orgEntries[numOrgEntries] = e;
                orgVals[numOrgEntries] = val2;
                ++numOrgEntries;
            }
            if (dimensionModified) {
                orgEntries[numOrgEntries] = resX;
                orgVals[numOrgEntries] = xVal;
                orgEntries[++numOrgEntries] = resY;
                orgVals[numOrgEntries] = yVal;
                ++numOrgEntries;
            }
        }
        out.write(EXIF_MARK);
        if (this.intel) {
            out.write(73);
            out.write(73);
        } else {
            out.write(77);
            out.write(77);
        }
        out.write(this.n2s(this.version, 2));
        int emptySlot = EXIF_MARK.length + 2;
        out.write(this.n2s(emptySlot, 4));
        String msg = this.correctThumbnailTags(markerData, 4);
        if (msg != null && Log.debugLevel >= 2) {
            String string = String.valueOf(msg);
            System.err.println(string.length() != 0 ? "Warning: Exif Write: ".concat(string) : new String("Warning: Exif Write: "));
        }
        for (int k = 0; k < 2; ++k) {
            boolean isLast = false;
            if (k == 1 || this.ifds[k + 1] == null) {
                isLast = true;
            }
            emptySlot = this.writeIfd(markerData, out, emptySlot, this.ifds[k], op, options, isLast, encoding);
        }
        for (int i = 0; i < numOrgEntries; ++i) {
            Entry e = orgEntries[i];
            if (e == null) continue;
            e.setValue(0, orgVals[i]);
        }
    }

    @Override
    public boolean setThumbnail(byte[] newThumbnailData, int startIndex, int len, String thumbnailExt, OutputStream newExifOp) throws IOException {
        Entry ent;
        boolean retVal = true;
        if (this.ifds[1] == null) {
            this.ifds[1] = new IFD(1);
            ent = new Entry(3);
            ent.setValue(0, new Integer(2));
            this.ifds[1].addEntry(296, ent);
            ent = new Entry(5);
            ent.setValue(0, new Rational(180, 1));
            this.ifds[1].addEntry(282, ent);
            ent = new Entry(5);
            ent.setValue(0, new Rational(180, 1));
            this.ifds[1].addEntry(283, ent);
        }
        String ext = thumbnailExt.toLowerCase();
        ent = this.getTagValue(259, false);
        if (ent == null) {
            ent = new Entry(3);
            this.setTagValue(259, 0, ent, false);
        }
        boolean isJpegThumbnail = false;
        if ("jpeg".equals(ext) || "jpg".equals(ext)) {
            isJpegThumbnail = true;
            ent.setValue(0, new Integer(6));
            this.ifds[1].removeEntry(273);
            this.ifds[1].removeEntry(279);
            this.ifds[1].removeEntry(262);
            ent = this.getTagValue(513, false);
            if (ent == null) {
                ent = new Entry(4);
                this.setTagValue(513, 0, ent, false);
            }
            ent.setValue(0, new Integer(startIndex - 4 - 6));
            ent = this.getTagValue(514, false);
            if (ent == null) {
                ent = new Entry(4);
                this.setTagValue(514, 0, ent, false);
            }
            ent.setValue(0, new Integer(len));
        } else {
            ent.setValue(0, new Integer(1));
            this.ifds[1].removeEntry(513);
            this.ifds[1].removeEntry(514);
            ent = this.getTagValue(273, false);
            if (ent == null) {
                ent = new Entry(4);
                this.setTagValue(273, 0, ent, false);
            }
            ent.setValue(0, new Integer(startIndex - 4 - 6));
            ent = this.getTagValue(279, false);
            if (ent == null) {
                ent = new Entry(4);
                this.setTagValue(279, 0, ent, false);
            }
            ent.setValue(0, new Integer(len));
        }
        this.writeInfo(newThumbnailData, newExifOp, 0, 0, true);
        if (isJpegThumbnail) {
            if (this.getTagValue(513, false) == null) {
                retVal = false;
            }
        } else if (this.getTagValue(273, false) == null) {
            retVal = false;
        }
        return retVal;
    }

    @Override
    public boolean removeThumbnailTags() {
        IFD ifd = this.ifds[1];
        if (ifd != null) {
            this.ifds[1].removeEntry(513);
            this.ifds[1].removeEntry(514);
            this.ifds[1].removeEntry(273);
            this.ifds[1].removeEntry(279);
            this.ifds[1].removeEntry(262);
        }
        return true;
    }

    private String correctThumbnailTags(byte[] markerData, int leading) {
        String retVal = null;
        boolean thumbnailTagsPresent = false;
        boolean isJpegThumbnail = false;
        int offsetTagVal = 0;
        int offset = 0;
        Entry offsetEnt = this.getTagValue(513, false);
        if (offsetEnt == null) {
            offsetEnt = this.getTagValue(273, false);
        } else {
            isJpegThumbnail = true;
        }
        if (offsetEnt != null) {
            thumbnailTagsPresent = true;
            offsetTagVal = (Integer)offsetEnt.getValue(0);
            offset = offsetTagVal + 6 + leading;
        }
        int length = 0;
        Entry lengthEnt = this.getTagValue(514, false);
        if (lengthEnt == null) {
            lengthEnt = this.getTagValue(279, false);
        } else {
            isJpegThumbnail = true;
        }
        if (lengthEnt != null) {
            length = (Integer)lengthEnt.getValue(0);
            thumbnailTagsPresent = true;
        }
        int orgLen = length;
        if (thumbnailTagsPresent) {
            int lengthOvershoot = 0;
            int skipCount = 0;
            StringBuffer warnBuf = new StringBuffer();
            if (markerData == null) {
                retVal = "Removing Thumbnail: No Marker Supplied";
            } else if (offset < 0 || offset > markerData.length) {
                int n = offset;
                retVal = new StringBuilder(47).append("Removing Thumbnail: Invalid Offset: ").append(n).toString();
            } else {
                lengthOvershoot = offset + length - markerData.length;
                if (lengthOvershoot > 0) {
                    warnBuf.append("; Thumbnail length ").append(orgLen).append(" is beyond Exif header. Reducing it to ").append(length -= lengthOvershoot);
                }
            }
            if (retVal == null) {
                if (isJpegThumbnail) {
                    while (offset < markerData.length - 1 && length > 0 && (markerData[offset] != -1 || markerData[offset + 1] != -40)) {
                        --length;
                        ++offset;
                        ++skipCount;
                    }
                    if (skipCount > 0) {
                        offsetTagVal += skipCount;
                        warnBuf.append("; Skipped ").append(skipCount).append(" Garbage bytes at the beginning of Jpeg Thumbnail");
                    }
                }
                if (length <= 100) {
                    warnBuf.append("; Removing Thumbnail: Invalid length: ").append(length);
                    retVal = warnBuf.substring(2);
                }
            }
            if (retVal != null) {
                this.removeThumbnailTags();
            } else if (lengthOvershoot > 0 || skipCount > 0) {
                retVal = warnBuf.substring(2);
                lengthEnt.setValue(0, new Integer(length));
                offsetEnt.setValue(0, new Integer(offsetTagVal));
            }
            warnBuf = null;
        }
        return retVal;
    }

    protected int writeIfd(byte[] markerData, OutputStream out, int emptySlot, IFD ifd, int op, int options, boolean isLast, String encoding) throws IOException {
        ByteArrayOutputStream buf;
        block29: {
            if (ifd == null) {
                if (Log.debugLevel >= 2) {
                    System.err.println("Warning: Requested to write NULL IFD, nothing written.");
                }
                return emptySlot;
            }
            buf = new ByteArrayOutputStream(1024);
            int ne = (ifd.getEntries() == null ? 0 : ifd.getEntries().size()) + (ifd.getIFDs() == null ? 0 : ifd.getIFDs().length);
            out.write(this.n2s(ne, 2));
            emptySlot += ne * 12 + 2 + 4;
            Iterator it = ifd.getEntries().entrySet().iterator();
            boolean foundJpegThumbnailTag = false;
            boolean foundBmpThumbnailTag = false;
            while (it.hasNext()) {
                int i;
                Entry e;
                Map.Entry me = it.next();
                int tag = (Integer)me.getKey();
                if (tag == 513) {
                    foundJpegThumbnailTag = true;
                    continue;
                }
                if (tag == 514) continue;
                if (tag == 273) {
                    foundBmpThumbnailTag = true;
                    continue;
                }
                if (tag == 279 || (e = (Entry)me.getValue()) == null) continue;
                out.write(this.n2s(tag, 2));
                int type = e.getType();
                out.write(this.n2s(type, 2));
                if (type == 2) {
                    byte[] str = e.toString().getBytes(encoding);
                    out.write(this.n2s(str.length + 1, 4));
                    if (str.length + 1 > 4) {
                        out.write(this.n2s(emptySlot, 4));
                        buf.write(str);
                        buf.write(0);
                        emptySlot += str.length + 1;
                        continue;
                    }
                    out.write(str);
                    if (str.length >= 4) continue;
                    for (int i2 = 0; i2 < 4 - str.length; ++i2) {
                        out.write(0);
                    }
                    continue;
                }
                Object[] vs = e.getValues();
                out.write(this.n2s(vs.length, 4));
                int tlen = TYPELENGTH[type - 1];
                if (vs.length * tlen > 4) {
                    out.write(this.n2s(emptySlot, 4));
                    boolean signed = true;
                    boolean rational = type % 5 == 0;
                    for (int i3 = 0; i3 < vs.length; ++i3) {
                        if (rational) {
                            buf.write(this.n2s(((Rational)vs[i3]).getNum(), 4));
                            buf.write(this.n2s(((Rational)vs[i3]).getDen(), 4));
                            emptySlot += 8;
                            continue;
                        }
                        buf.write(this.n2s((Integer)vs[i3], tlen));
                        emptySlot += tlen;
                    }
                    continue;
                }
                for (i = 0; i < vs.length; ++i) {
                    out.write(this.n2s((Integer)vs[i], tlen));
                }
                if (vs.length * tlen >= 4) continue;
                for (i = 0; i < 4 - vs.length * tlen; ++i) {
                    out.write(0);
                }
            }
            if (foundJpegThumbnailTag) {
                int length = this.getThumbnailLength();
                int jpeg_offset = this.getThumbnailOffset() + 4;
                try {
                    int l = buf.size();
                    boolean copyThumbnail = true;
                    if ((options & 2) != 0 && op != 0 && op != 8) {
                        LLJTran ljt;
                        block28: {
                            ljt = null;
                            try {
                                ByteArrayInputStream tis = new ByteArrayInputStream(markerData, jpeg_offset, length);
                                ljt = new LLJTran(tis);
                                ljt.read(3, false);
                                ljt.transform(op, 0);
                                copyThumbnail = false;
                                tis = null;
                            }
                            catch (Throwable e) {
                                if (Log.debugLevel < 2) break block28;
                                String string = String.valueOf(e.getMessage());
                                System.err.println(string.length() != 0 ? "Warning: Unable to Transform Thumbnail, will write it unchanged: ".concat(string) : new String("Warning: Unable to Transform Thumbnail, will write it unchanged: "));
                                e.printStackTrace(System.err);
                            }
                        }
                        if (!copyThumbnail) {
                            ljt.save(buf, 0);
                        }
                    }
                    if (copyThumbnail) {
                        buf.write(markerData, jpeg_offset, length);
                    }
                    l = buf.size() - l;
                    Entry ent = this.getTagValue(514, false);
                    if (ent != null) {
                        ent.setValue(0, new Integer(l));
                    }
                    out.write(this.n2s(514, 2));
                    out.write(this.n2s(4, 2));
                    out.write(this.n2s(1, 4));
                    out.write(this.n2s(l, 4));
                    ent = this.getTagValue(513, false);
                    ent.setValue(0, new Integer(emptySlot));
                    out.write(this.n2s(513, 2));
                    out.write(this.n2s(ent.getType(), 2));
                    out.write(this.n2s(1, 4));
                    out.write(this.n2s(emptySlot, 4));
                    emptySlot += l;
                }
                catch (Throwable t) {
                    if (Log.debugLevel >= 1) {
                        t.printStackTrace(System.err);
                    }
                    break block29;
                }
            }
            if (foundBmpThumbnailTag) {
                int length = this.getThumbnailLength();
                int offset = this.getThumbnailOffset() + 4;
                try {
                    int l = buf.size();
                    buf.write(markerData, offset, length);
                    l = buf.size() - l;
                    Entry ent = this.getTagValue(279, false);
                    if (ent != null) {
                        ent.setValue(0, new Integer(l));
                    }
                    out.write(this.n2s(279, 2));
                    out.write(this.n2s(4, 2));
                    out.write(this.n2s(1, 4));
                    out.write(this.n2s(l, 4));
                    ent = this.getTagValue(273, false);
                    ent.setValue(0, new Integer(emptySlot));
                    out.write(this.n2s(273, 2));
                    out.write(this.n2s(ent.getType(), 2));
                    out.write(this.n2s(1, 4));
                    out.write(this.n2s(emptySlot, 4));
                    emptySlot += l;
                }
                catch (Throwable t) {
                    if (Log.debugLevel < 1) break block29;
                    t.printStackTrace(System.err);
                }
            }
        }
        IFD[] ifds = ifd.getIFDs();
        int k = 0;
        while (ifds != null && k < ifds.length) {
            IFD ifd1 = ifds[k];
            out.write(this.n2s(ifd1.getTag(), 2));
            out.write(this.n2s(ifd1.getType(), 2));
            out.write(this.n2s(1, 4));
            out.write(this.n2s(emptySlot, 4));
            emptySlot = this.writeIfd(markerData, buf, emptySlot, ifd1, op, options, ++k == ifds.length, encoding);
        }
        out.write(this.n2s(isLast ? 0 : emptySlot, 4));
        buf.writeTo(out);
        return emptySlot;
    }

    protected int firstIFD() {
        return this.s2n(10, 4) + 6;
    }

    protected int nextIFD(int ifd) {
        int entries = this.s2n(ifd, 2);
        return this.s2n(ifd + 2 + 12 * entries, 4) + 6;
    }

    protected void processAllIFDs() {
        int i = this.firstIFD();
        for (int iifd = 0; i > 6 && iifd < 2; ++iifd) {
            this.ifds[iifd] = new IFD(iifd);
            this.storeIFD(i, this.ifds[iifd]);
            i = this.nextIFD(i);
        }
    }

    protected void storeIFD(int ifdoffset, IFD ifd) {
        int entries = this.s2n(ifdoffset, 2);
        for (int i = 0; i < entries; ++i) {
            int entry = ifdoffset + 2 + 12 * i;
            int tag = this.s2n(entry, 2);
            int type = this.s2n(entry + 2, 2);
            if (type < 1 || type > 10) continue;
            int typelen = TYPELENGTH[type - 1];
            int count = this.s2n(entry + 4, 4);
            int offset = entry + 8;
            if (count * typelen > 4) {
                offset = this.s2n(offset, 4) + 6;
            }
            if (type == 2) {
                try {
                    ifd.addEntry(tag, new Entry(type, new String(this.data, offset, count - 1, "Default")));
                }
                catch (UnsupportedEncodingException e) {
                    if (Log.debugLevel < 1) continue;
                    String string = String.valueOf(e);
                    System.err.println(new StringBuilder(22 + String.valueOf(string).length()).append("storeIFD: getString() ").append(string).toString());
                }
                continue;
            }
            Object[] values = new Object[count];
            boolean signed = true;
            for (int j = 0; j < count; ++j) {
                values[j] = type % 5 != 0 ? new Integer(this.s2n(offset, typelen, signed)) : new Rational(this.s2n(offset, 4, signed), this.s2n(offset + 4, 4, signed));
                offset += typelen;
                if ((tag == 34665 || tag == 40965 || tag == 34853) && j == 0 && (Integer)values[0] > 0) {
                    IFD iifd = new IFD(tag, type);
                    this.storeIFD((Integer)values[0] + 6, iifd);
                    ifd.addIFD(iifd);
                    continue;
                }
                ifd.addEntry(tag, new Entry(type, values));
            }
        }
    }

    public IFD[] getIFDs() {
        return this.ifds;
    }
}

