/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreElements;
import com.google.auto.factory.AutoFactory;
import com.google.auto.factory.processor.AnnotationValues;
import com.google.auto.factory.processor.AutoValue_AutoFactoryDeclaration;
import com.google.auto.factory.processor.Elements2;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

@AutoValue
abstract class AutoFactoryDeclaration {
    AutoFactoryDeclaration() {
    }

    abstract TypeElement targetType();

    abstract Element target();

    abstract Optional<String> className();

    abstract TypeElement extendingType();

    abstract ImmutableSet<TypeElement> implementingTypes();

    abstract boolean allowSubclasses();

    abstract AnnotationMirror mirror();

    abstract ImmutableMap<String, AnnotationValue> valuesMap();

    String getFactoryName() {
        Name packageName = MoreElements.getPackage((Element)this.targetType()).getQualifiedName();
        StringBuilder builder = new StringBuilder(packageName);
        if (packageName.length() > 0) {
            builder.append('.');
        }
        if (this.className().isPresent()) {
            builder.append((String)this.className().get());
        } else {
            for (String enclosingSimpleName : this.targetEnclosingSimpleNames()) {
                builder.append(enclosingSimpleName).append('_');
            }
            builder.append(this.targetType().getSimpleName()).append("Factory");
        }
        return builder.toString();
    }

    private ImmutableList<String> targetEnclosingSimpleNames() {
        ImmutableList.Builder simpleNames = ImmutableList.builder();
        Element element = this.targetType().getEnclosingElement();
        while (!element.getKind().equals((Object)ElementKind.PACKAGE)) {
            simpleNames.add((Object)element.getSimpleName().toString());
            element = element.getEnclosingElement();
        }
        return simpleNames.build().reverse();
    }

    static final class Factory {
        private final Elements elements;
        private final Messager messager;

        Factory(Elements elements, Messager messager) {
            this.elements = elements;
            this.messager = messager;
        }

        Optional<AutoFactoryDeclaration> createIfValid(Element element) {
            Preconditions.checkNotNull((Object)element);
            AnnotationMirror mirror = (AnnotationMirror)Mirrors.getAnnotationMirror(element, AutoFactory.class).get();
            Preconditions.checkArgument((boolean)Mirrors.getQualifiedName(mirror.getAnnotationType()).contentEquals(AutoFactory.class.getName()));
            ImmutableMap<String, AnnotationValue> values = Mirrors.simplifyAnnotationValueMap(this.elements.getElementValuesWithDefaults(mirror));
            Preconditions.checkState((values.size() == 4 ? 1 : 0) != 0);
            AnnotationValue classNameValue = (AnnotationValue)values.get("className");
            String className = classNameValue.getValue().toString();
            if (!className.isEmpty() && !Factory.isValidIdentifier(className)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("\"%s\" is not a valid Java identifier", className), element, mirror, classNameValue);
                return Optional.absent();
            }
            AnnotationValue extendingValue = (AnnotationValue)Preconditions.checkNotNull(values.get("extending"));
            TypeElement extendingType = AnnotationValues.asType(extendingValue);
            if (extendingType == null) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Unable to find the type: " + extendingValue.getValue().toString(), element, mirror, extendingValue);
                return Optional.absent();
            }
            if (!Elements2.isValidSupertypeForClass(extendingType)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a valid supertype for a factory. Supertypes must be non-final classes.", extendingType.getQualifiedName()), element, mirror, extendingValue);
                return Optional.absent();
            }
            ImmutableList noParameterConstructors = FluentIterable.from(ElementFilter.constructorsIn(extendingType.getEnclosedElements())).filter((Predicate)new Predicate<ExecutableElement>(){

                public boolean apply(ExecutableElement constructor) {
                    return constructor.getParameters().isEmpty();
                }
            }).toList();
            if (noParameterConstructors.size() == 0) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format("%s is not a valid supertype for a factory. Factory supertypes must have a no-arg constructor.", extendingType.getQualifiedName()), element, mirror, extendingValue);
                return Optional.absent();
            }
            if (noParameterConstructors.size() > 1) {
                throw new IllegalStateException("Multiple constructors with no parameters??");
            }
            AnnotationValue implementingValue = (AnnotationValue)Preconditions.checkNotNull(values.get("implementing"));
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AnnotationValue implementingTypeValue : AnnotationValues.asList(implementingValue)) {
                builder.add((Object)AnnotationValues.asType(implementingTypeValue));
            }
            ImmutableSet implementingTypes = builder.build();
            AnnotationValue allowSubclassesValue = (AnnotationValue)Preconditions.checkNotNull(values.get("allowSubclasses"));
            boolean allowSubclasses = AnnotationValues.asBoolean(allowSubclassesValue);
            return Optional.of((Object)new AutoValue_AutoFactoryDeclaration(Factory.getAnnotatedType(element), element, (Optional<String>)(className.isEmpty() ? Optional.absent() : Optional.of((Object)className)), extendingType, (ImmutableSet<TypeElement>)implementingTypes, allowSubclasses, mirror, (ImmutableMap<String, AnnotationValue>)ImmutableMap.copyOf(values)));
        }

        private static TypeElement getAnnotatedType(Element element) {
            Object types = ImmutableList.of();
            while (types.isEmpty()) {
                types = ElementFilter.typesIn(Arrays.asList(element));
                element = element.getEnclosingElement();
            }
            return (TypeElement)Iterables.getOnlyElement((Iterable)types);
        }

        static boolean isValidIdentifier(String identifier) {
            return SourceVersion.isIdentifier(identifier) && !SourceVersion.isKeyword(identifier);
        }
    }
}

