/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.factory.processor.AutoFactoryDeclaration;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.Parameter;
import com.google.common.collect.ImmutableSet;
import javax.lang.model.type.TypeMirror;

final class AutoValue_FactoryMethodDescriptor
extends FactoryMethodDescriptor {
    private final AutoFactoryDeclaration declaration;
    private final String name;
    private final TypeMirror returnType;
    private final boolean publicMethod;
    private final boolean overridingMethod;
    private final ImmutableSet<Parameter> passedParameters;
    private final ImmutableSet<Parameter> providedParameters;
    private final ImmutableSet<Parameter> creationParameters;
    private final boolean isVarArgs;

    private AutoValue_FactoryMethodDescriptor(AutoFactoryDeclaration declaration, String name, TypeMirror returnType, boolean publicMethod, boolean overridingMethod, ImmutableSet<Parameter> passedParameters, ImmutableSet<Parameter> providedParameters, ImmutableSet<Parameter> creationParameters, boolean isVarArgs) {
        this.declaration = declaration;
        this.name = name;
        this.returnType = returnType;
        this.publicMethod = publicMethod;
        this.overridingMethod = overridingMethod;
        this.passedParameters = passedParameters;
        this.providedParameters = providedParameters;
        this.creationParameters = creationParameters;
        this.isVarArgs = isVarArgs;
    }

    @Override
    AutoFactoryDeclaration declaration() {
        return this.declaration;
    }

    @Override
    String name() {
        return this.name;
    }

    @Override
    TypeMirror returnType() {
        return this.returnType;
    }

    @Override
    boolean publicMethod() {
        return this.publicMethod;
    }

    @Override
    boolean overridingMethod() {
        return this.overridingMethod;
    }

    @Override
    ImmutableSet<Parameter> passedParameters() {
        return this.passedParameters;
    }

    @Override
    ImmutableSet<Parameter> providedParameters() {
        return this.providedParameters;
    }

    @Override
    ImmutableSet<Parameter> creationParameters() {
        return this.creationParameters;
    }

    @Override
    boolean isVarArgs() {
        return this.isVarArgs;
    }

    public String toString() {
        return "FactoryMethodDescriptor{declaration=" + this.declaration + ", name=" + this.name + ", returnType=" + this.returnType + ", publicMethod=" + this.publicMethod + ", overridingMethod=" + this.overridingMethod + ", passedParameters=" + this.passedParameters + ", providedParameters=" + this.providedParameters + ", creationParameters=" + this.creationParameters + ", isVarArgs=" + this.isVarArgs + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FactoryMethodDescriptor) {
            FactoryMethodDescriptor that = (FactoryMethodDescriptor)o;
            return this.declaration.equals(that.declaration()) && this.name.equals(that.name()) && this.returnType.equals(that.returnType()) && this.publicMethod == that.publicMethod() && this.overridingMethod == that.overridingMethod() && this.passedParameters.equals(that.passedParameters()) && this.providedParameters.equals(that.providedParameters()) && this.creationParameters.equals(that.creationParameters()) && this.isVarArgs == that.isVarArgs();
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.declaration.hashCode();
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.returnType.hashCode();
        h *= 1000003;
        h ^= this.publicMethod ? 1231 : 1237;
        h *= 1000003;
        h ^= this.overridingMethod ? 1231 : 1237;
        h *= 1000003;
        h ^= this.passedParameters.hashCode();
        h *= 1000003;
        h ^= this.providedParameters.hashCode();
        h *= 1000003;
        h ^= this.creationParameters.hashCode();
        h *= 1000003;
        return h ^= this.isVarArgs ? 1231 : 1237;
    }

    @Override
    FactoryMethodDescriptor.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends FactoryMethodDescriptor.Builder {
        private AutoFactoryDeclaration declaration;
        private String name;
        private TypeMirror returnType;
        private Boolean publicMethod;
        private Boolean overridingMethod;
        private ImmutableSet<Parameter> passedParameters;
        private ImmutableSet<Parameter> providedParameters;
        private ImmutableSet<Parameter> creationParameters;
        private Boolean isVarArgs;

        Builder() {
        }

        private Builder(FactoryMethodDescriptor source) {
            this.declaration = source.declaration();
            this.name = source.name();
            this.returnType = source.returnType();
            this.publicMethod = source.publicMethod();
            this.overridingMethod = source.overridingMethod();
            this.passedParameters = source.passedParameters();
            this.providedParameters = source.providedParameters();
            this.creationParameters = source.creationParameters();
            this.isVarArgs = source.isVarArgs();
        }

        @Override
        FactoryMethodDescriptor.Builder declaration(AutoFactoryDeclaration declaration) {
            if (declaration == null) {
                throw new NullPointerException("Null declaration");
            }
            this.declaration = declaration;
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder name(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder returnType(TypeMirror returnType) {
            if (returnType == null) {
                throw new NullPointerException("Null returnType");
            }
            this.returnType = returnType;
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder publicMethod(boolean publicMethod) {
            this.publicMethod = publicMethod;
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder overridingMethod(boolean overridingMethod) {
            this.overridingMethod = overridingMethod;
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder passedParameters(Iterable<Parameter> passedParameters) {
            if (passedParameters == null) {
                throw new NullPointerException("Null passedParameters");
            }
            this.passedParameters = ImmutableSet.copyOf(passedParameters);
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder providedParameters(Iterable<Parameter> providedParameters) {
            if (providedParameters == null) {
                throw new NullPointerException("Null providedParameters");
            }
            this.providedParameters = ImmutableSet.copyOf(providedParameters);
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder creationParameters(Iterable<Parameter> creationParameters) {
            if (creationParameters == null) {
                throw new NullPointerException("Null creationParameters");
            }
            this.creationParameters = ImmutableSet.copyOf(creationParameters);
            return this;
        }

        @Override
        FactoryMethodDescriptor.Builder isVarArgs(boolean isVarArgs) {
            this.isVarArgs = isVarArgs;
            return this;
        }

        @Override
        FactoryMethodDescriptor buildImpl() {
            String missing = "";
            if (this.declaration == null) {
                missing = missing + " declaration";
            }
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.returnType == null) {
                missing = missing + " returnType";
            }
            if (this.publicMethod == null) {
                missing = missing + " publicMethod";
            }
            if (this.overridingMethod == null) {
                missing = missing + " overridingMethod";
            }
            if (this.passedParameters == null) {
                missing = missing + " passedParameters";
            }
            if (this.providedParameters == null) {
                missing = missing + " providedParameters";
            }
            if (this.creationParameters == null) {
                missing = missing + " creationParameters";
            }
            if (this.isVarArgs == null) {
                missing = missing + " isVarArgs";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FactoryMethodDescriptor(this.declaration, this.name, this.returnType, this.publicMethod, this.overridingMethod, this.passedParameters, this.providedParameters, this.creationParameters, this.isVarArgs);
        }
    }
}

