/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.AutoValue_FactoryDescriptor;
import com.google.auto.factory.processor.FactoryMethodDescriptor;
import com.google.auto.factory.processor.ImplementationMethodDescriptor;
import com.google.auto.factory.processor.Key;
import com.google.auto.factory.processor.Parameter;
import com.google.auto.factory.processor.ProviderField;
import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.TypeMirror;

@AutoValue
abstract class FactoryDescriptor {
    private static final CharMatcher invalidIdentifierCharacters = new CharMatcher(){

        public boolean matches(char c) {
            return !Character.isJavaIdentifierPart(c);
        }
    };

    FactoryDescriptor() {
    }

    abstract String name();

    abstract TypeMirror extendingType();

    abstract ImmutableSet<TypeMirror> implementingTypes();

    abstract boolean publicType();

    abstract ImmutableSet<FactoryMethodDescriptor> methodDescriptors();

    abstract ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors();

    abstract boolean allowSubclasses();

    abstract ImmutableMap<Key, ProviderField> providers();

    static FactoryDescriptor create(String name, TypeMirror extendingType, ImmutableSet<TypeMirror> implementingTypes, boolean publicType, ImmutableSet<FactoryMethodDescriptor> methodDescriptors, ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors, boolean allowSubclasses) {
        ImmutableSetMultimap.Builder parametersForProviders = ImmutableSetMultimap.builder();
        for (FactoryMethodDescriptor descriptor : methodDescriptors) {
            for (Parameter parameter : descriptor.providedParameters()) {
                parametersForProviders.put((Object)parameter.key(), (Object)parameter);
            }
        }
        ImmutableMap.Builder providersBuilder = ImmutableMap.builder();
        UniqueNameSet uniqueNames = new UniqueNameSet();
        block6: for (Map.Entry entry : parametersForProviders.build().asMap().entrySet()) {
            Key key = (Key)entry.getKey();
            switch (((Collection)entry.getValue()).size()) {
                case 0: {
                    throw new AssertionError();
                }
                case 1: {
                    Parameter parameter = (Parameter)Iterables.getOnlyElement((Iterable)((Iterable)entry.getValue()));
                    providersBuilder.put((Object)key, (Object)ProviderField.create(uniqueNames.getUniqueName(parameter.name() + "Provider"), key, parameter.nullable()));
                    continue block6;
                }
            }
            String providerName = uniqueNames.getUniqueName(invalidIdentifierCharacters.replaceFrom((CharSequence)key.toString(), '_') + "Provider");
            Optional nullable = Optional.absent();
            for (Parameter param : (Collection)entry.getValue()) {
                nullable = nullable.or(param.nullable());
            }
            providersBuilder.put((Object)key, (Object)ProviderField.create(providerName, key, (Optional<AnnotationMirror>)nullable));
        }
        ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> duplicateMethodDescriptors = FactoryDescriptor.createDuplicateMethodDescriptorsBiMap(methodDescriptors, implementationMethodDescriptors);
        ImmutableSet<FactoryMethodDescriptor> deduplicatedMethodDescriptors = FactoryDescriptor.getDeduplicatedMethodDescriptors(methodDescriptors, duplicateMethodDescriptors);
        ImmutableSet deduplicatedImplementationMethodDescriptors = ImmutableSet.copyOf((Collection)Sets.difference(implementationMethodDescriptors, (Set)duplicateMethodDescriptors.values()));
        return new AutoValue_FactoryDescriptor(name, extendingType, implementingTypes, publicType, deduplicatedMethodDescriptors, (ImmutableSet<ImplementationMethodDescriptor>)deduplicatedImplementationMethodDescriptors, allowSubclasses, (ImmutableMap<Key, ProviderField>)providersBuilder.build());
    }

    private static ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> createDuplicateMethodDescriptorsBiMap(ImmutableSet<FactoryMethodDescriptor> factoryMethodDescriptors, ImmutableSet<ImplementationMethodDescriptor> implementationMethodDescriptors) {
        ImmutableBiMap.Builder builder = ImmutableBiMap.builder();
        block0: for (FactoryMethodDescriptor factoryMethodDescriptor : factoryMethodDescriptors) {
            for (ImplementationMethodDescriptor implementationMethodDescriptor : implementationMethodDescriptors) {
                boolean areDuplicateMethodDescriptors = FactoryDescriptor.areDuplicateMethodDescriptors(factoryMethodDescriptor, implementationMethodDescriptor);
                if (!areDuplicateMethodDescriptors) continue;
                builder.put((Object)factoryMethodDescriptor, (Object)implementationMethodDescriptor);
                continue block0;
            }
        }
        return builder.build();
    }

    private static ImmutableSet<FactoryMethodDescriptor> getDeduplicatedMethodDescriptors(ImmutableSet<FactoryMethodDescriptor> methodDescriptors, ImmutableBiMap<FactoryMethodDescriptor, ImplementationMethodDescriptor> duplicateMethodDescriptors) {
        ImmutableSet.Builder deduplicatedMethodDescriptors = ImmutableSet.builder();
        for (FactoryMethodDescriptor methodDescriptor : methodDescriptors) {
            ImplementationMethodDescriptor duplicateMethodDescriptor = (ImplementationMethodDescriptor)duplicateMethodDescriptors.get((Object)methodDescriptor);
            FactoryMethodDescriptor newMethodDescriptor = duplicateMethodDescriptor != null ? methodDescriptor.toBuilder().overridingMethod(true).publicMethod(duplicateMethodDescriptor.publicMethod()).returnType(duplicateMethodDescriptor.returnType()).build() : methodDescriptor;
            deduplicatedMethodDescriptors.add((Object)newMethodDescriptor);
        }
        return deduplicatedMethodDescriptors.build();
    }

    private static boolean areDuplicateMethodDescriptors(FactoryMethodDescriptor factory, ImplementationMethodDescriptor implementation) {
        if (!factory.name().equals(implementation.name())) {
            return false;
        }
        return MoreTypes.equivalence().pairwise().equivalent((Object)Iterables.transform(factory.passedParameters(), Parameter.TYPE), (Object)Iterables.transform(implementation.passedParameters(), Parameter.TYPE));
    }

    private static class UniqueNameSet {
        private final Set<String> uniqueNames = new HashSet<String>();

        private UniqueNameSet() {
        }

        String getUniqueName(CharSequence base) {
            String name = base.toString();
            int differentiator = 2;
            while (!this.uniqueNames.add(name)) {
                name = base.toString() + differentiator;
                ++differentiator;
            }
            return name;
        }
    }
}

