/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.factory.processor;

import com.google.auto.common.AnnotationMirrors;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.google.auto.factory.processor.AutoValue_Key;
import com.google.auto.factory.processor.Mirrors;
import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

@AutoValue
abstract class Key {
    Key() {
    }

    abstract TypeMirror type();

    abstract Optional<Equivalence.Wrapper<AnnotationMirror>> qualifierWrapper();

    Optional<AnnotationMirror> qualifier() {
        return Mirrors.unwrapOptionalEquivalence(this.qualifierWrapper());
    }

    static Key create(TypeMirror type, Iterable<? extends AnnotationMirror> annotations, Types types) {
        ImmutableSet.Builder qualifiers = ImmutableSet.builder();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!MoreElements.isAnnotationPresent((Element)annotationMirror.getAnnotationType().asElement(), Qualifier.class)) continue;
            qualifiers.add((Object)annotationMirror);
        }
        Optional qualifier = FluentIterable.from((Iterable)qualifiers.build()).first();
        TypeMirror typeMirror = Mirrors.isProvider(type) ? MoreTypes.asDeclared((TypeMirror)type).getTypeArguments().get(0) : Key.boxedType(type, types);
        return new AutoValue_Key(typeMirror, Mirrors.wrapOptionalInEquivalence(AnnotationMirrors.equivalence(), qualifier));
    }

    private static TypeMirror boxedType(TypeMirror type, Types types) {
        return type.getKind().isPrimitive() ? types.boxedClass(MoreTypes.asPrimitiveType((TypeMirror)type)).asType() : type;
    }

    public String toString() {
        String typeQualifiedName = MoreTypes.asTypeElement((TypeMirror)this.type()).toString();
        return this.qualifier().isPresent() ? this.qualifier().get() + "/" + typeQualifiedName : typeQualifiedName;
    }
}

